/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.async;

import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.CarefulRunnableQueue;
import com.mchange.v2.async.Queuable;
import com.mchange.v2.async.RunnableQueue;
import com.mchange.v2.util.ResourceClosedException;

public class RoundRobinAsynchronousRunner
implements AsynchronousRunner,
Queuable {
    final RunnableQueue[] rqs;
    int task_turn = 0;
    int view_turn = 0;

    public RoundRobinAsynchronousRunner(int num_threads, boolean daemon) {
        this.rqs = new RunnableQueue[num_threads];
        for (int i = 0; i < num_threads; ++i) {
            this.rqs[i] = new CarefulRunnableQueue(daemon, false);
        }
    }

    public synchronized void postRunnable(Runnable r) {
        try {
            int index = this.task_turn;
            this.task_turn = (this.task_turn + 1) % this.rqs.length;
            this.rqs[index].postRunnable(r);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            this.close(true);
            throw new ResourceClosedException("Attempted to use a RoundRobinAsynchronousRunner in a closed or broken state.");
        }
    }

    public synchronized RunnableQueue asRunnableQueue() {
        try {
            int index = this.view_turn;
            this.view_turn = (this.view_turn + 1) % this.rqs.length;
            return new RunnableQueueView(index);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            this.close(true);
            throw new ResourceClosedException("Attempted to use a RoundRobinAsynchronousRunner in a closed or broken state.");
        }
    }

    public synchronized void close(boolean skip_remaining_tasks) {
        int len = this.rqs.length;
        for (int i = 0; i < len; ++i) {
            RoundRobinAsynchronousRunner.attemptClose(this.rqs[i], skip_remaining_tasks);
            this.rqs[i] = null;
        }
    }

    public void close() {
        this.close(true);
    }

    static void attemptClose(RunnableQueue rq, boolean skip_remaining_tasks) {
        try {
            rq.close(skip_remaining_tasks);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class RunnableQueueView
    implements RunnableQueue {
        final int rq_num;

        RunnableQueueView(int rq_num) {
            this.rq_num = rq_num;
        }

        public void postRunnable(Runnable r) {
            RoundRobinAsynchronousRunner.this.rqs[this.rq_num].postRunnable(r);
        }

        public void close(boolean skip_remaining_tasks) {
        }

        public void close() {
        }
    }
}

