/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.search.StringTerm;

public final class BodyTerm
extends StringTerm {
    private static final long serialVersionUID = -4888862527916911385L;

    public BodyTerm(String string) {
        super(string);
    }

    public boolean match(Message message) {
        return this.matchPart(message);
    }

    private boolean matchPart(Part part) {
        try {
            if (part.isMimeType("text/*")) {
                String string = (String)part.getContent();
                if (string == null) {
                    return false;
                }
                return super.match(string);
            }
            if (part.isMimeType("multipart/*")) {
                Multipart multipart = (Multipart)part.getContent();
                int n = multipart.getCount();
                int n2 = 0;
                while (n2 < n) {
                    if (this.matchPart(multipart.getBodyPart(n2))) {
                        return true;
                    }
                    ++n2;
                }
            } else if (part.isMimeType("message/rfc822")) {
                return this.matchPart((Part)part.getContent());
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BodyTerm)) {
            return false;
        }
        return super.equals(object);
    }
}

