/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.io.Serializable;

public class ConnectionReleaseMode
implements Serializable {
    public static final ConnectionReleaseMode AFTER_STATEMENT = new ConnectionReleaseMode("after_statement");
    public static final ConnectionReleaseMode AFTER_TRANSACTION = new ConnectionReleaseMode("after_transaction");
    public static final ConnectionReleaseMode ON_CLOSE = new ConnectionReleaseMode("on_close");
    private String name;

    private ConnectionReleaseMode(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static ConnectionReleaseMode parse(String modeName) {
        if (ConnectionReleaseMode.AFTER_STATEMENT.name.equals(modeName)) {
            return AFTER_STATEMENT;
        }
        if (ConnectionReleaseMode.AFTER_TRANSACTION.name.equals(modeName)) {
            return AFTER_TRANSACTION;
        }
        return ON_CLOSE;
    }

    private Object readResolve() {
        return ConnectionReleaseMode.parse(this.name);
    }
}

