/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.webcapture.robo;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import jp.co.nri.ridual.r2.common.image.ImageScaler;
import jp.co.nri.ridual.r2.db.dao.ImageDAO;
import jp.co.nri.ridual.r2.db.dao.WebCaptureQueueDAO;
import jp.co.nri.ridual.r2.webcapture.robo.WebCaptureRobo;
import org.jdesktop.jdic.browser.WebBrowser;
import org.jdesktop.jdic.browser.WebBrowserEvent;
import org.jdesktop.jdic.browser.WebBrowserListener;

class BrowserAdapter
implements WebBrowserListener {
    private final GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    private final WebCaptureRobo robo;
    private final Robot robot;
    private final WebBrowser browser;
    private final ImageScaler scaler = new ImageScaler(160, 120);

    public BrowserAdapter(WebCaptureRobo robo, WebBrowser browser) throws AWTException {
        this.robo = robo;
        this.browser = browser;
        this.robot = new Robot(this.graphicsDevice);
        this.browser.addWebBrowserListener((WebBrowserListener)this);
    }

    public void documentCompleted(WebBrowserEvent arg0) {
        try {
            this.robo.status.setStatus(2);
            Dimension dim = this.browser.getSize();
            BufferedImage img = this.robot.createScreenCapture(new Rectangle(this.browser.getLocationOnScreen(), dim));
            BufferedImage thum = this.scaler.scale(img);
            ImageDAO.instance.updateJpeg(this.robo.browser.bean.getProjectId(), this.robo.browser.bean.getImageId(), thum);
            WebCaptureQueueDAO.instance.remove(this.robo.browser.bean);
            this.robo.browser.load();
        }
        catch (Throwable t) {
            StringWriter swriter = new StringWriter();
            t.printStackTrace(new PrintWriter(swriter));
            JOptionPane.showMessageDialog(this.robo, swriter.toString(), "\u554f\u984c\u304c\u767a\u751f\u3057\u307e\u3057\u305f.", 0);
        }
    }

    public void downloadStarted(WebBrowserEvent arg0) {
    }

    public void downloadCompleted(WebBrowserEvent arg0) {
    }

    public void downloadProgress(WebBrowserEvent arg0) {
    }

    public void downloadError(WebBrowserEvent arg0) {
        System.out.println("downloadError");
    }

    public void titleChange(WebBrowserEvent arg0) {
    }

    public void statusTextChange(WebBrowserEvent arg0) {
    }
}

