/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.rating;

import java.util.ResourceBundle;
import jp.co.nri.ridual.r2.common.pattern.Patterns;
import jp.co.nri.ridual.r2.rating.RatingPlugin;
import jp.co.nri.ridual.r2.rating.RatingPluginInfo;
import jp.co.nri.ridual.r2.rating.RatingPluginJarManifestPluginConfigException;

class RatingPluginConfig {
    private static final String ON = "on";
    private static final String OFF = "off";
    public final String classpath;
    public final String sw;
    public final String wt;
    public final String caption;

    public RatingPluginConfig(String config, String prefix, ResourceBundle messages) throws RatingPluginJarManifestPluginConfigException {
        try {
            String[] strs = Patterns.COLON_PATTERN.split(config);
            int len = strs.length;
            switch (len) {
                case 3: {
                    String s = strs[1];
                    if (s.equalsIgnoreCase(ON)) {
                        this.sw = ON;
                    } else if (s.equalsIgnoreCase(OFF)) {
                        this.sw = OFF;
                    } else {
                        throw new RatingPluginJarManifestPluginConfigException(config);
                    }
                    int num = Integer.parseInt(strs[2]);
                    if (num < 0 || 5 < num) {
                        throw new RatingPluginJarManifestPluginConfigException(config);
                    }
                    this.wt = Integer.toString(num);
                    break;
                }
                case 1: {
                    this.sw = null;
                    this.wt = null;
                    break;
                }
                default: {
                    throw new RatingPluginJarManifestPluginConfigException(config);
                }
            }
            String classname = strs[0];
            this.classpath = String.valueOf(prefix) + classname;
            this.caption = messages.getString(classname);
        }
        catch (Exception e) {
            throw new RatingPluginJarManifestPluginConfigException(config, e);
        }
    }

    public RatingPluginInfo buildRatingPluginInfo() {
        boolean exec = true;
        int method = 0;
        try {
            RatingPlugin plugin = (RatingPlugin)Class.forName(this.classpath).newInstance();
            method = plugin.getMethod();
        }
        catch (Exception e) {
            exec = false;
        }
        return new RatingPluginInfo(this.caption, exec, method, this.sw, this.wt);
    }
}

