/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.dao;

import java.util.List;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean;
import jp.co.nri.ridual.r2.db.bean.common.LocalHistoryBean;
import jp.co.nri.ridual.r2.db.dao.AnalyzeHistoryDAO;
import jp.co.nri.ridual.r2.db.dao.DefaultCommonDAO;
import jp.co.nri.ridual.r2.db.dao.RetryOverException;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class LocalHistoryDAO
extends DefaultCommonDAO {
    public static final LocalHistoryDAO instance = new LocalHistoryDAO();
    static /* synthetic */ Class class$0;

    private LocalHistoryDAO() {
        super(1);
    }

    public void save(LocalHistoryBean bean) throws Throwable {
        try {
            super.save(bean);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.LocalHistory", e);
            throw e;
        }
    }

    public LocalHistoryBean load(Integer id) throws Throwable {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.co.nri.ridual.r2.db.bean.common.LocalHistoryBean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (LocalHistoryBean)super.load(clazz, id);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.LocalHistory", e);
            throw e;
        }
    }

    public LocalHistoryBean loadActive(Integer id) throws Throwable {
        try {
            return (LocalHistoryBean)super.findUniqueByName("localHistory.loadActive", id);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.LocalHistory", e);
            throw e;
        }
    }

    public LocalHistoryBean[] findBySiteId(Integer siteId) throws Throwable {
        try {
            return super.findByName("localHistory.findBySiteId", siteId).toArray(new LocalHistoryBean[0]);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.LocalHistory", e);
            throw e;
        }
    }

    public List findDetachedBySiteId(Integer siteId) throws Throwable {
        try {
            return super.findByName("localHistory.findDetachedBySiteId", siteId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.LocalHistory", e);
            throw e;
        }
    }

    public LocalHistoryBean[] findByHistoryId(Integer historyId) throws Throwable {
        try {
            return super.findByName("localHistory.findByHistoryId", historyId).toArray(new LocalHistoryBean[0]);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.LocalHistory", e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setReadyAndHistoryIdBySiteId(Integer lhistoryId, Integer siteId) throws Throwable {
        try {
            SessionFactory factory = super.getSessionFactory();
            RetryOverException roe = new RetryOverException(factory);
            Session session = factory.openSession();
            while (true) {
                try {
                    try {
                        Transaction transaction = session.beginTransaction();
                        try {
                            AnalyzeHistoryBean historyBean = AnalyzeHistoryDAO.instance.findLastestBySiteId(siteId, (org.hibernate.Session)session);
                            Integer historyId = historyBean == null ? null : historyBean.getId();
                            super.updateByName("localHistory.updateReadyAndHistoryId", new Object[]{historyId, lhistoryId}, (org.hibernate.Session)session);
                            transaction.commit();
                            Object var9_12 = null;
                        }
                        catch (Throwable e) {
                            transaction.rollback();
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_13 = null;
                        session.close();
                        throw throwable;
                    }
                    session.close();
                    return;
                }
                catch (Throwable t) {
                    session = roe.retry(t);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.History", e);
            throw e;
        }
    }

    public void updateHistoryId(Integer localHistoryId, Integer historyId) throws Throwable {
        try {
            super.updateByName("localHistory.updateHistoryId", new Object[]{historyId, localHistoryId});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.LocalHistory", e);
            throw e;
        }
    }

    public void updateDelete(Integer localHistoryId) throws Throwable {
        try {
            super.updateByName("localHistory.updateDelete", localHistoryId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.LocalHistory", e);
            throw e;
        }
    }

    public void resetHistoryId(Integer historyId, org.hibernate.Session session) throws Throwable {
        try {
            super.updateByName("localHistory.resetHistoryId", historyId, session);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.LocalHistory", e);
            throw e;
        }
    }
}

