/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.dao;

import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import jp.co.nri.ridual.r2.common.authmap.PasswordAuthenticationMap;
import jp.co.nri.ridual.r2.common.pattern.Patterns;
import jp.co.nri.ridual.r2.common.uri.URIOperator;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeSiteConfigBean;
import jp.co.nri.ridual.r2.restrict.RestrictChecker;
import jp.co.nri.ridual.r2.throwable.InnerSitePathException;

public class HistoryCache {
    private static final String THIS_DIR = ".";
    public final AnalyzeHistoryBean history;
    public final AnalyzeSiteConfigBean siteConfig;
    public final int filesLimit;
    public final PasswordAuthentication userInfo;
    private final URL[] innerURIs;

    public HistoryCache(AnalyzeHistoryBean history, AnalyzeSiteConfigBean siteConfig) throws InnerSitePathException {
        String startURL;
        this.history = history;
        this.siteConfig = siteConfig;
        this.filesLimit = RestrictChecker.instanse.recheckRestrict().checkFiles(siteConfig.getFileCountLimit());
        this.userInfo = PasswordAuthenticationMap.buildPasswordAuthentication(siteConfig.getLoginUser(), siteConfig.getDecodedLoginPassword());
        ArrayList<URL> innerSiteList = new ArrayList<URL>();
        String innerSitePath = siteConfig.getInnerSitePaths();
        if (innerSitePath != null && innerSitePath.length() > 0) {
            String[] innerSitePaths = Patterns.CAMMA_PATTERN.split(innerSitePath);
            int i = innerSitePaths.length - 1;
            while (i >= 0) {
                try {
                    innerSiteList.add(URIOperator.instance.normalize(innerSitePaths[i]));
                }
                catch (Throwable t) {
                    throw new InnerSitePathException(innerSitePaths[i], t);
                }
                --i;
            }
        }
        if ((startURL = siteConfig.getStartURIs()) != null && startURL.length() > 0) {
            String[] startURLs = Patterns.CAMMA_PATTERN.split(startURL);
            int i = startURLs.length - 1;
            while (i >= 0) {
                try {
                    innerSiteList.add(URIOperator.instance.resolve(startURLs[i], THIS_DIR));
                }
                catch (Throwable t) {
                    throw new InnerSitePathException(startURLs[i], t);
                }
                --i;
            }
        }
        this.innerURIs = innerSiteList.toArray(new URL[0]);
    }

    public Boolean isInner(URL url) {
        URL[] inners = this.innerURIs;
        int i = inners.length - 1;
        while (i >= 0) {
            if (URIOperator.instance.isInner(inners[i], url)) {
                return Boolean.TRUE;
            }
            --i;
        }
        return Boolean.FALSE;
    }

    public Integer getProjectId() {
        return this.siteConfig.getProjectId();
    }

    public String getMailAddresses() {
        return this.siteConfig.getMailAddresses();
    }

    public String getStartURIs() {
        return this.siteConfig.getStartURIs();
    }

    public int getAnalyzeOptionFlags() {
        return this.siteConfig.getAnalyzeOptionFlags();
    }
}

