/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.dao;

import java.util.ArrayList;
import java.util.List;
import jp.co.nri.ridual.r2.db.bean.AbstractNodable;
import jp.co.nri.ridual.r2.db.bean.project.AbstractCSSChildConditionContainer;
import jp.co.nri.ridual.r2.db.bean.project.CSSCombinatorFirstConditionContainer;
import jp.co.nri.ridual.r2.db.bean.project.CSSCombinatorSecondConditionContainer;
import jp.co.nri.ridual.r2.db.bean.project.CSSConditionBean;
import jp.co.nri.ridual.r2.db.bean.project.CSSNegativeConditionContainer;
import jp.co.nri.ridual.r2.db.bean.project.CSSNodeBean;
import jp.co.nri.ridual.r2.db.bean.project.CSSNodeSupplementBean;
import jp.co.nri.ridual.r2.db.bean.project.CSSSelectorBean;
import jp.co.nri.ridual.r2.db.dao.DefaultProjectDAO;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import org.hibernate.HibernateException;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CharacterDataSelector;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.ContentCondition;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.PositionalCondition;
import org.w3c.css.sac.ProcessingInstructionSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;

public class CSSNodesDAO
extends DefaultProjectDAO {
    public static final CSSNodesDAO instance = new CSSNodesDAO();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private CSSNodesDAO() {
        super(0);
    }

    private void save(Integer projectId, CSSNodeBean cssNodes) throws Throwable {
        try {
            super.save(projectId, cssNodes);
        }
        catch (HibernateException e) {
            RidualServerLogDAO.getInstance().record("DB.CSS-nodes", e);
            throw e;
        }
    }

    public CSSNodeBean load(Integer projectId, Integer id) throws Throwable {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.co.nri.ridual.r2.db.bean.project.CSSNodeBean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (CSSNodeBean)super.load(projectId, clazz, id);
        }
        catch (HibernateException e) {
            RidualServerLogDAO.getInstance().record("DB.CSS-nodes", e);
            throw e;
        }
    }

    public void addSupplement(Integer projectId, Integer variationId, Integer nodeId, String name, String value) throws Throwable {
        CSSNodeSupplementBean supplement = new CSSNodeSupplementBean();
        supplement.setVariationId(variationId);
        supplement.setNodeId(nodeId);
        supplement.setName(name);
        supplement.setValue(value);
        try {
            super.save(projectId, supplement);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.CSS-node.Supplement", e);
            throw e;
        }
    }

    private CSSNodeBean saveNode(Integer projectId, Integer contentsId, Integer variationId, Integer parent, String type, String value, Boolean propertyImportant) throws Throwable {
        CSSNodeBean cssNode = new CSSNodeBean();
        cssNode.setContentsId(contentsId);
        cssNode.setVariationId(variationId);
        cssNode.setParentId(parent);
        cssNode.setType(type);
        cssNode.setValue(value);
        cssNode.setPropertyImportant(propertyImportant);
        this.save(projectId, cssNode);
        return cssNode;
    }

    public CSSNodeBean saveNode(Integer projectId, Integer contentsId, Integer variationId, Integer parent, String type, String value) throws Throwable {
        return this.saveNode(projectId, contentsId, variationId, parent, type, value, null);
    }

    public CSSNodeBean savePropertyNode(Integer projectId, Integer contentsId, Integer variationId, Integer parent, String value, Boolean propertyImportant) throws Throwable {
        return this.saveNode(projectId, contentsId, variationId, parent, "property", value, propertyImportant);
    }

    public void saveSelector(Integer projectId, Integer variationId, Integer nodeId, Selector selector) throws Throwable {
        this.saveSelector(projectId, variationId, nodeId, null, null, selector);
    }

    public AbstractNodable[] loadChildConditions(Integer projectId, CSSConditionBean bean) throws Throwable {
        try {
            CSSConditionBean second;
            CSSConditionBean first;
            ArrayList<AbstractCSSChildConditionContainer> list = new ArrayList<AbstractCSSChildConditionContainer>();
            CSSConditionBean negative = this.loadChildConditions(projectId, bean.getNegativeId());
            if (negative != null) {
                list.add(new CSSNegativeConditionContainer(negative));
            }
            if ((first = this.loadChildConditions(projectId, bean.getCombinatorFirstId())) != null) {
                list.add(new CSSCombinatorFirstConditionContainer(first));
            }
            if ((second = this.loadChildConditions(projectId, bean.getCombinatorSecondId())) != null) {
                list.add(new CSSCombinatorSecondConditionContainer(second));
            }
            return list.toArray(new AbstractNodable[0]);
        }
        catch (HibernateException e) {
            RidualServerLogDAO.getInstance().record("DB.CSS-condition", e);
            throw e;
        }
    }

    private CSSConditionBean loadChildConditions(Integer projectId, Integer id) throws Throwable {
        Object object;
        if (id == null) {
            object = null;
        } else {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("jp.co.nri.ridual.r2.db.bean.project.CSSConditionBean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            object = super.load(projectId, clazz, id);
        }
        return (CSSConditionBean)object;
    }

    public List findNodeSupplements(Integer projectId, Integer nodeId) throws Throwable {
        try {
            return super.findByName(projectId, "cssSupplement.findByNodeId", nodeId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.CSS-node.Supplement", e);
            throw e;
        }
    }

    public List findSelectorNodesByVariationId(Integer projectId, Integer variationId) throws Throwable {
        try {
            return super.findByName(projectId, "cssNodes.findSelectorByVariationId", variationId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.CSS-nodes", e);
            throw e;
        }
    }

    public List findChildNodes(Integer projectId, Integer parentId) throws Throwable {
        try {
            return super.findByName(projectId, "cssNodes.findNodesByParentId", parentId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.CSS-nodes", e);
            throw e;
        }
    }

    public List findChildSelectors(Integer projectId, Integer parentId) throws Throwable {
        try {
            return super.findByName(projectId, "cssSelector.findSelectorByParentId", parentId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.CSS-selector", e);
            throw e;
        }
    }

    public List findRootSelectorByNodeId(Integer projectId, Integer nodeId) throws Throwable {
        try {
            return super.findByName(projectId, "cssSelector.findRootByNodeId", nodeId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.CSS-selector", e);
            throw e;
        }
    }

    public List findRootConditionBySelectorId(Integer projectId, Integer selectorId) throws Throwable {
        try {
            return super.findByName(projectId, "cssCondition.findBySelectorId", selectorId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.CSS-condition", e);
            throw e;
        }
    }

    public void deleteNodesByVariationId(Integer projectId, Integer variationId) throws Throwable {
        try {
            super.updateByName(projectId, "cssNodes.deleteNodesByVariationId", variationId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.CSS-nodes", e);
            throw e;
        }
    }

    public void deleteSupplementsByVariationId(Integer projectId, Integer variationId) throws Throwable {
        try {
            super.updateByName(projectId, "cssSupplement.deleteByVariationId", variationId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.CSS-node.Supplement", e);
            throw e;
        }
    }

    public void deleteSelectorByVariationId(Integer projectId, Integer variationId) throws Throwable {
        try {
            super.updateByName(projectId, "cssSelector.deleteByVariationId", variationId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.CSS-selector", e);
            throw e;
        }
    }

    public void deleteConditionByVariationId(Integer projectId, Integer variationId) throws Throwable {
        try {
            super.updateByName(projectId, "cssCondition.deleteByVariationId", variationId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.CSS-condition", e);
            throw e;
        }
    }

    private void saveSelector(Integer projectId, Integer variationId, Integer nodeId, Integer parentId, String relationship, Selector selector) throws Throwable {
        try {
            short type = selector.getSelectorType();
            CSSSelectorBean bean = new CSSSelectorBean();
            bean.setVariationId(variationId);
            bean.setNodeId(nodeId);
            bean.setType(type);
            bean.setParentSelectorId(parentId);
            bean.setRelationship(relationship);
            switch (type) {
                case 1: 
                case 2: {
                    SimpleSelector sims = (SimpleSelector)selector;
                    bean.setData(sims.toString());
                    super.save(projectId, bean);
                    return;
                }
                case 5: 
                case 6: 
                case 8: {
                    CharacterDataSelector cds = (CharacterDataSelector)selector;
                    bean.setData(cds.getData());
                    super.save(projectId, bean);
                    return;
                }
                case 10: 
                case 11: {
                    super.save(projectId, bean);
                    Integer dsId = bean.getId();
                    DescendantSelector ds = (DescendantSelector)selector;
                    this.saveSelector(projectId, variationId, nodeId, dsId, "ancestor", ds.getAncestorSelector());
                    this.saveSelector(projectId, variationId, nodeId, dsId, "simple", (Selector)ds.getSimpleSelector());
                    this.saveSelector(projectId, variationId, dsId, (Selector)ds.getSimpleSelector());
                    return;
                }
                case 0: {
                    super.save(projectId, bean);
                    Integer csId = bean.getId();
                    ConditionalSelector cs = (ConditionalSelector)selector;
                    this.saveCondition(projectId, variationId, csId, cs.getCondition());
                    this.saveSelector(projectId, variationId, nodeId, csId, "simple", (Selector)cs.getSimpleSelector());
                    return;
                }
                case 12: {
                    super.save(projectId, bean);
                    Integer sibsId = bean.getId();
                    SiblingSelector sibs = (SiblingSelector)selector;
                    this.saveSelector(projectId, variationId, nodeId, sibsId, "selector", sibs.getSelector());
                    this.saveSelector(projectId, variationId, nodeId, sibsId, "sibling", (Selector)sibs.getSiblingSelector());
                    return;
                }
                case 4: 
                case 9: {
                    ElementSelector es = (ElementSelector)selector;
                    bean.setNamespaceURI(es.getNamespaceURI());
                    String localname = es.getLocalName();
                    bean.setLocalName(localname == null ? es.toString() : localname);
                    super.save(projectId, bean);
                    return;
                }
                case 3: {
                    super.save(projectId, bean);
                    Integer nsId = bean.getId();
                    NegativeSelector ns = (NegativeSelector)selector;
                    this.saveSelector(projectId, variationId, nodeId, nsId, "simple", (Selector)ns.getSimpleSelector());
                    return;
                }
                case 7: {
                    ProcessingInstructionSelector pis = (ProcessingInstructionSelector)selector;
                    bean.setData(pis.getData());
                    bean.setTarget(pis.getTarget());
                    super.save(projectId, bean);
                    return;
                }
            }
            super.save(projectId, bean);
            return;
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.CSS-selector", e);
            throw e;
        }
    }

    private CSSConditionBean saveChildCondition(Integer projectId, Integer variationId, Condition con) throws Throwable {
        return this.saveCondition(projectId, variationId, null, con);
    }

    private CSSConditionBean saveCondition(Integer projectId, Integer variationId, Integer selectorId, Condition con) throws Throwable {
        try {
            short type = con.getConditionType();
            CSSConditionBean bean = new CSSConditionBean();
            bean.setSelectorId(selectorId);
            bean.setType(type);
            bean.setVariationId(variationId);
            switch (con.getConditionType()) {
                case 0: 
                case 1: {
                    CombinatorCondition comc = (CombinatorCondition)con;
                    CSSConditionBean first = this.saveChildCondition(projectId, variationId, comc.getFirstCondition());
                    CSSConditionBean second = this.saveChildCondition(projectId, variationId, comc.getSecondCondition());
                    bean.setCombinatorFirstId(first.getId());
                    bean.setCombinatorSecondId(second.getId());
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    AttributeCondition ac = (AttributeCondition)con;
                    bean.setNamespaceURI(ac.getNamespaceURI());
                    bean.setLocalName(ac.getLocalName());
                    bean.setValue(ac.getValue());
                    bean.setSpecified(ac.getSpecified());
                    break;
                }
                case 13: {
                    ContentCondition conc = (ContentCondition)con;
                    bean.setContentData(conc.getData());
                    break;
                }
                case 6: {
                    LangCondition lc = (LangCondition)con;
                    bean.setLang(lc.getLang());
                    break;
                }
                case 2: {
                    NegativeCondition nc = (NegativeCondition)con;
                    CSSConditionBean child = this.saveChildCondition(projectId, variationId, nc.getCondition());
                    bean.setNegativeId(child.getId());
                    break;
                }
                case 3: {
                    PositionalCondition pc = (PositionalCondition)con;
                    bean.setPosition(new Integer(pc.getPosition()));
                    bean.setPositionalType(pc.getType());
                    bean.setPositionalTypeNode(pc.getTypeNode());
                    break;
                }
            }
            super.save(projectId, bean);
            return bean;
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.CSS-condition", e);
            throw e;
        }
    }
}

