/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.dao;

import java.io.Serializable;
import java.util.List;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import jp.co.nri.ridual.r2.common.pattern.Patterns;
import jp.co.nri.ridual.r2.common.uri.URIOperator;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeSiteConfigBean;
import jp.co.nri.ridual.r2.db.dao.AnalyzeHistoryDAO;
import jp.co.nri.ridual.r2.db.dao.DefaultCommonDAO;
import jp.co.nri.ridual.r2.db.dao.RetryOverException;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import jp.co.nri.ridual.r2.db.dao.SiteAndHistoryContainer;
import jp.co.nri.ridual.r2.throwable.InnerSitePathException;
import jp.co.nri.ridual.r2.throwable.StartURLException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class AnalyzeSiteConfigDAO
extends DefaultCommonDAO {
    public static final AnalyzeSiteConfigDAO instance = new AnalyzeSiteConfigDAO();
    static /* synthetic */ Class class$0;

    private AnalyzeSiteConfigDAO() {
        super(1);
    }

    public AnalyzeSiteConfigBean save(Integer projectId, String startURIs, String innerSitePaths, int optFlags, int limitDepth, int limitFileCount, int nestTableLimit, String mailAddresses, Integer proId, String loginUser, String loginPassword) throws StartURLException, InnerSitePathException, AddressException, Throwable {
        AnalyzeSiteConfigBean bean = new AnalyzeSiteConfigBean();
        bean.setProjectId(projectId);
        if (!this.isURL(startURIs)) {
            throw new StartURLException(startURIs);
        }
        if (innerSitePaths != null) {
            if (innerSitePaths.length() > 0) {
                if (!this.isURL(innerSitePaths)) {
                    throw new InnerSitePathException(innerSitePaths);
                }
            } else {
                innerSitePaths = null;
            }
        }
        if (mailAddresses != null) {
            if (mailAddresses.length() > 0) {
                InternetAddress.parse((String)mailAddresses, (boolean)true);
            } else {
                mailAddresses = null;
            }
        }
        try {
            bean.setStartURIs(startURIs);
            bean.setInnerSitePaths(innerSitePaths);
            bean.setAnalyzeOptionFlags(optFlags);
            bean.setDepthLimit(limitDepth);
            bean.setFileCountLimit(limitFileCount);
            bean.setNestTableLimit(nestTableLimit);
            bean.setMailAddresses(mailAddresses);
            bean.setRatingProfile(proId);
            bean.setLoginUser(loginUser);
            bean.setEncoding2LoginPassword(loginPassword);
            super.save(bean);
            return bean;
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Site", e);
            throw e;
        }
    }

    private boolean isURL(String url) {
        try {
            String[] urls = Patterns.CAMMA_PATTERN.split(url);
            int i = urls.length - 1;
            while (i >= 0) {
                URIOperator.instance.normalize(urls[i]);
                --i;
            }
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public AnalyzeSiteConfigBean loadActive(Integer id) throws Throwable {
        try {
            return (AnalyzeSiteConfigBean)super.findUniqueByName("siteConfig.loadActive", id);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Site", e);
            throw e;
        }
    }

    public AnalyzeSiteConfigBean load(Integer id) throws Throwable {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.co.nri.ridual.r2.db.bean.common.AnalyzeSiteConfigBean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (AnalyzeSiteConfigBean)super.load(clazz, id);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Site", e);
            throw e;
        }
    }

    public List findByProjectId(Integer id) throws Throwable {
        try {
            return super.findByName("siteConfig.findByProjectId", id);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Site", e);
            throw e;
        }
    }

    public AnalyzeSiteConfigBean findByHistoryId(Integer id) throws Throwable {
        try {
            return (AnalyzeSiteConfigBean)super.findUniqueByName("siteConfig.findByHistoryId", id);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Site", e);
            throw e;
        }
    }

    public AnalyzeSiteConfigBean[] findAll() throws Throwable {
        try {
            return super.findByName("siteConfig.findAll").toArray(new AnalyzeSiteConfigBean[0]);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Site", e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SiteAndHistoryContainer updateDeleteAndHistory(Integer siteId) throws Throwable {
        try {
            SessionFactory factory = super.getSessionFactory();
            RetryOverException roe = new RetryOverException(factory);
            Session session = factory.openSession();
            while (true) {
                try {
                    SiteAndHistoryContainer siteAndHistoryContainer;
                    try {
                        Transaction transaction = session.beginTransaction();
                        try {
                            SiteAndHistoryContainer sh = this.updateDeleteAndHistory(siteId, (org.hibernate.Session)session);
                            if (sh == null) {
                                transaction.rollback();
                            } else {
                                transaction.commit();
                            }
                            siteAndHistoryContainer = sh;
                            Object var7_11 = null;
                        }
                        catch (Throwable e) {
                            transaction.rollback();
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        session.close();
                        throw throwable;
                    }
                    session.close();
                    return siteAndHistoryContainer;
                }
                catch (Throwable t) {
                    session = roe.retry(t);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Site", e);
            throw e;
        }
    }

    private SiteAndHistoryContainer updateDeleteAndHistory(Integer siteId, org.hibernate.Session session) throws Throwable {
        AnalyzeSiteConfigBean bean;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.co.nri.ridual.r2.db.bean.common.AnalyzeSiteConfigBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((bean = (AnalyzeSiteConfigBean)session.load((Class)clazz, (Serializable)siteId)) == null || bean.getDeleted()) {
            return null;
        }
        AnalyzeHistoryBean[] historys = AnalyzeHistoryDAO.instance.findBySiteId(siteId, session).toArray(new AnalyzeHistoryBean[0]);
        int len = historys.length;
        AnalyzeHistoryBean[] delhistorys = new AnalyzeHistoryBean[len];
        int i = 0;
        while (i < len) {
            delhistorys[i] = AnalyzeHistoryDAO.instance.updateDeleteAndLocalHistory(historys[i].getId(), session);
            ++i;
        }
        bean.setDeleted(true);
        session.update((Object)bean);
        return new SiteAndHistoryContainer(bean, delhistorys);
    }
}

