/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeSiteConfigBean;
import jp.co.nri.ridual.r2.db.dao.AnalyzeSiteConfigDAO;
import jp.co.nri.ridual.r2.db.dao.DefaultCommonDAO;
import jp.co.nri.ridual.r2.db.dao.HistoryCache;
import jp.co.nri.ridual.r2.db.dao.LocalHistoryDAO;
import jp.co.nri.ridual.r2.db.dao.RetryOverException;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import jp.co.nri.ridual.r2.properties.RidualServerConfigProperties;
import jp.co.nri.ridual.r2.throwable.InnerSitePathException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class AnalyzeHistoryDAO
extends DefaultCommonDAO {
    public static final AnalyzeHistoryDAO instance = new AnalyzeHistoryDAO();
    private final Map siteConfigCacheMap = new Hashtable();
    private final Map cacheMap = new Hashtable();
    static /* synthetic */ Class class$0;

    private AnalyzeHistoryDAO() {
        super(1);
    }

    public void save(AnalyzeHistoryBean bean) throws Throwable {
        try {
            super.save(bean);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.History", e);
            throw e;
        }
    }

    public AnalyzeHistoryBean load(Integer id) throws Throwable {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (AnalyzeHistoryBean)super.load(clazz, id);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.History", e);
            throw e;
        }
    }

    public AnalyzeHistoryBean loadActive(Integer id) throws Throwable {
        try {
            return (AnalyzeHistoryBean)super.findUniqueByName("history.loadActive", id);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.History", e);
            throw e;
        }
    }

    public HistoryCache getCache(Integer historyId) throws Throwable {
        HistoryCache historyCache = (HistoryCache)this.cacheMap.get(historyId);
        if (historyCache == null) {
            try {
                AnalyzeHistoryBean history = this.load(historyId);
                Integer siteId = history.getSiteId();
                AnalyzeSiteConfigBean siteConfig = (AnalyzeSiteConfigBean)this.siteConfigCacheMap.get(siteId);
                if (siteConfig == null) {
                    siteConfig = AnalyzeSiteConfigDAO.instance.loadActive(siteId);
                    this.siteConfigCacheMap.put(siteId, siteConfig);
                }
                try {
                    historyCache = new HistoryCache(history, siteConfig);
                    this.cacheMap.put(historyId, historyCache);
                }
                catch (InnerSitePathException e) {
                    RidualServerLogDAO.getInstance().record("DB.History", e);
                }
            }
            catch (Throwable e) {
                RidualServerLogDAO.getInstance().record("DB.History", e);
                throw e;
            }
        }
        return historyCache;
    }

    public List findBySiteId(Integer siteId) throws Throwable {
        try {
            return super.findByName("history.findBySiteId", siteId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.History", e);
            throw e;
        }
    }

    public List findBySiteId(Integer siteId, org.hibernate.Session session) throws Throwable {
        try {
            return super.findByName("history.findBySiteId", siteId, session);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.History", e);
            throw e;
        }
    }

    public AnalyzeHistoryBean[] findIncompleteBuildReport(String servername) throws Throwable {
        try {
            return servername == null ? super.findByName("history.findIncompleteBuildReport").toArray(new AnalyzeHistoryBean[0]) : super.findByName("history.findIncompleteBuildReportByServer", servername).toArray(new AnalyzeHistoryBean[0]);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.History", e);
            throw e;
        }
    }

    public AnalyzeHistoryBean[] findIncompleteRecheck(String servername) throws Throwable {
        try {
            return servername == null ? super.findByName("history.findIncompleteRecheck").toArray(new AnalyzeHistoryBean[0]) : super.findByName("history.findIncompleteRecheckByServer", servername).toArray(new AnalyzeHistoryBean[0]);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.History", e);
            throw e;
        }
    }

    public AnalyzeHistoryBean[] findIncompleteRefreshThumbnail(String servername) throws Throwable {
        try {
            return servername == null ? super.findByName("history.findIncompleteThumbnailRefreshing").toArray(new AnalyzeHistoryBean[0]) : super.findByName("history.findIncompleteThumbnailRefreshingByServer", servername).toArray(new AnalyzeHistoryBean[0]);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.History", e);
            throw e;
        }
    }

    public AnalyzeHistoryBean[] findIncomplete() throws Throwable {
        try {
            return super.findByName("history.findIncomplete").toArray(new AnalyzeHistoryBean[0]);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.History", e);
            throw e;
        }
    }

    public void updateComplete(AnalyzeHistoryBean bean, org.hibernate.Session session) throws Throwable {
        try {
            String server = RidualServerConfigProperties.getInstance().getString("ridual.server.name");
            bean.setBuildReportServer(server);
            bean.setTimestampComplete(new Date());
            session.update((Object)bean);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.History", e);
            throw e;
        }
    }

    public void updateReady(Integer historyId) throws Throwable {
        try {
            super.updateByName("history.updateReady", historyId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.History", e);
            throw e;
        }
    }

    public void updateRechecking(Integer historyId) throws Throwable {
        try {
            super.updateByName("history.updateRechecking", historyId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.History", e);
            throw e;
        }
    }

    public void updateThumbnailRefreshing(Integer historyId) throws Throwable {
        try {
            super.updateByName("history.updateThumbnailRefreshing", historyId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.History", e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AnalyzeHistoryBean updateRebuild(Integer historyId) throws Throwable {
        try {
            SessionFactory factory = super.getSessionFactory();
            RetryOverException roe = new RetryOverException(factory);
            Session session = factory.openSession();
            while (true) {
                try {
                    AnalyzeHistoryBean analyzeHistoryBean;
                    block14: {
                        AnalyzeHistoryBean analyzeHistoryBean2;
                        block13: {
                            try {
                                Transaction transaction = session.beginTransaction();
                                try {
                                    AnalyzeHistoryBean bean;
                                    Class<?> clazz = class$0;
                                    if (clazz == null) {
                                        Class<?> clazz2;
                                        try {
                                            clazz2 = Class.forName("jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                        clazz = class$0 = clazz2;
                                    }
                                    if ((bean = (AnalyzeHistoryBean)session.load((Class)clazz, (Serializable)historyId)) == null || bean.getDeleted() || bean.isDuringProcessing()) {
                                        transaction.rollback();
                                        analyzeHistoryBean2 = null;
                                        Object var7_12 = null;
                                        break block13;
                                    }
                                    bean.setReady(false);
                                    session.update((Object)bean);
                                    transaction.commit();
                                    analyzeHistoryBean = bean;
                                    break block14;
                                }
                                catch (Throwable e) {
                                    transaction.rollback();
                                    throw e;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var7_14 = null;
                                session.close();
                                throw throwable;
                            }
                        }
                        session.close();
                        return analyzeHistoryBean2;
                    }
                    Object var7_13 = null;
                    session.close();
                    return analyzeHistoryBean;
                }
                catch (Throwable t) {
                    session = roe.retry(t);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.History", e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AnalyzeHistoryBean updateRecheck(Integer historyId, String servername) throws Throwable {
        try {
            SessionFactory factory = super.getSessionFactory();
            RetryOverException roe = new RetryOverException(factory);
            Session session = factory.openSession();
            while (true) {
                try {
                    AnalyzeHistoryBean analyzeHistoryBean;
                    block14: {
                        AnalyzeHistoryBean analyzeHistoryBean2;
                        block13: {
                            try {
                                Transaction transaction = session.beginTransaction();
                                try {
                                    AnalyzeHistoryBean bean;
                                    Class<?> clazz = class$0;
                                    if (clazz == null) {
                                        Class<?> clazz2;
                                        try {
                                            clazz2 = Class.forName("jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                        clazz = class$0 = clazz2;
                                    }
                                    if ((bean = (AnalyzeHistoryBean)session.load((Class)clazz, (Serializable)historyId)) == null || bean.getDeleted() || !bean.getReady() || bean.getRechecking()) {
                                        transaction.rollback();
                                        analyzeHistoryBean2 = null;
                                        Object var8_13 = null;
                                        break block13;
                                    }
                                    bean.setRechecking(true);
                                    bean.setRecheckServer(servername);
                                    bean.setTimestampRecheck(new Date());
                                    session.update((Object)bean);
                                    transaction.commit();
                                    analyzeHistoryBean = bean;
                                    break block14;
                                }
                                catch (Throwable e) {
                                    transaction.rollback();
                                    throw e;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var8_15 = null;
                                session.close();
                                throw throwable;
                            }
                        }
                        session.close();
                        return analyzeHistoryBean2;
                    }
                    Object var8_14 = null;
                    session.close();
                    return analyzeHistoryBean;
                }
                catch (Throwable t) {
                    session = roe.retry(t);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.History", e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AnalyzeHistoryBean updatethumbnailRefresh(Integer historyId, String servername) throws Throwable {
        try {
            SessionFactory factory = super.getSessionFactory();
            RetryOverException roe = new RetryOverException(factory);
            Session session = factory.openSession();
            while (true) {
                try {
                    AnalyzeHistoryBean analyzeHistoryBean;
                    block14: {
                        AnalyzeHistoryBean analyzeHistoryBean2;
                        block13: {
                            try {
                                Transaction transaction = session.beginTransaction();
                                try {
                                    AnalyzeHistoryBean bean;
                                    Class<?> clazz = class$0;
                                    if (clazz == null) {
                                        Class<?> clazz2;
                                        try {
                                            clazz2 = Class.forName("jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                        clazz = class$0 = clazz2;
                                    }
                                    if ((bean = (AnalyzeHistoryBean)session.load((Class)clazz, (Serializable)historyId)) == null || bean.getDeleted() || !bean.getReady() || bean.getThumbnailRefreshing()) {
                                        transaction.rollback();
                                        analyzeHistoryBean2 = null;
                                        Object var8_13 = null;
                                        break block13;
                                    }
                                    bean.setThumbnailRefreshing(true);
                                    bean.setThumbnailRefreshServer(servername);
                                    bean.setTimestampThumbnailRefresh(new Date());
                                    session.update((Object)bean);
                                    transaction.commit();
                                    analyzeHistoryBean = bean;
                                    break block14;
                                }
                                catch (Throwable e) {
                                    transaction.rollback();
                                    throw e;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var8_15 = null;
                                session.close();
                                throw throwable;
                            }
                        }
                        session.close();
                        return analyzeHistoryBean2;
                    }
                    Object var8_14 = null;
                    session.close();
                    return analyzeHistoryBean;
                }
                catch (Throwable t) {
                    session = roe.retry(t);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.History", e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AnalyzeHistoryBean updateDeleteAndLocalHistory(Integer historyId) throws Throwable {
        try {
            SessionFactory factory = super.getSessionFactory();
            RetryOverException roe = new RetryOverException(factory);
            Session session = factory.openSession();
            while (true) {
                try {
                    AnalyzeHistoryBean analyzeHistoryBean;
                    try {
                        Transaction transaction = session.beginTransaction();
                        try {
                            AnalyzeHistoryBean bean = this.updateDeleteAndLocalHistory(historyId, (org.hibernate.Session)session);
                            if (bean == null) {
                                transaction.rollback();
                            } else {
                                transaction.commit();
                            }
                            analyzeHistoryBean = bean;
                            Object var7_11 = null;
                        }
                        catch (Throwable e) {
                            transaction.rollback();
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        session.close();
                        throw throwable;
                    }
                    session.close();
                    return analyzeHistoryBean;
                }
                catch (Throwable t) {
                    session = roe.retry(t);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.History", e);
            throw e;
        }
    }

    public AnalyzeHistoryBean updateDeleteAndLocalHistory(Integer historyId, org.hibernate.Session session) throws Throwable {
        AnalyzeHistoryBean bean;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((bean = (AnalyzeHistoryBean)session.load((Class)clazz, (Serializable)historyId)) == null || bean.getDeleted()) {
            return null;
        }
        LocalHistoryDAO.instance.resetHistoryId(bean.getId(), session);
        bean.setDeleted(true);
        session.update((Object)bean);
        return bean;
    }

    public HistoryCache removeCache(Integer historyId) throws Throwable {
        return (HistoryCache)this.cacheMap.remove(historyId);
    }

    public AnalyzeHistoryBean findLastestBySiteId(Integer siteId, org.hibernate.Session session) throws Throwable {
        try {
            return (AnalyzeHistoryBean)super.findUniqueByName("history.findLastestBySiteId", siteId, session);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.History", e);
            throw e;
        }
    }
}

