/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.bean.project;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import jp.co.nri.ridual.r2.common.uri.URIOperator;
import jp.co.nri.ridual.r2.db.bean.AbstractNodable;
import jp.co.nri.ridual.r2.db.bean.project.AbstractProjectNodable;
import jp.co.nri.ridual.r2.db.bean.project.ContentsAndVariationContainer;
import jp.co.nri.ridual.r2.db.bean.project.DirectoryMapBean;
import jp.co.nri.ridual.r2.db.bean.project.LocalFileBean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LocalDifferenceContainer
extends AbstractProjectNodable {
    private static final String ELEMENT_NAME_ROOT = "LOCAL_DIFFERENCE";
    private static final String ELEMENT_NAME_URL = "URL";
    private static final String ELEMENT_NAME_FILE = "FILE";
    private static final String ELEMENT_NAME_EXTENSION = "EXTENSION";
    private static final String ELEMENT_NAME_LOCAL_TIMESTAMP = "LOCAL_TIMESTAMP";
    private static final String ELEMENT_NAME_NET_TIMESTAMP = "NET_TIMESTAMP";
    private static final int FLG_LOCAL = 1;
    private static final int FLG_NET = 2;
    private static final int FLG_MULTI = 6;
    private static final int VALUE_LOCAL_ONLY = 1;
    private static final int VALUE_NET_ONLY = 2;
    private static final int VALUE_BOTH = 3;
    private static final int VALUE_NET_ONLY_MULTI = 6;
    private static final int VALUE_BOTH_MULTI = 7;
    private final DirectoryMapBean dirmap;
    private final LocalFileBean lfile;
    private final ArrayList contents = new ArrayList();
    private final URL url;

    public LocalDifferenceContainer(DirectoryMapBean dirmap, LocalFileBean lfile) {
        this.dirmap = dirmap;
        this.lfile = lfile;
        URL u = null;
        try {
            u = URIOperator.instance.resolve(this.dirmap.getURL(), this.lfile.getPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.url = u;
    }

    public LocalDifferenceContainer(URL url, ContentsAndVariationContainer cv) {
        this.dirmap = null;
        this.lfile = null;
        this.url = url;
        this.contents.add(cv);
    }

    public Node buildNode(Integer projectId, int mode, Document doc) {
        if (22 != mode) {
            return null;
        }
        int sz = this.contents.size();
        int flg = 0;
        if (this.lfile != null) {
            flg |= 1;
        }
        if (sz > 0) {
            flg |= 1 < sz ? 6 : 2;
        }
        Element elm = null;
        Date local = null;
        Date net = null;
        switch (flg) {
            case 3: {
                local = this.getLocalTimestamp();
                net = this.getNetTimestamp();
                if (local.equals(net)) {
                    return null;
                }
                elm = this.buildNodeBase(doc, this.lfile.getExtension());
                this.buildNodeLocal(elm, local);
                this.buildNodeNet(elm, net);
                return elm;
            }
            case 1: {
                elm = this.buildNodeBase(doc, this.lfile.getExtension());
                this.buildNodeLocal(elm, this.getLocalTimestamp());
                return elm;
            }
            case 2: 
            case 6: {
                elm = this.buildNodeBase(doc, ((ContentsAndVariationContainer)this.contents.get((int)0)).contents.getExtension());
                this.buildNodeNet(elm, this.getNetTimestamp());
                return elm;
            }
        }
        return null;
    }

    private Date getLocalTimestamp() {
        return this.lfile.getTimestamp();
    }

    private Date getNetTimestamp() {
        return ((ContentsAndVariationContainer)this.contents.get((int)0)).variation.getLastModified();
    }

    private Element buildNodeBase(Document doc, String ext) {
        Element elm = doc.createElement(ELEMENT_NAME_ROOT);
        super.buildTextElement(elm, ELEMENT_NAME_EXTENSION, ext);
        return elm;
    }

    private void buildNodeLocal(Element elm, Date timestamp) {
        super.buildTextElement(elm, ELEMENT_NAME_FILE, new File(this.dirmap.getDir(), this.lfile.getPath()).getPath());
        super.buildDateElement(elm, ELEMENT_NAME_LOCAL_TIMESTAMP, timestamp);
    }

    private void buildNodeNet(Element elm, Date timestamp) {
        super.buildElement(elm, ELEMENT_NAME_URL, this.url);
        super.buildDateElement(elm, ELEMENT_NAME_NET_TIMESTAMP, timestamp);
    }

    public AbstractNodable[] loadChild(Integer projectId, int mode) throws Throwable {
        return null;
    }

    public URL getKey() {
        return this.url;
    }

    public void add(ContentsAndVariationContainer cv) {
        this.contents.add(cv);
    }
}

