/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.common.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import jp.co.nri.ridual.r2.common.image.ImageObserverImpl;
import jp.co.nri.ridual.r2.common.image.RenderingHintsMap;

public class ImageScaler {
    private final RenderingHintsMap renderingHintsMap = new RenderingHintsMap();
    private final int width;
    private final int height;

    public ImageScaler(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public BufferedImage scale(BufferedImage bi) {
        int h;
        int w = bi.getWidth();
        int scale = this.transrateScale(w, h = bi.getHeight());
        if (scale <= 1) {
            return bi;
        }
        int tw = w / scale;
        int th = h / scale;
        if (tw <= 0) {
            tw = 1;
        }
        if (th <= 0) {
            th = 1;
        }
        Image img = bi.getScaledInstance(tw, th, 16);
        int type = bi.getType();
        BufferedImage thum = new BufferedImage(tw, th, type == 0 ? 4 : type);
        Graphics2D g2d = thum.createGraphics();
        g2d.setRenderingHints(this.renderingHintsMap);
        ImageObserverImpl iou = new ImageObserverImpl();
        if (!g2d.drawImage(img, 0, 0, iou)) {
            while (iou.isDrawing()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return thum;
    }

    private int transrateScale(int w, int h) {
        int wscale = w / this.width;
        int hscale = h / this.height;
        return wscale < hscale ? hscale : wscale;
    }
}

