/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.imap.DefaultFolder;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.Quota;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.Namespaces;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.StoreClosedException;
import javax.mail.URLName;

public class IMAPStore
extends Store
implements ResponseHandler {
    private String name = "imap";
    private int defaultPort = 143;
    private boolean isSSL = false;
    private int port = -1;
    private int blksize = 16384;
    private int statusCacheTimeout = 1000;
    private int appendBufferSize = -1;
    private String host;
    private String user;
    private String password;
    private String proxyAuthUser;
    private String authorizationID;
    private String saslRealm;
    private Namespaces namespaces;
    private boolean disableAuthLogin = false;
    private boolean disableAuthPlain = false;
    private boolean enableStartTLS = false;
    private boolean enableSASL = false;
    private String[] saslMechanisms;
    private boolean forcePasswordRefresh = false;
    private boolean debug;
    private PrintStream out;
    private ConnectionPool pool = new ConnectionPool();

    public IMAPStore(Session session, URLName uRLName) {
        this(session, uRLName, "imap", 143, false);
    }

    protected IMAPStore(Session session, URLName uRLName, String string, int n, boolean bl) {
        super(session, uRLName);
        int n2;
        String string2;
        if (uRLName != null) {
            string = uRLName.getProtocol();
        }
        this.name = string;
        this.defaultPort = n;
        this.isSSL = bl;
        this.pool.lastTimePruned = System.currentTimeMillis();
        this.debug = session.getDebug();
        this.out = session.getDebugOut();
        if (this.out == null) {
            this.out = System.out;
        }
        if ((string2 = session.getProperty("mail." + string + ".connectionpool.debug")) != null && string2.equalsIgnoreCase("true")) {
            this.pool.debug = true;
        }
        if ((string2 = session.getProperty("mail." + string + ".partialfetch")) != null && string2.equalsIgnoreCase("false")) {
            this.blksize = -1;
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.partialfetch: false");
            }
        } else {
            string2 = session.getProperty("mail." + string + ".fetchsize");
            if (string2 != null) {
                this.blksize = Integer.parseInt(string2);
            }
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.fetchsize: " + this.blksize);
            }
        }
        if ((string2 = session.getProperty("mail." + string + ".statuscachetimeout")) != null) {
            this.statusCacheTimeout = Integer.parseInt(string2);
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.statuscachetimeout: " + this.statusCacheTimeout);
            }
        }
        if ((string2 = session.getProperty("mail." + string + ".appendbuffersize")) != null) {
            this.appendBufferSize = Integer.parseInt(string2);
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.appendbuffersize: " + this.appendBufferSize);
            }
        }
        if ((string2 = session.getProperty("mail." + string + ".connectionpoolsize")) != null) {
            try {
                n2 = Integer.parseInt(string2);
                if (n2 > 0) {
                    this.pool.poolSize = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (this.pool.debug) {
                this.out.println("DEBUG: mail.imap.connectionpoolsize: " + this.pool.poolSize);
            }
        }
        if ((string2 = session.getProperty("mail." + string + ".connectionpooltimeout")) != null) {
            try {
                n2 = Integer.parseInt(string2);
                if (n2 > 0) {
                    this.pool.clientTimeoutInterval = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (this.pool.debug) {
                this.out.println("DEBUG: mail.imap.connectionpooltimeout: " + this.pool.clientTimeoutInterval);
            }
        }
        if ((string2 = session.getProperty("mail." + string + ".servertimeout")) != null) {
            try {
                n2 = Integer.parseInt(string2);
                if (n2 > 0) {
                    this.pool.serverTimeoutInterval = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (this.pool.debug) {
                this.out.println("DEBUG: mail.imap.servertimeout: " + this.pool.serverTimeoutInterval);
            }
        }
        if ((string2 = session.getProperty("mail." + string + ".separatestoreconnection")) != null && string2.equalsIgnoreCase("true")) {
            if (this.pool.debug) {
                this.out.println("DEBUG: dedicate a store connection");
            }
            this.pool.separateStoreConnection = true;
        }
        if ((string2 = session.getProperty("mail." + string + ".proxyauth.user")) != null) {
            this.proxyAuthUser = string2;
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.proxyauth.user: " + this.proxyAuthUser);
            }
        }
        if ((string2 = session.getProperty("mail." + string + ".auth.login.disable")) != null && string2.equalsIgnoreCase("true")) {
            if (this.debug) {
                this.out.println("DEBUG: disable AUTH=LOGIN");
            }
            this.disableAuthLogin = true;
        }
        if ((string2 = session.getProperty("mail." + string + ".auth.plain.disable")) != null && string2.equalsIgnoreCase("true")) {
            if (this.debug) {
                this.out.println("DEBUG: disable AUTH=PLAIN");
            }
            this.disableAuthPlain = true;
        }
        if ((string2 = session.getProperty("mail." + string + ".starttls.enable")) != null && string2.equalsIgnoreCase("true")) {
            if (this.debug) {
                this.out.println("DEBUG: enable STARTTLS");
            }
            this.enableStartTLS = true;
        }
        if ((string2 = session.getProperty("mail." + string + ".sasl.enable")) != null && string2.equalsIgnoreCase("true")) {
            if (this.debug) {
                this.out.println("DEBUG: enable SASL");
            }
            this.enableSASL = true;
        }
        if (this.enableSASL && (string2 = session.getProperty("mail." + string + ".sasl.mechanisms")) != null && string2.length() > 0) {
            if (this.debug) {
                this.out.println("DEBUG: SASL mechanisms allowed: " + string2);
            }
            Vector<String> vector = new Vector<String>(5);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.length() <= 0) continue;
                vector.addElement(string3);
            }
            this.saslMechanisms = new String[vector.size()];
            vector.copyInto(this.saslMechanisms);
        }
        if ((string2 = session.getProperty("mail." + string + ".sasl.authorizationid")) != null) {
            this.authorizationID = string2;
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.sasl.authorizationid: " + this.authorizationID);
            }
        }
        if ((string2 = session.getProperty("mail." + string + ".sasl.realm")) != null) {
            this.saslRealm = string2;
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.sasl.realm: " + this.saslRealm);
            }
        }
        if ((string2 = session.getProperty("mail." + string + ".forcepasswordrefresh")) != null && string2.equalsIgnoreCase("true")) {
            if (this.debug) {
                this.out.println("DEBUG: enable forcePasswordRefresh");
            }
            this.forcePasswordRefresh = true;
        }
    }

    protected synchronized boolean protocolConnect(String string, int n, String string2, String string3) throws MessagingException {
        block17: {
            IMAPProtocol iMAPProtocol = null;
            if (string == null || string3 == null || string2 == null) {
                if (this.debug) {
                    this.out.println("DEBUG: protocolConnect returning false, host=" + string + ", user=" + string2 + ", password=" + (string3 != null ? "<non-null>" : "<null>"));
                }
                return false;
            }
            if (n != -1) {
                this.port = n;
            } else {
                String string4 = ((Service)this).session.getProperty("mail." + this.name + ".port");
                if (string4 != null) {
                    this.port = Integer.parseInt(string4);
                }
            }
            if (this.port == -1) {
                this.port = this.defaultPort;
            }
            try {
                boolean bl;
                ConnectionPool connectionPool = this.pool;
                synchronized (connectionPool) {
                    bl = this.pool.authenticatedConnections.isEmpty();
                }
                if (!bl) break block17;
                iMAPProtocol = new IMAPProtocol(this.name, string, this.port, ((Service)this).session.getDebug(), ((Service)this).session.getDebugOut(), ((Service)this).session.getProperties(), this.isSSL);
                if (this.debug) {
                    this.out.println("DEBUG: protocolConnect login, host=" + string + ", user=" + string2 + ", password=" + (string3 != null ? "<non-null>" : "<null>"));
                }
                this.login(iMAPProtocol, string2, string3);
                iMAPProtocol.addResponseHandler(this);
                this.host = string;
                this.user = string2;
                this.password = string3;
                connectionPool = this.pool;
                synchronized (connectionPool) {
                    this.pool.authenticatedConnections.addElement(iMAPProtocol);
                }
            }
            catch (CommandFailedException commandFailedException) {
                iMAPProtocol.disconnect();
                iMAPProtocol = null;
                throw new AuthenticationFailedException(commandFailedException.getResponse().getRest());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            catch (IOException iOException) {
                throw new MessagingException(iOException.getMessage(), (Exception)iOException);
            }
        }
        return true;
    }

    private void login(IMAPProtocol iMAPProtocol, String string, String string2) throws ProtocolException {
        if (this.enableStartTLS && iMAPProtocol.hasCapability("STARTTLS")) {
            iMAPProtocol.startTLS();
            iMAPProtocol.capability();
        }
        if (iMAPProtocol.isAuthenticated()) {
            return;
        }
        String string3 = this.authorizationID != null ? this.authorizationID : (this.proxyAuthUser != null ? this.proxyAuthUser : string);
        if (this.enableSASL) {
            iMAPProtocol.sasllogin(this.saslMechanisms, this.saslRealm, string3, string, string2);
            if (iMAPProtocol.isAuthenticated()) {
                if (this.proxyAuthUser != null) {
                    iMAPProtocol.proxyauth(this.proxyAuthUser);
                }
                return;
            }
        }
        if (iMAPProtocol.hasCapability("AUTH=PLAIN") && !this.disableAuthPlain) {
            iMAPProtocol.authplain(string3, string, string2);
        } else if ((iMAPProtocol.hasCapability("AUTH-LOGIN") || iMAPProtocol.hasCapability("AUTH=LOGIN")) && !this.disableAuthLogin) {
            iMAPProtocol.authlogin(string, string2);
        } else if (!iMAPProtocol.hasCapability("LOGINDISABLED")) {
            iMAPProtocol.login(string, string2);
        } else {
            throw new ProtocolException("No login methods supported!");
        }
        if (this.proxyAuthUser != null) {
            iMAPProtocol.proxyauth(this.proxyAuthUser);
        }
    }

    public void setUsername(String string) {
        this.user = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    IMAPProtocol getProtocol(IMAPFolder iMAPFolder) throws MessagingException {
        IMAPProtocol iMAPProtocol = null;
        while (iMAPProtocol == null) {
            ConnectionPool connectionPool = this.pool;
            synchronized (connectionPool) {
                if (this.pool.authenticatedConnections.isEmpty() || this.pool.separateStoreConnection && this.pool.authenticatedConnections.size() == 1 || this.pool.borrowedStoreConnections > 0L && this.pool.authenticatedConnections.size() == 1) {
                    if (this.debug) {
                        this.out.println("DEBUG: no connections in the pool, creating a new one");
                    }
                    try {
                        if (this.forcePasswordRefresh) {
                            InetAddress inetAddress;
                            try {
                                inetAddress = InetAddress.getByName(this.host);
                            }
                            catch (UnknownHostException unknownHostException) {
                                inetAddress = null;
                            }
                            PasswordAuthentication passwordAuthentication = ((Service)this).session.requestPasswordAuthentication(inetAddress, this.port, this.name, null, this.user);
                            if (passwordAuthentication != null) {
                                this.user = passwordAuthentication.getUserName();
                                this.password = passwordAuthentication.getPassword();
                            }
                        }
                        iMAPProtocol = new IMAPProtocol(this.name, this.host, this.port, ((Service)this).session.getDebug(), ((Service)this).session.getDebugOut(), ((Service)this).session.getProperties(), this.isSSL);
                        this.login(iMAPProtocol, this.user, this.password);
                    }
                    catch (Exception exception) {
                        if (iMAPProtocol != null) {
                            try {
                                iMAPProtocol.disconnect();
                            }
                            catch (Exception exception2) {}
                        }
                        iMAPProtocol = null;
                    }
                    if (iMAPProtocol == null) {
                        throw new MessagingException("connection failure");
                    }
                } else {
                    if (this.debug) {
                        this.out.println("DEBUG: connection available -- size: " + this.pool.authenticatedConnections.size());
                    }
                    iMAPProtocol = (IMAPProtocol)this.pool.authenticatedConnections.lastElement();
                    this.pool.authenticatedConnections.removeElement(iMAPProtocol);
                    long l = System.currentTimeMillis() - iMAPProtocol.getTimestamp();
                    if (l > this.pool.serverTimeoutInterval) {
                        try {
                            iMAPProtocol.noop();
                        }
                        catch (ProtocolException protocolException) {
                            try {
                                iMAPProtocol.removeResponseHandler(this);
                                iMAPProtocol.disconnect();
                            }
                            catch (Exception exception) {}
                            iMAPProtocol = null;
                            Object var4_4 = null;
                            continue;
                        }
                    }
                    iMAPProtocol.removeResponseHandler(this);
                }
                this.timeoutConnections();
                if (iMAPFolder != null) {
                    if (this.pool.folders == null) {
                        this.pool.folders = new Vector();
                    }
                    this.pool.folders.addElement(iMAPFolder);
                }
            }
        }
        return iMAPProtocol;
    }

    IMAPProtocol getStoreProtocol() throws ProtocolException {
        IMAPProtocol iMAPProtocol = null;
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.pool.authenticatedConnections.isEmpty()) {
                if (this.pool.debug) {
                    this.out.println("DEBUG: getStoreProtocol() - no connections in the pool, creating a new one");
                }
                try {
                    iMAPProtocol = new IMAPProtocol(this.name, this.host, this.port, ((Service)this).session.getDebug(), ((Service)this).session.getDebugOut(), ((Service)this).session.getProperties(), this.isSSL);
                    this.login(iMAPProtocol, this.user, this.password);
                }
                catch (Exception exception) {
                    if (iMAPProtocol != null) {
                        try {
                            iMAPProtocol.logout();
                        }
                        catch (Exception exception2) {}
                    }
                    iMAPProtocol = null;
                }
                if (iMAPProtocol == null) {
                    throw new ConnectionException("failed to create new store connection");
                }
                iMAPProtocol.addResponseHandler(this);
                this.pool.authenticatedConnections.addElement(iMAPProtocol);
            } else {
                if (this.pool.debug) {
                    this.out.println("DEBUG: getStoreProtocol() - connection available -- size: " + this.pool.authenticatedConnections.size());
                }
                iMAPProtocol = (IMAPProtocol)this.pool.authenticatedConnections.firstElement();
            }
            if (!this.pool.separateStoreConnection) {
                ConnectionPool connectionPool2 = this.pool;
                connectionPool2.borrowedStoreConnections = connectionPool2.borrowedStoreConnections + 1L;
                if (this.pool.debug) {
                    this.out.println("DEBUG: getStoreProtocol() -- borrowedStoreConnections: " + this.pool.borrowedStoreConnections);
                }
            }
            this.timeoutConnections();
            IMAPProtocol iMAPProtocol2 = iMAPProtocol;
            Object var4_4 = null;
            return iMAPProtocol2;
        }
    }

    boolean allowReadOnlySelect() {
        String string = ((Service)this).session.getProperty("mail." + this.name + ".allowreadonlyselect");
        return string != null && string.equalsIgnoreCase("true");
    }

    boolean hasSeparateStoreConnection() {
        return this.pool.separateStoreConnection;
    }

    boolean getConnectionPoolDebug() {
        return this.pool.debug;
    }

    boolean isConnectionPoolFull() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.pool.debug) {
                this.out.println("DEBUG: current size: " + this.pool.authenticatedConnections.size() + "   pool size: " + this.pool.poolSize);
            }
            boolean bl = this.pool.authenticatedConnections.size() >= this.pool.poolSize;
            Object var3_3 = null;
            return bl;
        }
    }

    void releaseProtocol(IMAPFolder iMAPFolder, IMAPProtocol iMAPProtocol) {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (iMAPProtocol != null) {
                if (!this.isConnectionPoolFull()) {
                    iMAPProtocol.addResponseHandler(this);
                    this.pool.authenticatedConnections.addElement(iMAPProtocol);
                    if (this.debug) {
                        this.out.println("DEBUG: added an Authenticated connection -- size: " + this.pool.authenticatedConnections.size());
                    }
                } else {
                    if (this.debug) {
                        this.out.println("DEBUG: pool is full, not adding an Authenticated connection");
                    }
                    try {
                        iMAPProtocol.logout();
                    }
                    catch (ProtocolException protocolException) {}
                }
            }
            if (this.pool.folders != null) {
                this.pool.folders.removeElement(iMAPFolder);
            }
            this.timeoutConnections();
            return;
        }
    }

    void releaseStoreProtocol(IMAPProtocol iMAPProtocol) {
        if (iMAPProtocol == null) {
            return;
        }
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (!this.pool.separateStoreConnection) {
                ConnectionPool connectionPool2 = this.pool;
                connectionPool2.borrowedStoreConnections = connectionPool2.borrowedStoreConnections - 1L;
                if (this.pool.debug) {
                    this.out.println("DEBUG: releaseStoreProtocol() -- borrowedStoreConnections: " + this.pool.borrowedStoreConnections);
                }
            }
            this.timeoutConnections();
            return;
        }
    }

    private void emptyConnectionPool(boolean bl) {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            int n = this.pool.authenticatedConnections.size() - 1;
            while (n >= 0) {
                try {
                    IMAPProtocol iMAPProtocol = (IMAPProtocol)this.pool.authenticatedConnections.elementAt(n);
                    iMAPProtocol.removeResponseHandler(this);
                    if (bl) {
                        iMAPProtocol.disconnect();
                    } else {
                        iMAPProtocol.logout();
                    }
                }
                catch (ProtocolException protocolException) {}
                --n;
            }
            this.pool.authenticatedConnections.removeAllElements();
        }
        if (this.pool.debug) {
            this.out.println("DEBUG: removed all authenticated connections");
        }
    }

    private void timeoutConnections() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (System.currentTimeMillis() - this.pool.lastTimePruned > this.pool.pruningInterval && this.pool.authenticatedConnections.size() > 1) {
                if (this.pool.debug) {
                    this.out.println("DEBUG: checking for connections to prune: " + (System.currentTimeMillis() - this.pool.lastTimePruned));
                    this.out.println("DEBUG: clientTimeoutInterval: " + this.pool.clientTimeoutInterval);
                }
                int n = this.pool.authenticatedConnections.size() - 1;
                while (n > 0) {
                    IMAPProtocol iMAPProtocol = (IMAPProtocol)this.pool.authenticatedConnections.elementAt(n);
                    if (this.pool.debug) {
                        this.out.println("DEBUG: protocol last used: " + (System.currentTimeMillis() - iMAPProtocol.getTimestamp()));
                    }
                    if (System.currentTimeMillis() - iMAPProtocol.getTimestamp() > this.pool.clientTimeoutInterval) {
                        if (this.pool.debug) {
                            this.out.println("DEBUG: authenticated connection timed out");
                            this.out.println("DEBUG: logging out the connection");
                        }
                        iMAPProtocol.removeResponseHandler(this);
                        this.pool.authenticatedConnections.removeElementAt(n);
                        try {
                            iMAPProtocol.logout();
                        }
                        catch (ProtocolException protocolException) {}
                    }
                    --n;
                }
                this.pool.lastTimePruned = System.currentTimeMillis();
            }
            return;
        }
    }

    int getFetchBlockSize() {
        return this.blksize;
    }

    Session getSession() {
        return ((Service)this).session;
    }

    int getStatusCacheTimeout() {
        return this.statusCacheTimeout;
    }

    int getAppendBufferSize() {
        return this.appendBufferSize;
    }

    public boolean hasCapability(String string) throws MessagingException {
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                boolean bl = iMAPProtocol.hasCapability(string);
                Object var5_4 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                return bl;
            }
            catch (ProtocolException protocolException) {
                if (iMAPProtocol == null) {
                    this.cleanup();
                }
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    public synchronized boolean isConnected() {
        if (!super.isConnected()) {
            return false;
        }
        IMAPProtocol iMAPProtocol = null;
        try {
            block5: {
                try {
                    iMAPProtocol = this.getStoreProtocol();
                    iMAPProtocol.noop();
                }
                catch (ProtocolException protocolException) {
                    if (iMAPProtocol != null) break block5;
                    this.cleanup();
                }
            }
            Object var3_2 = null;
            this.releaseStoreProtocol(iMAPProtocol);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return super.isConnected();
    }

    public void close() throws MessagingException {
        if (!super.isConnected()) {
            return;
        }
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                boolean bl;
                ConnectionPool connectionPool = this.pool;
                synchronized (connectionPool) {
                    bl = this.pool.authenticatedConnections.isEmpty();
                }
                if (bl) {
                    if (this.pool.debug) {
                        this.out.println("DEBUG: close() - no connections ");
                    }
                    this.cleanup();
                    Object var3_5 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    return;
                }
                iMAPProtocol = this.getStoreProtocol();
                connectionPool = this.pool;
                synchronized (connectionPool) {
                    this.pool.authenticatedConnections.removeElement(iMAPProtocol);
                }
                iMAPProtocol.logout();
            }
            catch (ProtocolException protocolException) {
                this.cleanup();
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        Object var3_6 = null;
        this.releaseStoreProtocol(iMAPProtocol);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private synchronized void cleanup() {
        this.cleanup(false);
    }

    private synchronized void cleanup(boolean bl) {
        ConnectionPool connectionPool;
        if (this.debug) {
            this.out.println("DEBUG: IMAPStore cleanup, force " + bl);
        }
        Vector vector = null;
        boolean bl2 = true;
        block11: while (true) {
            connectionPool = this.pool;
            synchronized (connectionPool) {
                if (this.pool.folders != null) {
                    bl2 = false;
                    vector = this.pool.folders;
                    this.pool.folders = null;
                } else {
                    bl2 = true;
                }
            }
            if (bl2) break;
            int n = 0;
            int n2 = vector.size();
            while (true) {
                if (n >= n2) continue block11;
                IMAPFolder iMAPFolder = (IMAPFolder)vector.elementAt(n);
                try {
                    if (bl) {
                        if (this.debug) {
                            this.out.println("DEBUG: force folder to close");
                        }
                        iMAPFolder.forceClose();
                    } else {
                        if (this.debug) {
                            this.out.println("DEBUG: close folder");
                        }
                        iMAPFolder.close(false);
                    }
                }
                catch (MessagingException messagingException) {
                }
                catch (IllegalStateException illegalStateException) {}
                ++n;
            }
            break;
        }
        connectionPool = this.pool;
        synchronized (connectionPool) {
            this.emptyConnectionPool(bl);
        }
        try {
            super.close();
        }
        catch (MessagingException messagingException) {}
        if (this.debug) {
            this.out.println("DEBUG: IMAPStore cleanup done");
        }
    }

    public Folder getDefaultFolder() throws MessagingException {
        this.checkConnected();
        return new DefaultFolder(this);
    }

    public Folder getFolder(String string) throws MessagingException {
        this.checkConnected();
        return new IMAPFolder(string, '\uffff', this);
    }

    public Folder getFolder(URLName uRLName) throws MessagingException {
        this.checkConnected();
        return new IMAPFolder(uRLName.getFile(), '\uffff', this);
    }

    public Folder[] getPersonalNamespaces() throws MessagingException {
        Namespaces namespaces = this.getNamespaces();
        if (namespaces == null || namespaces.personal == null) {
            return super.getPersonalNamespaces();
        }
        return this.namespaceToFolders(namespaces.personal, null);
    }

    public Folder[] getUserNamespaces(String string) throws MessagingException {
        Namespaces namespaces = this.getNamespaces();
        if (namespaces == null || namespaces.otherUsers == null) {
            return super.getUserNamespaces(string);
        }
        return this.namespaceToFolders(namespaces.otherUsers, string);
    }

    public Folder[] getSharedNamespaces() throws MessagingException {
        Namespaces namespaces = this.getNamespaces();
        if (namespaces == null || namespaces.shared == null) {
            return super.getSharedNamespaces();
        }
        return this.namespaceToFolders(namespaces.shared, null);
    }

    private synchronized Namespaces getNamespaces() throws MessagingException {
        this.checkConnected();
        IMAPProtocol iMAPProtocol = null;
        if (this.namespaces == null) {
            try {
                try {
                    iMAPProtocol = this.getStoreProtocol();
                    this.namespaces = iMAPProtocol.namespace();
                }
                catch (BadCommandException badCommandException) {
                }
                catch (ConnectionException connectionException) {
                    throw new StoreClosedException((Store)this, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
                }
                Object var3_4 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                if (iMAPProtocol == null) {
                    this.cleanup();
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                if (iMAPProtocol == null) {
                    this.cleanup();
                }
                throw throwable;
            }
        }
        return this.namespaces;
    }

    private Folder[] namespaceToFolders(Namespaces.Namespace[] namespaceArray, String string) {
        Folder[] folderArray = new Folder[namespaceArray.length];
        int n = 0;
        while (n < folderArray.length) {
            String string2 = namespaceArray[n].prefix;
            if (string == null) {
                int n2 = string2.length();
                if (n2 > 0 && string2.charAt(n2 - 1) == namespaceArray[n].delimiter) {
                    string2 = string2.substring(0, n2 - 1);
                }
            } else {
                string2 = String.valueOf(string2) + string;
            }
            folderArray[n] = new IMAPFolder(string2, namespaceArray[n].delimiter, this, string == null);
            ++n;
        }
        return folderArray;
    }

    public Quota[] getQuota(String string) throws MessagingException {
        Quota[] quotaArray = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                quotaArray = iMAPProtocol.getQuotaRoot(string);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("QUOTA not supported", (Exception)badCommandException);
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException((Store)this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            Object var5_7 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            if (iMAPProtocol == null) {
                this.cleanup();
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            if (iMAPProtocol == null) {
                this.cleanup();
            }
            throw throwable;
        }
        return quotaArray;
    }

    public void setQuota(Quota quota) throws MessagingException {
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                iMAPProtocol.setQuota(quota);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("QUOTA not supported", (Exception)badCommandException);
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException((Store)this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            Object var4_6 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            if (iMAPProtocol == null) {
                this.cleanup();
            }
            return;
        }
        catch (Throwable throwable) {
            block7: {
                Object var4_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                if (iMAPProtocol != null) break block7;
                this.cleanup();
            }
            throw throwable;
        }
    }

    private void checkConnected() {
        if (!super.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
    }

    public void handleResponse(Response response) {
        if (response.isOK() || response.isNO() || response.isBAD() || response.isBYE()) {
            this.handleResponseCode(response);
        }
        if (response.isBYE()) {
            if (this.debug) {
                this.out.println("DEBUG: IMAPStore connection dead");
            }
            if (super.isConnected()) {
                this.cleanup(response.isSynthetic());
            }
            return;
        }
    }

    void handleResponseCode(Response response) {
        String string = response.getRest();
        boolean bl = false;
        if (string.startsWith("[")) {
            int n = string.indexOf(93);
            if (n > 0 && string.substring(0, n + 1).equalsIgnoreCase("[ALERT]")) {
                bl = true;
            }
            string = string.substring(n + 1).trim();
        }
        if (bl) {
            this.notifyStoreListeners(1, string);
            return;
        }
        if (response.isUnTagged() && string.length() > 0) {
            this.notifyStoreListeners(2, string);
        }
    }

    static class ConnectionPool {
        private Vector authenticatedConnections = new Vector();
        private Vector folders;
        private boolean separateStoreConnection = false;
        private long borrowedStoreConnections;
        private long clientTimeoutInterval = 45000L;
        private long serverTimeoutInterval = 1800000L;
        private long lastTimePruned;
        private int poolSize = 1;
        private long pruningInterval = 60000L;
        private boolean debug = false;

        ConnectionPool() {
        }
    }
}

