/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.rating;

import java.util.HashMap;
import java.util.MissingResourceException;
import jp.co.nri.ridual.r2.db.bean.AbstractNodable;
import jp.co.nri.ridual.r2.db.bean.common.RatingProfileItemBean;
import jp.co.nri.ridual.r2.rating.AbstractRatingItem;
import jp.co.nri.ridual.r2.rating.RatingInfo;
import jp.co.nri.ridual.r2.rating.RatingPluginInfo;
import jp.co.nri.ridual.r2.rating.RatingResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RatingItem
extends AbstractRatingItem {
    private static final String ELEMENT_NAME_PAGE = "PAGE";
    private static final String ELEMENT_NAME_WEIGHT = "WEIGHT";
    private static final String ELEMENT_NAME_EXECUTION = "EXECUTION";
    private static final String ELEMENT_NAME_RATE = "RATE";
    private static final String ELEMENT_NAME_CLASS_NAME = "CLASS";
    private static final String ELEMENT_NAME_ID = "ID";
    private static final String ELEMENT_NAME_ACTIVE = "ACTIVE";
    private static final String ELEMENT_NAME_ROOT = "RATING";
    private static final String ELEMENT_NAME_RECOMMEND_ACTIVE_NAME = "RECOMMENDACTIVE";
    private static final String ELEMENT_NAME_RECOMMEND_WEIGHT_NAME = "RECOMMENDWEIGHT";
    private static final String ELEMENT_NAME_METHOD = "METHOD";
    private final String ratingitem;

    public RatingItem(HashMap result, String ratingitem) {
        super(result);
        this.ratingitem = ratingitem;
    }

    public Node buildNode(int mode, Document doc) throws Throwable {
        Element elm = doc.createElement(ELEMENT_NAME_ROOT);
        RatingPluginInfo pinfo = RatingInfo.instance.getPluginInfo(this.ratingitem);
        super.buildTextElement(elm, "CAPTION", pinfo.caption);
        super.buildBooleanElement(elm, ELEMENT_NAME_ACTIVE, pinfo.exists);
        super.buildIntElement(elm, ELEMENT_NAME_METHOD, pinfo.method);
        switch (mode) {
            case 25: {
                try {
                    RatingResult rr = (RatingResult)this.result.get(this.ratingitem);
                    if (rr == null) {
                        super.buildBooleanElement(elm, ELEMENT_NAME_EXECUTION, false);
                        break;
                    }
                    super.buildIntElement(elm, ELEMENT_NAME_WEIGHT, rr.weight);
                    super.buildIntElement(elm, ELEMENT_NAME_PAGE, rr.pages4display);
                    super.buildDoubleElement(elm, ELEMENT_NAME_RATE, rr.rate);
                    super.buildBooleanElement(elm, ELEMENT_NAME_EXECUTION, true);
                }
                catch (MissingResourceException mr) {
                    super.buildBooleanElement(elm, ELEMENT_NAME_EXECUTION, false);
                }
                break;
            }
            case 27: {
                super.buildTextElement(elm, ELEMENT_NAME_CLASS_NAME, this.ratingitem);
                super.buildTextElement(elm, ELEMENT_NAME_RECOMMEND_ACTIVE_NAME, pinfo.recommendedExecution);
                super.buildTextElement(elm, ELEMENT_NAME_RECOMMEND_WEIGHT_NAME, pinfo.recommendedWeight);
                break;
            }
            case 28: {
                try {
                    super.buildTextElement(elm, ELEMENT_NAME_CLASS_NAME, this.ratingitem);
                    super.buildTextElement(elm, ELEMENT_NAME_RECOMMEND_ACTIVE_NAME, pinfo.recommendedExecution);
                    super.buildTextElement(elm, ELEMENT_NAME_RECOMMEND_WEIGHT_NAME, pinfo.recommendedWeight);
                    RatingProfileItemBean rpibean = (RatingProfileItemBean)this.result.get(this.ratingitem);
                    if (rpibean == null) break;
                    super.buildIntElement(elm, ELEMENT_NAME_WEIGHT, rpibean.getWeight());
                    super.buildBooleanElement(elm, ELEMENT_NAME_EXECUTION, rpibean.getExecution());
                    super.buildElement(elm, ELEMENT_NAME_ID, rpibean.getId());
                }
                catch (MissingResourceException mr) {}
                break;
            }
        }
        return elm;
    }

    public AbstractNodable[] loadChild(int mode) throws Throwable {
        return null;
    }
}

