/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.rating;

import java.util.ResourceBundle;
import jp.co.nri.ridual.r2.common.pattern.Patterns;
import jp.co.nri.ridual.r2.rating.RatingGroup;
import jp.co.nri.ridual.r2.rating.RatingPluginJar;

public class RatingCategory {
    public final String name;
    public final String caption;
    public final String prefix;
    public final RatingGroup[] units;
    private static final String TAIL_CAPTION = ".caption";

    public RatingCategory(RatingPluginJar jar) {
        this.name = jar.category;
        this.prefix = jar.prefix;
        this.caption = jar.caption;
        int len = jar.units.length;
        this.units = new RatingGroup[len];
        int i = 0;
        while (i < len) {
            this.units[i] = jar.units[i].buildGroup();
            ++i;
        }
    }

    public RatingCategory(ResourceBundle res) {
        this.name = res.getString("RidualPluginCategory");
        this.caption = res.getString("caption");
        this.prefix = res.getString("ridual_prefix");
        String[] unitnames = Patterns.SP_PATTERN.split(res.getString("RidualPluginUnits"));
        int len = unitnames.length;
        this.units = new RatingGroup[len];
        int i = 0;
        while (i < len) {
            String unitname = unitnames[i];
            this.units[i] = new RatingGroup(res.getString(String.valueOf(unitname) + TAIL_CAPTION), Patterns.SP_PATTERN.split(res.getString(unitname)));
            ++i;
        }
    }
}

