/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.filelistmaker;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import jp.co.nri.ridual.r2.db.bean.project.LocalFileBean;
import jp.co.nri.ridual.r2.db.dao.LocalFileDAO;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import jp.co.nri.ridual.r2.filelistmaker.MappingTableModel;

class DirTraceRobo
extends Thread {
    private static final String SP = "/";
    private static final String EMPTY = "";
    private final Integer projectId;
    private final Integer localHistoryId;
    private final Integer directoryMapId;
    private final File dir;
    private final MappingTableModel model;
    private final int row;
    private int countComplete;
    private int countAll;

    public DirTraceRobo(Integer projectId, Integer localHistoryId, Integer directoryMapId, File dir, MappingTableModel model, int row) {
        this.projectId = projectId;
        this.localHistoryId = localHistoryId;
        this.directoryMapId = directoryMapId;
        this.dir = dir;
        this.model = model;
        this.row = row;
    }

    public void run() {
        try {
            this.countComplete = 0;
            this.countAll = 0;
            if (this.dir.isDirectory()) {
                this.trace(this.dir.listFiles(), EMPTY);
            } else {
                this.model.setStatus(this.row, String.valueOf(this.dir.getAbsolutePath()) + "\u306f\u5b58\u5728\u3057\u306a\u3044\u304b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u3042\u308a\u307e\u305b\u3093.\n" + "\u30d5\u30a1\u30a4\u30eb\u304c\u306a\u3044\u7a7a\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3068\u3057\u3066\u767b\u9332\u3057\u307e\u3057\u305f.");
            }
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueProject(this.projectId, "local.FileListMaker", "local.FilelistMaker", null, t);
            StringWriter swriter = new StringWriter();
            t.printStackTrace(new PrintWriter(swriter));
            this.model.setStatus(this.row, "\u554f\u984c\u304c\u767a\u751f\u3057\u307e\u3057\u305f.\n" + swriter.toString());
        }
    }

    private void trace(File[] files, String relativePath) throws Throwable {
        int len = files.length;
        this.countAll += len;
        int i = 0;
        while (i < len) {
            File file = files[i];
            if (file.isFile()) {
                LocalFileBean bean = new LocalFileBean(this.localHistoryId, this.directoryMapId, relativePath, file);
                LocalFileDAO.instance.save(this.projectId, bean);
            } else if (file.isDirectory()) {
                this.trace(file.listFiles(), String.valueOf(relativePath) + file.getName() + SP);
            }
            ++this.countComplete;
            ++i;
        }
        this.model.setStatus(this.row, String.valueOf(this.countComplete) + SP + this.countAll);
    }
}

