/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.dao;

import jp.co.nri.ridual.r2.db.bean.common.queue.WebCaptureTargetBean;
import jp.co.nri.ridual.r2.db.dao.DefaultCommonDAO;
import jp.co.nri.ridual.r2.db.dao.RetryOverException;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class WebCaptureQueueDAO
extends DefaultCommonDAO {
    public static final WebCaptureQueueDAO instance = new WebCaptureQueueDAO();

    private WebCaptureQueueDAO() {
        super(1);
    }

    public void enqueue(Integer projectId, Integer historyId, Integer imageId, String url) throws Throwable {
        WebCaptureTargetBean bean = new WebCaptureTargetBean(projectId, historyId, imageId, url);
        try {
            super.save(bean);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.WebCaptureQueue", e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WebCaptureTargetBean dequeue() throws Throwable {
        try {
            SessionFactory factory = super.getSessionFactory();
            RetryOverException roe = new RetryOverException(factory);
            Session session = factory.openSession();
            while (true) {
                try {
                    WebCaptureTargetBean webCaptureTargetBean;
                    try {
                        Transaction transaction = session.beginTransaction();
                        try {
                            Query query = session.getNamedQuery("webcapturequeue.dequeue");
                            query.setMaxResults(1);
                            WebCaptureTargetBean bean = (WebCaptureTargetBean)query.uniqueResult();
                            if (bean != null) {
                                bean.setStatus(1);
                                session.update((Object)bean);
                            }
                            transaction.commit();
                            webCaptureTargetBean = bean;
                            Object var7_11 = null;
                        }
                        catch (Throwable t) {
                            transaction.rollback();
                            throw t;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        session.close();
                        throw throwable;
                    }
                    session.close();
                    return webCaptureTargetBean;
                }
                catch (Throwable t) {
                    session = roe.retry(t);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.WebCaptureQueue", e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(WebCaptureTargetBean bean) throws Throwable {
        try {
            SessionFactory factory = super.getSessionFactory();
            Session session = factory.openSession();
            RetryOverException roe = new RetryOverException(factory);
            while (true) {
                try {
                    try {
                        Transaction transaction = session.beginTransaction();
                        try {
                            session.delete((Object)bean);
                            transaction.commit();
                            Object var7_8 = null;
                        }
                        catch (Throwable t) {
                            transaction.rollback();
                            throw t;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        session.close();
                        throw throwable;
                    }
                    session.close();
                    return;
                }
                catch (Throwable t) {
                    session = roe.retry(t);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.WebCaptureQueue", e);
            throw e;
        }
    }

    public void deleteByImageId(Integer id) throws Throwable {
        try {
            super.updateByName("webcapturequeue.deleteByImageId", id);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.WebCaptureQueue", e);
            throw e;
        }
    }

    public void deleteByHistoryId(Integer id) throws Throwable {
        try {
            super.updateByName("webcapturequeue.deleteByHistoryId", id);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.WebCaptureQueue", e);
            throw e;
        }
    }
}

