/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.Mapping;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class ExportSchema {
    private final ConnectionProvider connectionProvider;
    final Configuration configuration;
    private final Dialect dialect;
    private final List exceptions = new ArrayList();
    private transient Mapping mapping = this.buildMapping();

    public ExportSchema(Configuration cfg) {
        Properties connectionProperties = cfg.getProperties();
        this.configuration = cfg;
        this.dialect = Dialect.getDialect((Properties)connectionProperties);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        props.putAll((Map<?, ?>)connectionProperties);
        this.connectionProvider = ConnectionProviderFactory.newConnectionProvider((Properties)props);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportIfNotExists() throws SQLException {
        Connection connection;
        block10: {
            connection = null;
            Statement statement = null;
            this.exceptions.clear();
            try {
                connection = this.connectionProvider.getConnection();
                if (!connection.getAutoCommit()) {
                    connection.commit();
                    connection.setAutoCommit(true);
                }
                DatabaseMetadata meta = new DatabaseMetadata(connection, this.dialect);
                statement = connection.createStatement();
                String[] createSQL = this.generateSchemaCreationScript(meta);
                int i = 0;
                while (i < createSQL.length) {
                    try {
                        statement.executeUpdate(createSQL[i]);
                    }
                    catch (SQLException e) {
                        this.exceptions.add(e);
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
                if (this.connectionProvider == null) throw throwable;
                this.connectionProvider.close();
                throw throwable;
            }
            {
                Object var7_9 = null;
                if (statement == null) break block10;
            }
            statement.close();
        }
        if (connection != null) {
            connection.close();
        }
        if (this.connectionProvider == null) return;
        this.connectionProvider.close();
    }

    private String[] generateSchemaCreationScript(DatabaseMetadata databaseMetadata) throws HibernateException {
        Properties properties = this.configuration.getProperties();
        String defaultCatalog = properties.getProperty("hibernate.default_catalog");
        String defaultSchema = properties.getProperty("hibernate.default_schema");
        ArrayList<String> script = new ArrayList<String>(50);
        Iterator iter = this.configuration.getTableMappings();
        while (iter.hasNext()) {
            Iterator subIter;
            TableMetadata tableInfo;
            Table table = (Table)iter.next();
            if (!table.isPhysicalTable() || (tableInfo = databaseMetadata.getTableMetadata(table.getName(), table.getSchema(), table.getCatalog())) != null) continue;
            script.add(table.sqlCreateString(this.dialect, this.mapping, defaultCatalog, defaultSchema));
            if (!this.dialect.supportsUniqueConstraintInCreateAlterTable()) {
                subIter = table.getUniqueKeyIterator();
                while (subIter.hasNext()) {
                    UniqueKey uk = (UniqueKey)subIter.next();
                    script.add(uk.sqlCreateString(this.dialect, this.mapping, defaultCatalog, defaultSchema));
                }
            }
            subIter = table.getIndexIterator();
            while (subIter.hasNext()) {
                Index index = (Index)subIter.next();
                script.add(index.sqlCreateString(this.dialect, this.mapping, defaultCatalog, defaultSchema));
            }
            if (this.dialect.hasAlterTable()) {
                subIter = table.getForeignKeyIterator();
                while (subIter.hasNext()) {
                    ForeignKey fk = (ForeignKey)subIter.next();
                    if (!fk.isPhysicalConstraint()) continue;
                    script.add(fk.sqlCreateString(this.dialect, this.mapping, defaultCatalog, defaultSchema));
                }
            }
            Iterator comments = table.sqlCommentStrings(this.dialect, defaultCatalog, defaultSchema);
            while (comments.hasNext()) {
                script.add((String)comments.next());
            }
        }
        iter = this.iterateGenerators();
        while (iter.hasNext()) {
            String[] lines = ((PersistentIdentifierGenerator)iter.next()).sqlCreateStrings(this.dialect);
            int i = 0;
            while (i < lines.length) {
                script.add(lines[i]);
                ++i;
            }
        }
        return ArrayHelper.toStringArray(script);
    }

    private Mapping buildMapping() {
        return new Mapping(){

            public Type getIdentifierType(String persistentClass) throws MappingException {
                PersistentClass pc = ExportSchema.this.configuration.getClassMapping(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                return pc.getIdentifier().getType();
            }

            public String getIdentifierPropertyName(String persistentClass) throws MappingException {
                PersistentClass pc = ExportSchema.this.configuration.getClassMapping(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                if (!pc.hasIdentifierProperty()) {
                    return null;
                }
                return pc.getIdentifierProperty().getName();
            }

            public Type getPropertyType(String persistentClass, String propertyName) throws MappingException {
                PersistentClass pc = ExportSchema.this.configuration.getClassMapping(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                Property prop = pc.getProperty(propertyName);
                if (prop == null) {
                    throw new MappingException("property not known: " + persistentClass + '.' + propertyName);
                }
                return prop.getType();
            }
        };
    }

    private Iterator iterateGenerators() throws MappingException {
        IdentifierGenerator ig;
        TreeMap<Object, IdentifierGenerator> generators = new TreeMap<Object, IdentifierGenerator>();
        Properties properties = this.configuration.getProperties();
        String defaultCatalog = properties.getProperty("hibernate.default_catalog");
        String defaultSchema = properties.getProperty("hibernate.default_schema");
        Iterator iter = this.configuration.getClassMappings();
        while (iter.hasNext()) {
            PersistentClass pc = (PersistentClass)iter.next();
            if (pc.isInherited() || !((ig = pc.getIdentifier().createIdentifierGenerator(this.dialect, defaultCatalog, defaultSchema, (RootClass)pc)) instanceof PersistentIdentifierGenerator)) continue;
            generators.put(((PersistentIdentifierGenerator)ig).generatorKey(), ig);
        }
        iter = this.configuration.getCollectionMappings();
        while (iter.hasNext()) {
            Collection collection = (Collection)iter.next();
            if (!collection.isIdentified() || !((ig = ((IdentifierCollection)collection).getIdentifier().createIdentifierGenerator(this.dialect, defaultCatalog, defaultSchema, null)) instanceof PersistentIdentifierGenerator)) continue;
            generators.put(((PersistentIdentifierGenerator)ig).generatorKey(), ig);
        }
        return generators.values().iterator();
    }
}

