/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.dao;

import jp.co.nri.ridual.r2.analyzequeue.AnalyzeQueue;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeQueueFactory;
import jp.co.nri.ridual.r2.db.dao.DefaultHistoryDAO;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import jp.co.nri.ridual.r2.resource.RidualResource;

class DropHistorySchemaRobo
extends Thread {
    private static final String ROBO_NAME = "DropHistorySchemaRobo HISTORY-ID:";
    private static final int INTERVAL = DropHistorySchemaRobo.buildInterval();
    private static final int DEFAULT_INTERVAL = 10000;
    private final Integer historyId;

    public DropHistorySchemaRobo(Integer historyId) {
        super(ROBO_NAME + historyId);
        this.historyId = historyId;
    }

    public void run() {
        try {
            AnalyzeQueue queue = AnalyzeQueueFactory.getAnalyzeQueue();
            while (queue.countAnalyzing(this.historyId) > 0) {
                try {
                    Thread.sleep(INTERVAL);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            DefaultHistoryDAO.dropHistorySchema(this.historyId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("Robo.DropHistorySchemaRobo", e);
        }
    }

    private static int buildInterval() {
        try {
            String interval = RidualResource.ANALYZEROBO_PROPERTIES.getString("dropHistorySchemaRobo.interval.watchQueue");
            return Integer.parseInt(interval);
        }
        catch (Throwable t) {
            return 10000;
        }
    }
}

