/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.bean.project;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import jp.co.nri.ridual.r2.common.uri.URIOperator;
import jp.co.nri.ridual.r2.db.bean.AbstractNodable;
import jp.co.nri.ridual.r2.db.bean.project.AbstractProjectNodable;
import jp.co.nri.ridual.r2.db.dao.LocalFileDAO;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DirectoryMapBean
extends AbstractProjectNodable {
    public static final String HQL_QUERY_NAME_FIND_BY_LOCAL_HISTORY_ID = "directoryMap.findByLocalHistoryId";
    private static final String ELEMENT_NAME_ROOT = "DIRECTORY_MAP";
    private static final String ELEMENT_NAME_URL = "URL";
    private static final String ELEMENT_NAME_DIR = "DIR";
    private static final String ROOT_PATH = "/";
    private static final char SLASH = '/';
    private Integer id;
    private Integer localHistoryId;
    private String urlscheme;
    private String urlhost;
    private int urlport = -1;
    private String urlpath;
    private String dir;

    public Node buildNode(Integer projectId, int mode, Document doc) {
        Element elm = doc.createElement(ELEMENT_NAME_ROOT);
        try {
            super.buildElement(elm, ELEMENT_NAME_URL, this.getURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        super.buildTextElement(elm, ELEMENT_NAME_DIR, this.dir);
        return elm;
    }

    public AbstractNodable[] loadChild(Integer projectId, int mode) throws Throwable {
        switch (mode) {
            case 20: {
                return LocalFileDAO.instance.findPagesByDirectoryMapId(projectId, this.id);
            }
            case 21: {
                return LocalFileDAO.instance.findResourcesByDirectoryMapId(projectId, this.id);
            }
        }
        return null;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getLocalHistoryId() {
        return this.localHistoryId;
    }

    public void setLocalHistoryId(Integer localHistoryId) {
        this.localHistoryId = localHistoryId;
    }

    public String getURLScheme() {
        return this.urlscheme;
    }

    public void setURLScheme(String urlscheme) {
        this.urlscheme = urlscheme;
    }

    public String getURLHost() {
        return this.urlhost;
    }

    public void setURLHost(String urlhost) {
        this.urlhost = urlhost;
    }

    public int getURLPort() {
        return this.urlport;
    }

    public void setURLPort(int urlport) {
        this.urlport = urlport;
    }

    public String getURLPath() {
        return this.urlpath;
    }

    public void setURLPath(String urlpath) {
        this.urlpath = urlpath;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setURL(URL url) throws MalformedURLException, URISyntaxException {
        url = URIOperator.instance.normalize(url);
        this.urlscheme = url.getProtocol();
        this.urlhost = url.getHost();
        this.urlport = url.getPort();
        String pathstr = url.getPath();
        String string = this.urlpath = pathstr == null || pathstr.length() > 0 ? pathstr : ROOT_PATH;
        if ('/' != this.urlpath.charAt(this.urlpath.length() - 1)) {
            this.urlpath = String.valueOf(this.urlpath) + '/';
        }
    }

    public URL getURL() throws MalformedURLException {
        return new URL(this.urlscheme, this.urlhost, this.urlport, this.urlpath);
    }
}

