/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.bean.common;

import java.util.Date;
import java.util.List;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeQueue;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeQueueFactory;
import jp.co.nri.ridual.r2.common.tabulationmap.TabulationMap;
import jp.co.nri.ridual.r2.db.bean.AbstractNodable;
import jp.co.nri.ridual.r2.db.bean.common.AbstractCommonNodable;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeSiteConfigBean;
import jp.co.nri.ridual.r2.db.bean.project.HalfKanaContainer;
import jp.co.nri.ridual.r2.db.bean.project.TableNestContainer;
import jp.co.nri.ridual.r2.db.bean.project.WrongCharContainer;
import jp.co.nri.ridual.r2.db.dao.AnalyzeSiteConfigDAO;
import jp.co.nri.ridual.r2.db.dao.ContentsAndVariationDAO;
import jp.co.nri.ridual.r2.db.dao.LocalHistoryDAO;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AnalyzeHistoryBean
extends AbstractCommonNodable {
    public static final String HQL_QUERY_NAME_LOAD_ACTIVE = "history.loadActive";
    public static final String HQL_QUERY_NAME_FIND_BY_SITE_ID = "history.findBySiteId";
    public static final String HQL_QUERY_NAME_FIND_INCOMPLETE = "history.findIncomplete";
    public static final String HQL_QUERY_NAME_FIND_LASTEST_BY_SITE_ID = "history.findLastestBySiteId";
    public static final String HQL_QUERY_NAME_FIND_INCOMPLETE_BUILD_REPORT = "history.findIncompleteBuildReport";
    public static final String HQL_QUERY_NAME_FIND_INCOMPLETE_BUILD_REPORT_BY_SERVER = "history.findIncompleteBuildReportByServer";
    public static final String HQL_QUERY_NAME_FIND_INCOMPLETE_RECHECKING = "history.findIncompleteRecheck";
    public static final String HQL_QUERY_NAME_FIND_INCOMPLETE_RECHECKING_BY_SERVER = "history.findIncompleteRecheckByServer";
    public static final String HQL_QUERY_NAME_FIND_INCOMPLETE_THUMBNAIL_REFRESHING = "history.findIncompleteThumbnailRefreshing";
    public static final String HQL_QUERY_NAME_FIND_INCOMPLETE_THUMBNAIL_REFRESHING_BY_SERVER = "history.findIncompleteThumbnailRefreshingByServer";
    public static final String HQL_QUERY_NAME_UPDATE_READY = "history.updateReady";
    public static final String HQL_QUERY_NAME_UPDATE_RECHECKING = "history.updateRechecking";
    public static final String HQL_QUERY_NAME_UPDATE_THUMBNAIL_REFRESHING = "history.updateThumbnailRefreshing";
    private static final String ELEMENT_NAME_ROOT = "ANALYZE_HISTORY";
    private static final String ELEMENT_NAME_ID = "ID";
    private static final String ELEMENT_NAME_TIMESTAMP_BEGIN = "TIMESTAMP_BEGIN";
    private static final String ELEMENT_NAME_TIMESTAMP_COMPLETE = "TIMESTAMP_COMPLETE";
    private static final String ELEMENT_NAME_TIME_DISTANCE = "TIME_DISTANCE";
    private static final String ELEMENT_NAME_READY = "READY";
    private static final String ELEMENT_NAME_SUM_EXTENSION = "SUM_EXTENSION";
    private static final String ELEMENT_NAME_SUM_CONTENT_TYPE = "SUM_CONTENT_TYPE";
    private static final String ELEMENT_NAME_COUNT_COMPLETE = "COUNT_COMPLETE";
    private static final String ELEMENT_NAME_COUNT = "COUNT_ALL";
    private static final String ELEMENT_NAME_SUM_IS_INNER = "SUM_IS_INNER";
    private static final String ELEMENT_NAME_COUNT_PAGES = "COUNT_PAGES";
    private static final String ELEMENT_NAME_COUNT_RELATIONS = "COUNT_RELATIONS";
    private static final String ELEMENT_NAME_CONTACT = "CONTACT";
    private static final String ELEMENT_NAME_IS_OUTPUT_DETAIL = "IS_OUTPUT_DETAIL";
    private static final String ELEMENT_NAME_RECHECKING = "RECHECKING";
    private static final String ELEMENT_NAME_THUMBNAIL_REFRESHING = "THUMBNAIL_REFRESHING";
    private static final String ELEMENT_NAME_LICENSE = "LICENSE";
    private static final String[] SUM_ATTRIBUTE_NAMES = new String[]{"innerContents", "innerVariation", "outerContents", "outerVariation"};
    private static final String ZERO = "0";
    private Integer id;
    private Integer siteId;
    private Date timestampBegin;
    private Date timestampComplete;
    private boolean ready = false;
    private boolean deleted = false;
    private String buildReportServer = null;
    private boolean rechecking = false;
    private Date timestampRecheck = null;
    private String recheckServer = null;
    private boolean thumbnailRefreshing = false;
    private Date timestampThumbnailRefresh = null;
    private String thumbnailRefreshServer = null;
    private Integer license;

    public Node buildNode(int mode, Document doc) throws Throwable {
        Element elm = doc.createElement(ELEMENT_NAME_ROOT);
        super.buildElement(elm, ELEMENT_NAME_ID, this.id);
        super.buildDateElement(elm, ELEMENT_NAME_TIMESTAMP_BEGIN, this.timestampBegin);
        switch (mode) {
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 14: 
            case 15: 
            case 17: 
            case 33: 
            case 34: 
            case 35: {
                AnalyzeSiteConfigBean siteBean = AnalyzeSiteConfigDAO.instance.loadActive(this.siteId);
                super.buildBooleanElement(elm, ELEMENT_NAME_IS_OUTPUT_DETAIL, siteBean.isOutputDetail(this.id));
                break;
            }
            case 1: {
                Integer projectId = this.buildNodeDetail(elm);
                this.buildNodeTimestampAndProgress(elm);
                int countPages = ContentsAndVariationDAO.instance.countInnerPagesByHistoryId(projectId, this.id);
                super.buildIntElement(elm, ELEMENT_NAME_COUNT_PAGES, countPages);
                super.buildBooleanElement(elm, ELEMENT_NAME_READY, this.ready);
                super.buildBooleanElement(elm, ELEMENT_NAME_RECHECKING, this.rechecking);
                super.buildBooleanElement(elm, ELEMENT_NAME_THUMBNAIL_REFRESHING, this.thumbnailRefreshing);
                super.buildElement(elm, ELEMENT_NAME_LICENSE, this.license);
                break;
            }
            case 18: 
            case 23: 
            case 24: {
                this.buildNodeTimestampAndProgress(elm);
                break;
            }
            case 31: {
                Integer pId = this.buildNodeDetail(elm);
                TabulationMap tmap = ContentsAndVariationDAO.instance.tabulationByExtension(pId, this.id);
                elm.appendChild(tmap.buildNode(doc, ELEMENT_NAME_SUM_EXTENSION));
                break;
            }
            case 2: {
                super.buildDateElement(elm, ELEMENT_NAME_TIMESTAMP_COMPLETE, this.timestampComplete);
                Integer prjId = this.buildNodeDetail(elm);
                String[] contact = ContentsAndVariationDAO.instance.findContact(prjId, this.id);
                super.buildTextsElement(elm, ELEMENT_NAME_CONTACT, contact);
                TabulationMap map = ContentsAndVariationDAO.instance.tabulationByExtension(prjId, this.id);
                elm.appendChild(map.buildNode(doc, ELEMENT_NAME_SUM_EXTENSION));
                map = ContentsAndVariationDAO.instance.tabulationByContentType(prjId, this.id);
                elm.appendChild(map.buildNode(doc, ELEMENT_NAME_SUM_CONTENT_TYPE));
                String[] sumByIsInner = ContentsAndVariationDAO.instance.sumByIsInner(prjId, this.id);
                Element elmSumInner = doc.createElement(ELEMENT_NAME_SUM_IS_INNER);
                int i = SUM_ATTRIBUTE_NAMES.length - 1;
                while (i >= 0) {
                    String sum = sumByIsInner[i];
                    elmSumInner.setAttribute(SUM_ATTRIBUTE_NAMES[i], sum == null ? ZERO : sum);
                    --i;
                }
                elm.appendChild(elmSumInner);
            }
        }
        return elm;
    }

    private Integer buildNodeDetail(Element elm) throws Throwable {
        if (this.timestampComplete != null && this.timestampBegin != null) {
            long time = this.timestampComplete.getTime() - this.timestampBegin.getTime();
            super.buildLongElement(elm, ELEMENT_NAME_TIME_DISTANCE, time);
        }
        AnalyzeSiteConfigBean siteBean = AnalyzeSiteConfigDAO.instance.loadActive(this.siteId);
        Integer projectId = siteBean.getProjectId();
        int countRelations = ContentsAndVariationDAO.instance.countRelationByHistoryId(projectId, this.id);
        super.buildIntElement(elm, ELEMENT_NAME_COUNT_RELATIONS, countRelations);
        return projectId;
    }

    private void buildNodeTimestampAndProgress(Element elm) throws Throwable {
        if (this.timestampComplete == null) {
            AnalyzeQueue queue = AnalyzeQueueFactory.getAnalyzeQueue();
            super.buildIntElement(elm, ELEMENT_NAME_COUNT_COMPLETE, queue.countComplete(this.id));
            super.buildIntElement(elm, ELEMENT_NAME_COUNT, queue.countAll(this.id));
        } else {
            super.buildDateElement(elm, ELEMENT_NAME_TIMESTAMP_COMPLETE, this.timestampComplete);
        }
    }

    public AbstractNodable[] loadChild(int mode) throws Throwable {
        switch (mode) {
            case 1: {
                return LocalHistoryDAO.instance.findByHistoryId(this.id);
            }
            case 2: {
                AnalyzeSiteConfigBean site = AnalyzeSiteConfigDAO.instance.loadActive(this.siteId);
                return new AbstractNodable[]{site, new TableNestContainer(this.id, site.getNestTableLimit()), new HalfKanaContainer(this.id), new WrongCharContainer(this.id)};
            }
            case 23: {
                return new AbstractNodable[]{AnalyzeSiteConfigDAO.instance.loadActive(this.siteId)};
            }
            case 9: {
                AnalyzeSiteConfigBean siteBean = AnalyzeSiteConfigDAO.instance.load(this.siteId);
                Integer projectId = siteBean.getProjectId();
                List list = ProjectLogDAO.instance.findIssueHistory(projectId, this.id);
                list.addAll(ContentsAndVariationDAO.instance.findHasLog(projectId, this.id));
                return list.toArray(new AbstractNodable[0]);
            }
        }
        return null;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getSiteId() {
        return this.siteId;
    }

    public void setSiteId(Integer siteId) {
        this.siteId = siteId;
    }

    public Date getTimestampBegin() {
        return this.timestampBegin;
    }

    public void setTimestampBegin(Date timestamp) {
        this.timestampBegin = timestamp;
    }

    public Date getTimestampComplete() {
        return this.timestampComplete;
    }

    public void setTimestampComplete(Date timestamp) {
        this.timestampComplete = timestamp;
    }

    public boolean getReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getBuildReportServer() {
        return this.buildReportServer;
    }

    public void setBuildReportServer(String buildReportServer) {
        this.buildReportServer = buildReportServer;
    }

    public boolean getRechecking() {
        return this.rechecking;
    }

    public void setRechecking(boolean rechecking) {
        this.rechecking = rechecking;
    }

    public Date getTimestampRecheck() {
        return this.timestampRecheck;
    }

    public void setTimestampRecheck(Date timestamp) {
        this.timestampRecheck = timestamp;
    }

    public String getRecheckServer() {
        return this.recheckServer;
    }

    public void setRecheckServer(String recheckServer) {
        this.recheckServer = recheckServer;
    }

    public boolean getThumbnailRefreshing() {
        return this.thumbnailRefreshing;
    }

    public void setThumbnailRefreshing(boolean thumbnailRefreshing) {
        this.thumbnailRefreshing = thumbnailRefreshing;
    }

    public Date getTimestampThumbnailRefresh() {
        return this.timestampThumbnailRefresh;
    }

    public void setTimestampThumbnailRefresh(Date timestamp) {
        this.timestampThumbnailRefresh = timestamp;
    }

    public String getThumbnailRefreshServer() {
        return this.thumbnailRefreshServer;
    }

    public void setThumbnailRefreshServer(String thumbnailRefreshServer) {
        this.thumbnailRefreshServer = thumbnailRefreshServer;
    }

    public Integer getLicense() {
        return this.license;
    }

    public void setLicense(Integer license) {
        this.license = license;
    }

    public boolean isDuringProcessing() {
        return !this.ready || this.rechecking;
    }
}

