/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.servletutil.parameterconfig;

import jp.co.nri.ridual.r2.servletutil.parameter.IntegerServletParameter;
import jp.co.nri.ridual.r2.servletutil.parameter.ServletParameter;
import jp.co.nri.ridual.r2.servletutil.parameter.error.IntFormatErrorServletParameter;
import jp.co.nri.ridual.r2.servletutil.parameter.error.IntLargeErrorServletParameter;
import jp.co.nri.ridual.r2.servletutil.parameter.error.IntSmallErrorServletParameter;
import jp.co.nri.ridual.r2.servletutil.parameterconfig.ServletParameterConfig;

abstract class AbstractIntegerServletParameterConfig
extends ServletParameterConfig {
    private final int min;
    private final int max;
    private final boolean checkMin;
    private final boolean checkMax;

    public AbstractIntegerServletParameterConfig(String name, boolean isMust, boolean checkMin, int min, boolean checkMax, int max) {
        super(name, isMust);
        this.min = min;
        this.max = max;
        this.checkMin = checkMin;
        this.checkMax = checkMax;
    }

    public AbstractIntegerServletParameterConfig(String name, boolean isMust, boolean isMechanical, boolean checkMin, int min, boolean checkMax, int max) {
        super(name, isMust, isMechanical);
        this.min = min;
        this.max = max;
        this.checkMin = checkMin;
        this.checkMax = checkMax;
    }

    public AbstractIntegerServletParameterConfig(String name, boolean isMust) {
        super(name, isMust);
        this.min = 0;
        this.max = 0;
        this.checkMin = false;
        this.checkMax = false;
    }

    public AbstractIntegerServletParameterConfig(String name, boolean isMust, boolean isMechanical) {
        super(name, isMust, isMechanical);
        this.min = 0;
        this.max = 0;
        this.checkMin = false;
        this.checkMax = false;
    }

    public AbstractIntegerServletParameterConfig(String name, int countMin, int countMax, boolean isMust, boolean checkMin, int min, boolean checkMax, int max) {
        super(name, countMin, countMax, isMust);
        this.min = min;
        this.max = max;
        this.checkMin = checkMin;
        this.checkMax = checkMax;
    }

    public AbstractIntegerServletParameterConfig(String name, int countMin, int countMax, boolean isMust) {
        super(name, countMin, countMax, isMust);
        this.min = 0;
        this.max = 0;
        this.checkMin = false;
        this.checkMax = false;
    }

    protected ServletParameter buildServletParameter(String[] vals) {
        int len = vals.length;
        Integer[] intvals = new Integer[len];
        int i = 0;
        while (i < len) {
            String str = vals[i];
            if (str.length() <= 0) {
                intvals[i] = null;
            } else {
                try {
                    Integer obj = Integer.valueOf(str);
                    int iv = obj;
                    if (this.checkMin && iv < this.min) {
                        return new IntSmallErrorServletParameter(this.name, vals[i]);
                    }
                    if (this.checkMax && this.max < iv) {
                        return new IntLargeErrorServletParameter(this.name, vals[i]);
                    }
                    intvals[i] = obj;
                }
                catch (NumberFormatException e) {
                    return new IntFormatErrorServletParameter(this.name, vals[i]);
                }
            }
            ++i;
        }
        return this.buildServletParameter(intvals);
    }

    protected ServletParameter buildServletParameter(Integer[] vals) {
        int i = vals.length - 1;
        while (i >= 0) {
            Integer obj = vals[i];
            if (obj != null) {
                return new IntegerServletParameter(this.name, obj);
            }
            --i;
        }
        return null;
    }
}

