/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.servletutil.abstractservlet;

import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.co.nri.ridual.r2.common.messageformat.MessageFormatter;
import jp.co.nri.ridual.r2.common.uri.URIOperator;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeSiteConfigBean;
import jp.co.nri.ridual.r2.db.bean.common.LocalHistoryBean;
import jp.co.nri.ridual.r2.db.bean.common.RatingProfileBean;
import jp.co.nri.ridual.r2.db.bean.project.ImageBean;
import jp.co.nri.ridual.r2.db.dao.AnalyzeHistoryDAO;
import jp.co.nri.ridual.r2.db.dao.AnalyzeSiteConfigDAO;
import jp.co.nri.ridual.r2.db.dao.ImageDAO;
import jp.co.nri.ridual.r2.db.dao.LocalHistoryDAO;
import jp.co.nri.ridual.r2.db.dao.RatingProfileDAO;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import jp.co.nri.ridual.r2.servletutil.parameter.ServletParameterMap;
import jp.co.nri.ridual.r2.servletutil.parameterconfig.ServletParameterConfig;

public abstract class AbstractGetAndPostServlet
extends HttpServlet {
    protected static final String CODE_ALL_PARAMETER_ERROR = "All.Error.Parameter";
    protected static final String CODE_ALL_PARAMETER_ERROR_HAND_INPUT = "All.Error.Parameter.HandInput";
    protected static final String CODE_ALL_SYSTEM_ERROR = "All.Error.System";
    protected static final String CODE_ALL_LOAD_HISTORY_ERROR = "All.Error.Load.History";
    protected static final String CODE_ALL_LOAD_LOCAL_HISTORY_ERROR = "All.Error.Load.LocalHistory";
    protected static final String CODE_ALL_LOAD_SITE_ERROR = "All.Error.Load.Site";
    protected static final String CODE_ALL_LOAD_SITE_BY_HISTORY_ERROR = "All.Error.Load.Site.ByHistoryId";
    protected static final String CODE_ALL_LOAD_IMAGE_ERROR = "All.Error.Load.Image";
    protected static final String CODE_ALL_LOAD_RATING_PROFILE_ERROR = "All.Error.Load.RatingProfile";
    protected static final String CODE_ANALYZE_START_URL_ERROR = "Analyze.Error.StartURL";
    protected static final String CODE_ANALYZE_INNER_SITE_URL_ERROR = "Analyze.Error.InnerSiteURL";
    protected static final String CODE_ANALYZE_MAIL_ERROR = "Analyze.Error.MailAddress";
    protected static final String CODE_ANALYZE_PROFILE_ERROR = "Analyze.Error.ProfileId";
    protected static final String CODE_DELETE_HISTORY_ERROR = "DeleteHistory.Error";
    protected static final String CODE_DELETE_SITE_CONFIG_ERROR = "DeleteSiteConfig.Error";
    protected static final String CODE_DELETE_LOCAL_HISTORY_ERROR = "DeleteLocalHistory.Error";
    protected static final String CODE_DELETE_RATING_PROFILE_ERROR = "DeleteRatingProfile.Error";
    protected static final String CODE_H_OR_LH_DIALOG_DUPLICATION_ERROR = "LorLHDialog.Error.DuplicationId";
    protected static final String CODE_H_OR_LH_DIALOG_NONE_ID_ERROR = "LorLHDialog.Error.NoneId";
    protected static final String CODE_ENTRY_REANA_ERROR = "ReAna.Error";
    protected static final String CODE_REBUILD_ALREADY_INFO = "Rebuild.Info.already";
    protected static final String CODE_ENTRY_RECHECK_ERROR = "ReCheck.Error";
    protected static final String CODE_SET_LOCAL_ERROR = "SetLocal.Error";
    protected static final String CODE_SET_ROBO_COUNT_ERROR = "SetRoboCount.Error";
    protected static final String CODE_REFRESH_THUMBNAIL_ERROR = "RefreshThumbnail.Error";
    protected static final String CODE_SAVE_CONFIG_NO_FROM_ERROR = "SaveRidualServerConfig.Error.NoFrom";
    protected static final String CODE_SAVE_CONFIG_SAVE_ERROR = "SaveRidualServerConfig.Error.save";
    protected static final String ELEMENT_NAME_RIDUAL_SERVER_MESSAGE = "RIDUAL_SERVER_MESSAGE";
    private static final ServletParameterConfig[] EMPTY_PCONFIGS = new ServletParameterConfig[0];
    private final ServletParameterConfig[] pconfigs;
    protected final String method;
    protected final String errorRedirectDir;

    protected abstract void doGetAndPost(HttpServletRequest var1, HttpServletResponse var2, ServletParameterMap var3) throws Throwable;

    protected AbstractGetAndPostServlet(ServletParameterConfig[] pconfigs, String method, String errorForwardDir) {
        this.pconfigs = pconfigs;
        this.method = method;
        this.errorRedirectDir = errorForwardDir;
    }

    protected AbstractGetAndPostServlet(String method, String errorForwardDir) {
        this(EMPTY_PCONFIGS, method, errorForwardDir);
    }

    protected void redirectSitelist(HttpServletResponse response) {
        this.redirect(response, "./sitelist");
    }

    protected void redirectIndex(HttpServletResponse response) {
        this.redirect(response, "./index.html");
    }

    protected void redirectParentIndex(HttpServletResponse response) {
        this.redirect(response, "../index.html");
    }

    private void redirect(HttpServletResponse response, String to) {
        try {
            response.sendRedirect(response.encodeRedirectURL(to));
        }
        catch (Throwable t) {
            this.saveRidualServerLog(t);
        }
    }

    protected void redirectErrorWithMessage(String code, Object[] param, HttpServletResponse response) {
        if (this.errorRedirectDir == null) {
            return;
        }
        try {
            String mes = MessageFormatter.instance.formatServletMessage(code, param);
            mes = "?mes=" + URIOperator.instance.encodeHTTP(mes);
            response.sendRedirect(String.valueOf(this.errorRedirectDir) + mes);
        }
        catch (Throwable t) {
            this.saveRidualServerLog(t);
        }
    }

    protected void saveRidualServerLog(Throwable t) {
        RidualServerLogDAO.getInstance().record(this.method, t);
    }

    protected void saveRidualServerLog(String code, Object[] param, Throwable t) {
        RidualServerLogDAO.getInstance().record(this.method, code, param, t);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            ServletParameterMap paramap = new ServletParameterMap(this.pconfigs, request, this.method);
            if (!paramap.errors.isEmpty()) {
                paramap.errorsToRidualServerLog();
                this.redirectErrorWithMessage(CODE_ALL_PARAMETER_ERROR, null, response);
                return;
            }
            if (!paramap.errorsHandInput.isEmpty()) {
                this.redirectErrorWithMessage(CODE_ALL_PARAMETER_ERROR_HAND_INPUT, null, response);
                return;
            }
            this.doGetAndPost(request, response, paramap);
        }
        catch (Throwable t) {
            this.saveRidualServerLog(t);
            response.sendError(500, MessageFormatter.instance.formatServletMessage(CODE_ALL_SYSTEM_ERROR, null));
        }
    }

    protected AnalyzeHistoryBean loadActiveHistory(Integer id, HttpServletResponse response) throws Throwable {
        AnalyzeHistoryBean bean = AnalyzeHistoryDAO.instance.loadActive(id);
        if (bean != null) {
            return bean;
        }
        Object[] para = new Object[]{id};
        this.saveRidualServerLog("Servlet.Error.Load.History", para, null);
        this.redirectErrorWithMessage(CODE_ALL_LOAD_HISTORY_ERROR, para, response);
        return null;
    }

    protected AnalyzeHistoryBean loadHistory(Integer id, HttpServletResponse response) throws Throwable {
        AnalyzeHistoryBean bean = AnalyzeHistoryDAO.instance.load(id);
        if (bean != null) {
            return bean;
        }
        Object[] para = new Object[]{id};
        this.saveRidualServerLog("Servlet.Error.Load.History", para, null);
        this.redirectErrorWithMessage(CODE_ALL_LOAD_HISTORY_ERROR, para, response);
        return null;
    }

    protected LocalHistoryBean loadActiveLocalHistory(Integer id, HttpServletResponse response) throws Throwable {
        LocalHistoryBean bean = LocalHistoryDAO.instance.loadActive(id);
        if (bean != null) {
            return bean;
        }
        Object[] para = new Object[]{id};
        this.saveRidualServerLog("Servlet.Error.Load.LocalHistory", para, null);
        this.redirectErrorWithMessage(CODE_ALL_LOAD_LOCAL_HISTORY_ERROR, para, response);
        return null;
    }

    protected AnalyzeSiteConfigBean loadActiveSite(Integer id, HttpServletResponse response) throws Throwable {
        AnalyzeSiteConfigBean bean = AnalyzeSiteConfigDAO.instance.loadActive(id);
        if (bean != null) {
            return bean;
        }
        Object[] para = new Object[]{id};
        this.redirectErrorWithMessage(CODE_ALL_LOAD_SITE_ERROR, para, response);
        this.saveRidualServerLog("Servlet.Error.Load.Site", para, null);
        return null;
    }

    protected AnalyzeSiteConfigBean loadSiteByHistoryId(Integer historyId, HttpServletResponse response) throws Throwable {
        AnalyzeSiteConfigBean siteBean = AnalyzeSiteConfigDAO.instance.findByHistoryId(historyId);
        if (siteBean != null) {
            return siteBean;
        }
        Object[] para = new Object[]{historyId};
        this.redirectErrorWithMessage(CODE_ALL_LOAD_SITE_BY_HISTORY_ERROR, para, response);
        this.saveRidualServerLog("Servlet.Error.Load.Site.ByHistoryId", para, null);
        return null;
    }

    protected ImageBean loadImage(Integer prjId, Integer tid, HttpServletResponse response) throws Throwable {
        ImageBean bean = ImageDAO.instance.load(prjId, tid);
        if (bean != null) {
            return bean;
        }
        Object[] para = new Object[]{prjId, tid};
        this.redirectErrorWithMessage(CODE_ALL_LOAD_IMAGE_ERROR, para, response);
        this.saveRidualServerLog("Servlet.Error.Load.Image", para, null);
        return null;
    }

    protected RatingProfileBean loadProfile(Integer id, HttpServletResponse response) throws Throwable {
        RatingProfileBean bean = RatingProfileDAO.instance.findAliveById(id);
        if (bean != null) {
            return bean;
        }
        Object[] para = new Object[]{id};
        this.redirectErrorWithMessage(CODE_ALL_LOAD_RATING_PROFILE_ERROR, para, response);
        this.saveRidualServerLog("Servlet.Error.Load.RatingProfile", para, null);
        return null;
    }
}

