/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.robots.sendmailrobo;

import java.io.File;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import jp.co.nri.ridual.r2.properties.RidualServerConfigProperties;

public class SendMailRobo
extends Thread {
    public Integer projectId = null;
    public Integer historyId = null;
    public String to = null;
    public String subject = null;
    public String message = null;
    public File[] attachment = null;
    private static final String PROTOCOL = "smtp";
    private static final String ENCODING = "iso-2022-jp";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    private final RidualServerLogDAO ridualServerLogDAO = RidualServerLogDAO.getInstance();

    public void run() {
        try {
            InternetAddress[] toAddress = InternetAddress.parse((String)this.to);
            RidualServerConfigProperties props = RidualServerConfigProperties.getInstance();
            String host = props.getString("mail.smtp.host");
            String user = props.getString("mail.smtp.user");
            String pass = props.getStringS("mail.smtp.password");
            Integer port = props.getInteger("mail.smtp.port");
            String from = props.getString("mail.from");
            Session session = Session.getInstance((Properties)(user == null ? new Properties() : new SMTPAuthProperties()));
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setSentDate(new Date());
            mimeMessage.setHeader(HEADER_CONTENT_TYPE, HEADER_CONTENT_TYPE_TEXT_PLAIN);
            if (from != null) {
                mimeMessage.setFrom((Address)new InternetAddress(from));
            }
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])toAddress);
            if (this.subject != null) {
                mimeMessage.setSubject(this.subject, ENCODING);
            }
            if (this.attachment != null) {
                MimeMultipart mp = new MimeMultipart();
                if (this.message != null) {
                    MimeBodyPart textPart = new MimeBodyPart();
                    textPart.setText(this.message, ENCODING);
                    mp.addBodyPart((BodyPart)textPart);
                }
                int len = this.attachment.length;
                int i = 0;
                while (i < len) {
                    MimeBodyPart filePart = new MimeBodyPart();
                    File file = this.attachment[i];
                    filePart.setDataHandler(new DataHandler((DataSource)new FileDataSource(file)));
                    filePart.setFileName(file.getName());
                    mp.addBodyPart((BodyPart)filePart);
                    ++i;
                }
                mimeMessage.setContent((Multipart)mp);
                mimeMessage.saveChanges();
            } else if (this.message != null) {
                mimeMessage.setText(this.message, ENCODING);
            }
            Transport tp = session.getTransport(PROTOCOL);
            tp.connect(host, port == null ? -1 : port, user, pass);
            tp.sendMessage((Message)mimeMessage, (Address[])toAddress);
            tp.close();
        }
        catch (Throwable t) {
            this.ridualServerLogDAO.record("Robo.SendMailRobo", t);
            ProjectLogDAO.instance.recordIssueHistory(this.projectId, "sendMail", "SendMailRobo.sendMail", this.historyId, new Object[]{this.to}, t);
        }
    }

    private class SMTPAuthProperties
    extends Properties {
        public SMTPAuthProperties() {
            super.put("mail.smtp.auth", Boolean.TRUE.toString());
        }
    }
}

