/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.robots.removehistorydirrobo;

import java.io.File;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import jp.co.nri.ridual.r2.properties.RidualServerConfigProperties;
import jp.co.nri.ridual.r2.resource.RidualResource;
import jp.co.nri.ridual.r2.robots.AbstractRidualRobo;

public class RemoveHistoryDirRobo
extends AbstractRidualRobo {
    private static final String DIRNAME_HISTORY = RidualResource.BUILDREPORT_PROPERTIES.getString("dir.name.history");
    private final Integer projectId;
    private final Integer historyId;

    public RemoveHistoryDirRobo(Integer projectId, Integer historyId) throws Throwable {
        super("removeHistoryDir");
        this.projectId = projectId;
        this.historyId = historyId;
    }

    protected void play() {
        try {
            RidualServerConfigProperties props = RidualServerConfigProperties.getInstance();
            String staticDirStr = props.getString("ridual.dir.static");
            File staticdir = new File(staticDirStr);
            File historydir = new File(new File(staticdir, DIRNAME_HISTORY), this.historyId.toString());
            this.delete(historydir);
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueHistory(this.projectId, "removeDir.history", "RemoveHistoryDirRobo", this.historyId, null, t);
        }
    }

    private void delete(File file) {
        File[] children = file.listFiles();
        if (children != null) {
            int i = children.length - 1;
            while (i >= 0) {
                this.delete(children[i]);
                --i;
            }
        }
        file.delete();
    }
}

