/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.robots.refreshthumbnail;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeSiteConfigBean;
import jp.co.nri.ridual.r2.db.bean.project.ImageBean;
import jp.co.nri.ridual.r2.db.dao.AnalyzeHistoryDAO;
import jp.co.nri.ridual.r2.db.dao.AnalyzeSiteConfigDAO;
import jp.co.nri.ridual.r2.db.dao.ImageDAO;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import jp.co.nri.ridual.r2.properties.RidualServerConfigProperties;
import jp.co.nri.ridual.r2.resource.RidualResource;
import jp.co.nri.ridual.r2.robots.AbstractRidualRobo;

public class RefreshThumbnailRobo
extends AbstractRidualRobo {
    private final AnalyzeHistoryBean historyBean;
    private final Integer historyId;

    public RefreshThumbnailRobo(Integer historyId) throws Throwable {
        super("refreshThumbnail");
        this.historyBean = null;
        this.historyId = historyId;
    }

    public RefreshThumbnailRobo(AnalyzeHistoryBean historyBean) throws Throwable {
        super("refreshThumbnail");
        this.historyBean = historyBean;
        this.historyId = historyBean.getId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void play() {
        try {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            AnalyzeHistoryBean history;
                            if (this.isCancel.booleanValue()) {
                                return;
                            }
                            AnalyzeSiteConfigBean site = AnalyzeSiteConfigDAO.instance.findByHistoryId(this.historyId);
                            if (site == null) {
                                RidualServerLogDAO.getInstance().debug("\u4e0d\u6b63\u30a2\u30af\u30bb\u30b9?");
                                return;
                            }
                            Integer projectId = site.getProjectId();
                            AnalyzeHistoryBean analyzeHistoryBean = history = this.historyBean == null ? AnalyzeHistoryDAO.instance.updatethumbnailRefresh(this.historyId, super.getServerName()) : this.historyBean;
                            if (history == null) {
                                ProjectLogDAO.instance.recordIssueHistory(projectId, "robo.refreshThumbnail", "Robo.RefreshThumbnail.notReady", this.historyId, null, null);
                                return;
                            }
                            try {
                                try {
                                    if (this.isCancel.booleanValue()) {
                                        Object var10_5 = null;
                                        break block14;
                                    }
                                    File thumbDir = this.refreshThumbDir();
                                    if (this.isCancel.booleanValue()) {
                                        break block15;
                                    }
                                    ImageBean[] beans = ImageDAO.instance.findByHistoryId(site.getProjectId(), this.historyId);
                                    int len = beans.length;
                                    int i = 0;
                                    while (i < len) {
                                        if (this.isCancel.booleanValue()) {
                                            break block16;
                                        }
                                        ImageBean bean = beans[i];
                                        File thumbfile = new File(thumbDir, String.valueOf(bean.getId().toString()) + "." + bean.getExtension());
                                        this.writeFile(thumbfile, bean.getImage());
                                        ++i;
                                    }
                                    break block17;
                                }
                                catch (Throwable e) {
                                    ProjectLogDAO.instance.recordIssueProject(projectId, "robo.refreshThumbnail", "Robo.RefreshThumbnail", null, e);
                                    throw e;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var10_8 = null;
                                AnalyzeHistoryDAO.instance.updateThumbnailRefreshing(this.historyId);
                                throw throwable;
                            }
                        }
                        AnalyzeHistoryDAO.instance.updateThumbnailRefreshing(this.historyId);
                        return;
                    }
                    Object var10_6 = null;
                    AnalyzeHistoryDAO.instance.updateThumbnailRefreshing(this.historyId);
                    return;
                }
                Object var10_7 = null;
                AnalyzeHistoryDAO.instance.updateThumbnailRefreshing(this.historyId);
                return;
            }
            Object var10_9 = null;
            AnalyzeHistoryDAO.instance.updateThumbnailRefreshing(this.historyId);
            return;
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("Robo.RefreshThumbnailRobo", e);
        }
    }

    private File refreshThumbDir() throws IOException {
        String historyDirName = RidualResource.BUILDREPORT_PROPERTIES.getString("dir.name.history");
        String thumbDirName = RidualResource.BUILDREPORT_PROPERTIES.getString("dir.name.thumbnail");
        String staticDirStr = RidualServerConfigProperties.getInstance().getString("ridual.dir.static");
        File staticdir = new File(staticDirStr);
        File historydir = new File(new File(staticdir, historyDirName), this.historyId.toString());
        File thumbdir = new File(historydir, thumbDirName);
        if (thumbdir.exists()) {
            this.delete(thumbdir);
        }
        thumbdir.mkdirs();
        return thumbdir;
    }

    private void delete(File file) {
        File[] children = file.listFiles();
        if (children != null) {
            int i = children.length - 1;
            while (i >= 0) {
                if (this.isCancel.booleanValue()) {
                    return;
                }
                this.delete(children[i]);
                --i;
            }
        }
        file.delete();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeFile(File file, byte[] bytes) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        try {
            ((OutputStream)os).write(bytes);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
    }
}

