/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.robots.buildreportrobo;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import jp.co.nri.ridual.r2.common.pattern.Patterns;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeSiteConfigBean;
import jp.co.nri.ridual.r2.db.bean.project.ContentsAndVariationContainer;
import jp.co.nri.ridual.r2.db.dao.ContentsAndVariationDAO;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import jp.co.nri.ridual.r2.db.xsltview.TransformerMap;
import jp.co.nri.ridual.r2.map.MapCraft;
import jp.co.nri.ridual.r2.robots.AbstractRidualRobo;
import org.w3c.dom.Document;

class MapTransformRobo
extends AbstractRidualRobo {
    private static final String[] FILE_NAMES = new String[]{"rmap_s", "rmap_h", "rmap_c"};
    private static final int[] MAP_MODES;
    private static final int LEN;
    private static final String EXT_XML = ".xml";
    private static final String EXT_HTML = ".html";
    private final Integer projectId;
    private final AnalyzeHistoryBean historyBean;
    private final File htmldir;
    private final File xmldir;
    private final AnalyzeSiteConfigBean siteBean;
    private static final int MODE = 11;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        MAP_MODES = nArray;
        LEN = MAP_MODES.length;
    }

    public MapTransformRobo(Integer projectId, File htmldir, File xmldir, AnalyzeSiteConfigBean siteBean, AnalyzeHistoryBean historyBean) throws Throwable {
        super("transformMap");
        this.projectId = projectId;
        this.htmldir = htmldir;
        this.xmldir = xmldir;
        this.siteBean = siteBean;
        this.historyBean = historyBean;
    }

    protected void play() {
        try {
            Integer historyId = this.historyBean.getId();
            String[] fls = Patterns.CAMMA_PATTERN.split(this.siteBean.getStartURIs());
            if (fls.length > 0) {
                ContentsAndVariationContainer top = ContentsAndVariationDAO.instance.findByURL(this.projectId, historyId, fls[0]);
                ContentsAndVariationContainer[] pages = ContentsAndVariationDAO.instance.findByIsInner(this.projectId, historyId, true).toArray(new ContentsAndVariationContainer[0]);
                int i = LEN - 1;
                while (i >= 0) {
                    if (this.isCancel.booleanValue()) {
                        return;
                    }
                    System.gc();
                    MapCraft mc = new MapCraft(MAP_MODES[i]);
                    Document doc = mc.build(this.projectId, this.siteBean, this.historyBean, top, pages);
                    String name = FILE_NAMES[i];
                    if (this.isCancel.booleanValue()) {
                        return;
                    }
                    this.transformXML(doc, name);
                    if (this.isCancel.booleanValue()) {
                        return;
                    }
                    this.transformXSLT(doc, name);
                    --i;
                }
            }
        }
        catch (Throwable t) {
            RidualServerLogDAO.getInstance().record("Robo.MapTransformRobo", t);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void transformXML(Document doc, String name) {
        try {
            BufferedOutputStream ostream = new BufferedOutputStream(new FileOutputStream(new File(this.xmldir, String.valueOf(name) + EXT_XML)));
            try {
                TransformerMap.instance.transformXML(doc, ostream);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                ((OutputStream)ostream).close();
                throw throwable;
            }
            {
                Object var4_7 = null;
                ((OutputStream)ostream).close();
                return;
            }
        }
        catch (Throwable t) {
            RidualServerLogDAO.getInstance().record("Robo.MapTransformRobo", t);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void transformXSLT(Document doc, String name) {
        try {
            BufferedOutputStream ostream = new BufferedOutputStream(new FileOutputStream(new File(this.htmldir, String.valueOf(name) + EXT_HTML)));
            try {
                TransformerMap.instance.transformXSLT(0, 11, doc, ostream);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                ((OutputStream)ostream).close();
                throw throwable;
            }
            {
                Object var4_7 = null;
                ((OutputStream)ostream).close();
                return;
            }
        }
        catch (Throwable t) {
            RidualServerLogDAO.getInstance().record("Robo.MapTransformRobo", t);
        }
    }
}

