/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.robots.buildreportrobo;

import java.util.HashMap;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeSiteConfigBean;
import jp.co.nri.ridual.r2.db.dao.HistoryCache;
import jp.co.nri.ridual.r2.robots.buildreportrobo.BuildReportRobo;
import jp.co.nri.ridual.r2.robots.buildreportrobo.BuildReportRoboListener;
import jp.co.nri.ridual.r2.robots.refreshthumbnail.RefreshThumbnailRobo;

public class BuildReportRoboController
implements BuildReportRoboListener {
    public static final BuildReportRoboController instance = new BuildReportRoboController();
    private final HashMap map = new HashMap();

    private BuildReportRoboController() {
    }

    public synchronized void cancelBuildReport(Integer historyId) {
        BuildReportRobo robo = (BuildReportRobo)this.map.get(historyId);
        if (robo != null) {
            robo.cancel();
        }
    }

    public void onBuildFinished(Integer historyId) {
        this.removeMap(historyId);
    }

    public void startBuildReportRoboRebuild(AnalyzeSiteConfigBean siteBean, AnalyzeHistoryBean historyBean) throws Throwable {
        this.startBuildReportRobo(1, siteBean, historyBean);
    }

    public void startBuildReportRoboAfterAnalyze(HistoryCache hc) throws Throwable {
        this.startBuildReportRobo(0, hc.siteConfig, hc.history);
    }

    public void startBuildReportRoboRecheck(AnalyzeSiteConfigBean siteBean, AnalyzeHistoryBean historyBean) throws Throwable {
        this.startBuildReportRobo(2, siteBean, historyBean);
    }

    public void refreshThumbnail(Integer historyId) throws Throwable {
        new RefreshThumbnailRobo(historyId).start();
    }

    private synchronized void startBuildReportRobo(int mode, AnalyzeSiteConfigBean siteBean, AnalyzeHistoryBean historyBean) throws Throwable {
        BuildReportRobo buildRobo = new BuildReportRobo(mode, siteBean, historyBean, this);
        buildRobo.start();
        this.map.put(historyBean.getId(), buildRobo);
    }

    private synchronized void removeMap(Integer historyId) {
        this.map.remove(historyId);
    }
}

