/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.robots.buildreportrobo;

import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeSiteConfigBean;
import jp.co.nri.ridual.r2.db.dao.AnalyzeHistoryDAO;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import jp.co.nri.ridual.r2.properties.RidualServerConfigProperties;
import jp.co.nri.ridual.r2.resource.RidualResource;
import jp.co.nri.ridual.r2.robots.AbstractRidualRobo;
import jp.co.nri.ridual.r2.robots.buildreportrobo.AbstractBuildDocumentTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.AbstractMultiTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.BuildReportRoboListener;
import jp.co.nri.ridual.r2.robots.buildreportrobo.CSSTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.DataTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.DetailTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.FormActionTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.FormTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.LostTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.MapTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.MapTransformRobo;
import jp.co.nri.ridual.r2.robots.buildreportrobo.ObjectsTagDetailTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.ObjectsTagTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.ObjectsTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.OutlinkTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.OverviewTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.PagesListTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.QualityTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.RatingTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.ResourcesListTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.ScriptTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.SerialTransformRobo;
import jp.co.nri.ridual.r2.robots.buildreportrobo.TransformRobo;
import jp.co.nri.ridual.r2.robots.refreshthumbnail.RefreshThumbnailRobo;
import jp.co.nri.ridual.r2.robots.removehistorydirrobo.RemoveHistoryDirRobo;
import jp.co.nri.ridual.r2.robots.sendmailrobo.SendMailRobo;

class BuildReportRobo
extends AbstractRidualRobo {
    public static final String HISTORY_DIR_NAME = RidualResource.BUILDREPORT_PROPERTIES.getString("dir.name.history");
    public static final int MODE_AFTER_ANALYZE = 0;
    public static final int MODE_REBUILD = 1;
    public static final int MODE_RECHECK = 2;
    private static final String DETAIL_DIR_NAME = "detail";
    private static final String MAP_DIR_NAME = "map";
    private static final String CSV_DIR_NAME = "csv";
    private static final String XML_DIR_NAME = "xml";
    private static final String CSS_SRC_DIR_NAME = "css";
    private static final String IMG_SRC_DIR_NAME = "img";
    private static final String[] MAIL_SUBJECT = new String[]{RidualResource.BUILDREPORT_MESSAGES.getString("notify.mail.subject"), RidualResource.BUILDREPORT_MESSAGES.getString("notify.mail.rebuild.subject"), RidualResource.BUILDREPORT_MESSAGES.getString("notify.mail.recheck.subject")};
    private static final MessageFormat[] MAIL_BODY = new MessageFormat[]{new MessageFormat(RidualResource.BUILDREPORT_MESSAGES.getString("notify.mail.body")), new MessageFormat(RidualResource.BUILDREPORT_MESSAGES.getString("notify.mail.rebuild.body")), new MessageFormat(RidualResource.BUILDREPORT_MESSAGES.getString("notify.mail.recheck.body"))};
    private final int mode;
    private final Integer projectId;
    private final Integer historyId;
    private final String mailaddresses;
    private final AnalyzeHistoryBean historyBean;
    private final AnalyzeSiteConfigBean siteBean;
    private final BuildReportRoboListener adapter;
    private final boolean isNotifyMail;
    private final boolean isZip4Mail;
    private MapTransformRobo maprobo = null;
    private SerialTransformRobo serialTransformRobo = null;
    private AbstractRidualRobo[] robots = null;
    private RefreshThumbnailRobo refreshThumbnailRobo = null;
    private File zipfile = null;

    BuildReportRobo(int mode, AnalyzeSiteConfigBean siteBean, AnalyzeHistoryBean historyBean, BuildReportRoboListener adapter) throws Throwable {
        super("buildReport");
        this.mode = mode;
        this.historyBean = historyBean;
        this.siteBean = siteBean;
        this.projectId = siteBean.getProjectId();
        this.historyId = historyBean.getId();
        this.mailaddresses = siteBean.getMailAddresses();
        this.adapter = adapter;
        int flags = this.siteBean.getAnalyzeOptionFlags();
        this.isNotifyMail = (flags & 0x800) != 0;
        this.isZip4Mail = (flags & 0x1000) != 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void play() {
        try {
            try {
                RidualServerConfigProperties props = RidualServerConfigProperties.getInstance();
                String staticDirStr = props.getString("ridual.dir.static");
                File staticdir = new File(staticDirStr);
                File historydir = new File(new File(staticdir, HISTORY_DIR_NAME), this.historyId.toString());
                switch (this.mode) {
                    case 2: {
                        this.buildForRecheck(historydir);
                        break;
                    }
                    default: {
                        this.build(staticdir, historydir);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                ProjectLogDAO.instance.recordIssueHistory(this.projectId, "buildReport", "BuildReportRobo.buildReport", this.historyId, null, t);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.adapter.onBuildFinished(this.historyId);
            throw throwable;
        }
        {
            Object var5_8 = null;
            this.adapter.onBuildFinished(this.historyId);
            {
                this.sendMail();
                return;
            }
        }
    }

    private void sendMail() {
        MessageFormat body;
        if (!this.isNotifyMail || this.mailaddresses == null || this.mailaddresses.length() <= 0) {
            return;
        }
        SendMailRobo robo = new SendMailRobo();
        robo.historyId = this.historyId;
        robo.projectId = this.projectId;
        robo.to = this.mailaddresses;
        robo.subject = MAIL_SUBJECT[this.mode];
        MessageFormat messageFormat = body = MAIL_BODY[this.mode];
        synchronized (messageFormat) {
            robo.message = body.format(new String[]{this.siteBean.getStartURIs(), this.siteBean.getInnerSitePaths(), Integer.toString(this.siteBean.getDepthLimit()), Integer.toString(this.siteBean.getFileCountLimit()), Integer.toString(this.siteBean.getNestTableLimit()), DateFormat.getInstance().format(this.historyBean.getTimestampBegin())});
        }
        if (this.zipfile != null) {
            robo.attachment = new File[]{this.zipfile};
        }
        robo.start();
    }

    public void cancel() {
        Boolean bl = this.isCancel;
        synchronized (bl) {
            super.cancel();
            if (this.serialTransformRobo != null) {
                this.serialTransformRobo.cancel();
            }
            if (this.maprobo != null) {
                this.maprobo.cancel();
            }
            if (this.refreshThumbnailRobo != null) {
                this.refreshThumbnailRobo.cancel();
            }
            if (this.robots != null) {
                int i = this.robots.length - 1;
                while (i >= 0) {
                    this.robots[i].cancel();
                    --i;
                }
            }
        }
    }

    private void build(File staticdir, File historydir) throws Throwable {
        AbstractMultiTransformAdapter[] abstractMultiTransformAdapterArray;
        HistoryDirs dirs = new HistoryDirs(this.projectId, this.historyId, historydir);
        this.refreshThumbnailRobo = new RefreshThumbnailRobo(this.historyBean);
        this.refreshThumbnailRobo.start();
        AbstractBuildDocumentTransformAdapter[] adapters = new AbstractBuildDocumentTransformAdapter[]{new OverviewTransformAdapter(this.projectId, historydir, dirs.csvdir, dirs.xmldir, this.siteBean, this.historyBean), new PagesListTransformAdapter(this.projectId, historydir, dirs.csvdir, dirs.xmldir, this.siteBean, this.historyBean), new ResourcesListTransformAdapter(this.projectId, historydir, dirs.csvdir, dirs.xmldir, this.siteBean, this.historyBean), new FormTransformAdapter(this.projectId, historydir, dirs.csvdir, dirs.xmldir, this.siteBean, this.historyBean), new FormActionTransformAdapter(this.projectId, historydir, dirs.csvdir, dirs.xmldir, this.siteBean, this.historyBean), new OutlinkTransformAdapter(this.projectId, historydir, dirs.csvdir, dirs.xmldir, this.siteBean, this.historyBean), new CSSTransformAdapter(this.projectId, historydir, dirs.csvdir, dirs.xmldir, this.siteBean, this.historyBean), new ScriptTransformAdapter(this.projectId, historydir, dirs.csvdir, dirs.xmldir, this.siteBean, this.historyBean), new LostTransformAdapter(this.projectId, historydir, dirs.csvdir, dirs.xmldir, this.siteBean, this.historyBean), new QualityTransformAdapter(this.projectId, historydir, dirs.csvdir, dirs.xmldir, this.siteBean, this.historyBean), new MapTransformAdapter(this.projectId, historydir, dirs.csvdir, dirs.xmldir, this.siteBean, this.historyBean), new DataTransformAdapter(this.projectId, historydir, dirs.csvdir, dirs.xmldir, this.siteBean, this.historyBean), new ObjectsTransformAdapter(this.projectId, historydir, dirs.csvdir, dirs.xmldir, this.siteBean, this.historyBean), new ObjectsTagTransformAdapter(this.projectId, historydir, dirs.csvdir, dirs.xmldir, this.siteBean, this.historyBean), new ObjectsTagDetailTransformAdapter(this.projectId, historydir, dirs.csvdir, dirs.xmldir, this.siteBean, this.historyBean), new RatingTransformAdapter(this.projectId, historydir, dirs.csvdir, dirs.xmldir, this.siteBean, this.historyBean)};
        if (this.siteBean.isOutputDetail(this.historyId)) {
            AbstractMultiTransformAdapter[] abstractMultiTransformAdapterArray2 = new AbstractMultiTransformAdapter[1];
            abstractMultiTransformAdapterArray = abstractMultiTransformAdapterArray2;
            abstractMultiTransformAdapterArray2[0] = new DetailTransformAdapter(this.projectId, dirs.detaildir, null, dirs.detailxmldir, null, null, null, this.siteBean, this.historyBean);
        } else {
            abstractMultiTransformAdapterArray = new AbstractMultiTransformAdapter[]{};
        }
        AbstractMultiTransformAdapter[] madapters = abstractMultiTransformAdapterArray;
        this.refreshThumbnailRobo.join();
        Boolean bl = this.isCancel;
        synchronized (bl) {
            if (this.isCancel.booleanValue()) {
                return;
            }
            this.serialTransformRobo = new SerialTransformRobo(this.projectId, this.historyId, historydir, new File[]{new File(staticdir, CSS_SRC_DIR_NAME), new File(staticdir, IMG_SRC_DIR_NAME)}, adapters, madapters);
            this.serialTransformRobo.start();
        }
        if (this.isZip4Mail) {
            this.zipfile = this.serialTransformRobo.zipfile;
        }
        this.serialTransformRobo.join();
        System.gc();
        bl = this.isCancel;
        synchronized (bl) {
            if (this.isCancel.booleanValue()) {
                return;
            }
            this.maprobo = new MapTransformRobo(this.projectId, dirs.mapdir, historydir, this.siteBean, this.historyBean);
            this.maprobo.start();
        }
        this.maprobo.join();
        System.gc();
        AnalyzeHistoryDAO.instance.updateReady(this.historyId);
    }

    private void buildForRecheck(File historydir) throws Throwable {
        File csvdir = new File(historydir, CSV_DIR_NAME);
        File xmldir = new File(historydir, XML_DIR_NAME);
        historydir.mkdirs();
        csvdir.mkdirs();
        xmldir.mkdirs();
        OutlinkTransformAdapter oladapter = new OutlinkTransformAdapter(this.projectId, historydir, csvdir, xmldir, this.siteBean, this.historyBean);
        Boolean bl = this.isCancel;
        synchronized (bl) {
            if (!this.isCancel.booleanValue()) {
                TransformRobo robo = new TransformRobo(oladapter);
                this.robots = new TransformRobo[]{robo};
                robo.start();
                robo.join();
            }
        }
        AnalyzeHistoryDAO.instance.updateRechecking(this.historyId);
    }

    private class HistoryDirs {
        public final File csvdir;
        public final File xmldir;
        public final File detaildir;
        public final File detailxmldir;
        public final File mapdir;

        public HistoryDirs(Integer projectId, Integer historyId, File historydir) throws Throwable {
            if (historydir.exists()) {
                RemoveHistoryDirRobo removeRobo = new RemoveHistoryDirRobo(projectId, historyId);
                removeRobo.start();
                removeRobo.join();
            }
            this.csvdir = new File(historydir, BuildReportRobo.CSV_DIR_NAME);
            this.xmldir = new File(historydir, BuildReportRobo.XML_DIR_NAME);
            this.detaildir = new File(historydir, BuildReportRobo.DETAIL_DIR_NAME);
            this.detailxmldir = new File(this.detaildir, BuildReportRobo.XML_DIR_NAME);
            this.mapdir = new File(historydir, BuildReportRobo.MAP_DIR_NAME);
            this.csvdir.mkdirs();
            this.xmldir.mkdirs();
            this.detaildir.mkdirs();
            this.detailxmldir.mkdirs();
            this.mapdir.mkdirs();
        }
    }
}

