/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.robots.buildreportrobo;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.TransformerException;
import jp.co.nri.ridual.r2.db.bean.project.ImageBean;
import jp.co.nri.ridual.r2.db.dao.ImageDAO;
import jp.co.nri.ridual.r2.db.xsltview.TransformerMap;
import jp.co.nri.ridual.r2.resource.RidualResource;
import jp.co.nri.ridual.r2.robots.AbstractRidualRobo;
import org.w3c.dom.Document;

abstract class AbstractZipTransformRobo
extends AbstractRidualRobo {
    private static final String ZIP_FILE_NAME = RidualResource.BUILDREPORT_PROPERTIES.getString("file.name.zip");
    private static final char ENTRY_SEPARATOR = '/';
    private static final String THUMBNAIL_ENTRY_PATH = String.valueOf(RidualResource.BUILDREPORT_PROPERTIES.getString("dir.name.thumbnail")) + '/';
    public final File zipfile;
    private final Integer projectId;
    private final Integer historyId;
    private final File[] copydirs;
    private final byte[] buf = new byte[4096];

    public AbstractZipTransformRobo(Integer projectId, Integer historyId, String robotype, File zipdir, File[] copydirs) throws Throwable {
        super(robotype);
        this.projectId = projectId;
        this.historyId = historyId;
        this.copydirs = copydirs;
        this.zipfile = zipdir == null ? null : new File(zipdir, ZIP_FILE_NAME);
    }

    protected ZipOutputStream openZipFile() throws FileNotFoundException {
        return this.zipfile == null ? null : new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.zipfile)));
    }

    protected void copyDirs(ZipOutputStream zos) throws IOException {
        if (zos == null) {
            return;
        }
        int i = this.copydirs.length - 1;
        while (i >= 0) {
            File dir = this.copydirs[i];
            this.entryLocalFiles(dir.getName(), zos, dir);
            --i;
        }
    }

    protected void entryFiles(ZipOutputStream zos, Document doc, String xml, int mode, String html, String csv) throws IOException, TransformerException {
        if (zos == null) {
            return;
        }
        this.entryXML(zos, xml, doc);
        this.entryXSLT(zos, 1, mode, html, doc);
        this.entryXSLT(zos, 2, mode, csv, doc);
    }

    protected void entryImages(ZipOutputStream zos) throws Throwable {
        if (zos == null) {
            return;
        }
        ImageBean[] images = ImageDAO.instance.findByHistoryId(this.projectId, this.historyId);
        if (images == null) {
            return;
        }
        int i = images.length - 1;
        while (i >= 0) {
            if (this.isCancel.booleanValue()) {
                return;
            }
            ImageBean image = images[i];
            StringBuffer sb = new StringBuffer(THUMBNAIL_ENTRY_PATH);
            sb.append(image.getId().toString());
            sb.append(".");
            sb.append(image.getExtension());
            zos.putNextEntry(new ZipEntry(sb.toString()));
            zos.write(image.getImage());
            zos.flush();
            zos.closeEntry();
            --i;
        }
    }

    private void entryXSLT(ZipOutputStream zos, int type, int mode, String entry, Document doc) throws IOException, TransformerException {
        if (entry == null) {
            return;
        }
        zos.putNextEntry(new ZipEntry(entry));
        TransformerMap.instance.transformXSLT(type, mode, doc, zos);
        zos.flush();
        zos.closeEntry();
    }

    protected void entrySimpleXSLT(ZipOutputStream zos, int mode, String entry, Document doc) throws IOException, TransformerException {
        if (zos == null || entry == null) {
            return;
        }
        zos.putNextEntry(new ZipEntry(entry));
        TransformerMap.instance.transformXSLTSP(mode, doc, zos);
        zos.flush();
        zos.closeEntry();
    }

    private void entryXML(ZipOutputStream zos, String entry, Document doc) throws IOException, TransformerException {
        if (entry == null) {
            return;
        }
        zos.putNextEntry(new ZipEntry(entry));
        TransformerMap.instance.transformXML(doc, zos);
        zos.flush();
        zos.closeEntry();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void entryLocalFiles(String name, ZipOutputStream zos, File dir) throws IOException {
        File[] children = dir.listFiles();
        int i = children.length - 1;
        while (i >= 0) {
            File child = children[i];
            String childname = String.valueOf(name) + '/' + child.getName();
            if (child.isFile()) {
                Object var10_10;
                zos.putNextEntry(new ZipEntry(childname));
                FileInputStream in = new FileInputStream(child);
                try {
                    int len;
                    while ((len = ((InputStream)in).read(this.buf)) > 0) {
                        zos.write(this.buf, 0, len);
                    }
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    ((InputStream)in).close();
                    throw throwable;
                }
                {
                    var10_10 = null;
                }
                ((InputStream)in).close();
                zos.flush();
                zos.closeEntry();
            } else if (child.isDirectory()) {
                this.entryLocalFiles(childname, zos, child);
            }
            --i;
        }
        return;
    }
}

