/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.restrict;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import jp.co.nri.ridual.r2.hog.RHog;
import jp.co.nri.ridual.r2.properties.RidualServerAdminConfigProperties;
import jp.co.nri.ridual.r2.resource.RidualResource;
import jp.co.nri.ridual.r2.restrict.RestrictItem;

public class RestrictChecker {
    private static final int INIT = 0;
    private static final int MOD = 1;
    public static final int MODE_DEMO = 0;
    public static final int MODE_INVALID = 1;
    public static final int MODE_VALID = 2;
    public static final int MODE_EXPIRED = 3;
    private static final String DEMO_VERSION = RidualResource.RESTRICT_PROPERTIES.getString("restrict.demoversion");
    private static final String VALID = RidualResource.RESTRICT_PROPERTIES.getString("restrict.valid");
    private static final String INVALID = RidualResource.RESTRICT_PROPERTIES.getString("restrict.invalid");
    private static final String EXPIRED = RidualResource.RESTRICT_PROPERTIES.getString("restrict.expired");
    private static final String RESTRICTFILE = "rlm";
    private static final String DATE_FORMAT = "yyyy/MM/dd";
    private RHog decode = new RHog();
    private static final Integer depth_limit = new Integer(3);
    private static final Integer files_limit = new Integer(500);
    private static final Integer robos_limit = new Integer(4);
    public static final RestrictChecker instanse = new RestrictChecker();
    private Integer depth = depth_limit;
    private Integer files = files_limit;
    private Integer robos = robos_limit;
    private String expire = null;
    private String message = null;
    private int mode = 0;

    private RestrictChecker() {
    }

    public RestrictItem getRestrictItem() {
        return new RestrictItem(this.depth, this.files, this.robos, this.expire, this.message, this.mode);
    }

    private void setRestrict(int mode) {
        switch (mode) {
            case 0: {
                this.depth = depth_limit;
                this.files = files_limit;
                this.robos = robos_limit;
                break;
            }
            case 1: {
                this.depth = this.decode.depth;
                this.files = this.decode.file;
                this.robos = this.decode.robo;
                SimpleDateFormat dfm = new SimpleDateFormat(DATE_FORMAT);
                this.expire = this.decode.TimeLimit == null ? null : dfm.format(this.decode.TimeLimit);
                this.message = VALID;
                this.mode = 2;
            }
        }
    }

    private boolean checkRestrict() throws Throwable {
        if (this.decode.mail == null || this.decode.name == null) {
            this.message = INVALID;
            this.mode = 1;
            return false;
        }
        RidualServerAdminConfigProperties props = RidualServerAdminConfigProperties.getInstance();
        String name = props.getString("admin.name");
        String mail = props.getString("admin.mail");
        if (!this.decode.mail.equals(mail) || !this.decode.name.equals(name)) {
            this.message = INVALID;
            this.mode = 1;
            return false;
        }
        Date today = new Date();
        SimpleDateFormat dfm = new SimpleDateFormat(DATE_FORMAT);
        today = dfm.parse(dfm.format(today));
        if (this.decode.TimeLimit != null && today.after(this.decode.TimeLimit)) {
            this.message = EXPIRED;
            this.mode = 3;
            return false;
        }
        return true;
    }

    public synchronized RestrictItem loadRestrict(String path) {
        try {
            this.setRestrict(0);
            File fp = new File(path, RESTRICTFILE);
            if (!fp.exists()) {
                this.message = DEMO_VERSION;
                this.mode = 0;
                return this.getRestrictItem();
            }
            if (!this.decode.load(fp)) {
                this.message = INVALID;
                this.mode = 1;
                return this.getRestrictItem();
            }
            if (!this.checkRestrict()) {
                return this.getRestrictItem();
            }
            this.setRestrict(1);
        }
        catch (Throwable t) {
            RidualServerLogDAO.getInstance().record("Restrict.RestrictChecker", t);
        }
        return this.getRestrictItem();
    }

    public synchronized RestrictItem recheckRestrict() {
        if (this.mode == 0) {
            return this.getRestrictItem();
        }
        try {
            if (!this.checkRestrict()) {
                this.setRestrict(0);
            }
        }
        catch (Throwable t) {
            RidualServerLogDAO.getInstance().record("Restrict.RestrictChecker", t);
        }
        return this.getRestrictItem();
    }
}

