/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.rating;

import java.math.BigDecimal;
import java.util.Date;

public class RatingResult {
    public final int pages4calc;
    public final int pages4display;
    public final int weight;
    public final double rate;
    public final Date date;
    public final String type;
    public final String text;
    public final int val;
    public final double count;
    public final int all;
    public final String mode;
    public final long time;
    public final int method;

    public RatingResult(int method, int weight, int pages, int totalpages) {
        this.method = method;
        this.weight = weight;
        this.pages4display = pages;
        switch (method) {
            case 1: {
                this.pages4calc = pages;
                break;
            }
            case 2: {
                this.pages4calc = totalpages - pages;
                break;
            }
            default: {
                this.pages4calc = 0;
            }
        }
        double wrate = totalpages == 0 ? 0.0 : (double)this.pages4calc / (double)totalpages * 100.0;
        this.rate = new BigDecimal(wrate).setScale(1, 4).doubleValue();
        this.type = null;
        this.mode = null;
        this.date = null;
        this.text = null;
        this.val = 0;
        this.count = 0.0;
        this.all = 0;
        this.time = 0L;
    }

    public RatingResult(String type, String mode, Date date) {
        this.type = type;
        this.mode = mode;
        this.date = date;
        this.method = 0;
        this.weight = 0;
        this.pages4display = 0;
        this.pages4calc = 0;
        this.rate = 0.0;
        this.text = null;
        this.val = 0;
        this.count = 0.0;
        this.all = 0;
        this.time = 0L;
    }

    public RatingResult(Date date) {
        this("date", "analyzeinfo", date);
    }

    public RatingResult(long time) {
        this.type = "time";
        this.mode = "analyzeinfo";
        this.time = time;
        this.date = null;
        this.method = 0;
        this.weight = 0;
        this.pages4display = 0;
        this.pages4calc = 0;
        this.rate = 0.0;
        this.text = null;
        this.val = 0;
        this.count = 0.0;
        this.all = 0;
    }

    public RatingResult(String text) {
        this("text", "analyzeinfo", text);
    }

    public RatingResult(String type, String mode, String text) {
        this.type = type;
        this.mode = mode;
        this.text = text;
        this.date = null;
        this.time = 0L;
        this.method = 0;
        this.weight = 0;
        this.pages4display = 0;
        this.pages4calc = 0;
        this.rate = 0.0;
        this.val = 0;
        this.count = 0.0;
        this.all = 0;
    }

    public RatingResult(String mode, double count, int all) {
        this.type = "ratio";
        this.mode = mode;
        this.count = count;
        this.all = all;
        this.date = null;
        this.time = 0L;
        this.text = null;
        this.method = 0;
        this.weight = 0;
        this.pages4display = 0;
        this.pages4calc = 0;
        this.rate = 0.0;
        this.val = 0;
    }

    public RatingResult(String type, String mode, int val) {
        this.type = type;
        this.mode = mode;
        this.val = val;
        this.date = null;
        this.time = 0L;
        this.text = null;
        this.method = 0;
        this.weight = 0;
        this.pages4display = 0;
        this.pages4calc = 0;
        this.rate = 0.0;
        this.count = 0.0;
        this.all = 0;
    }
}

