/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.rating;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeSiteConfigBean;
import jp.co.nri.ridual.r2.db.bean.common.RatingProfileBean;
import jp.co.nri.ridual.r2.db.bean.common.RatingProfileItemBean;
import jp.co.nri.ridual.r2.db.bean.project.HtmlNodeBean;
import jp.co.nri.ridual.r2.db.dao.ContentsAndVariationDAO;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import jp.co.nri.ridual.r2.db.dao.RatingProfileDAO;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import jp.co.nri.ridual.r2.rating.AbstractRatingItem;
import jp.co.nri.ridual.r2.rating.AbstractRatingPlugin;
import jp.co.nri.ridual.r2.rating.CategoryItem;
import jp.co.nri.ridual.r2.rating.GlobalCategoryItem;
import jp.co.nri.ridual.r2.rating.RatingCommonAPI;
import jp.co.nri.ridual.r2.rating.RatingInfo;
import jp.co.nri.ridual.r2.rating.RatingResult;
import jp.co.nri.ridual.r2.rating.RatingScoreCustomizer;
import jp.co.nri.ridual.r2.resource.RidualResource;

public class Rating {
    private static final String SITE_CONDITION_DEPTH = "Depth-limit:";
    private static final String SITE_CONDITION_FILE = "File-count-limit:";
    private static final String CUSTOMIZER_NAME = RidualResource.RATING_PROPERTIES.getString("RatingScoreCustomizer");
    private final AnalyzeHistoryBean historyBean;
    private final AnalyzeSiteConfigBean siteBean;
    private final Integer profileId;
    private final Integer projectId;
    private final Integer historyId;
    private final RatingScoreCustomizer customizer;
    private int checkcount;
    private int allweigth;
    private int allpages;
    private int totalpages;

    public Rating(Integer projectId, AnalyzeSiteConfigBean siteBean, AnalyzeHistoryBean historyBean) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.historyBean = historyBean;
        this.siteBean = siteBean;
        this.projectId = projectId;
        this.historyId = historyBean.getId();
        this.profileId = siteBean.getRatingProfile();
        this.checkcount = 0;
        this.allpages = 0;
        this.allweigth = 0;
        this.totalpages = 0;
        this.customizer = (RatingScoreCustomizer)Class.forName(CUSTOMIZER_NAME).newInstance();
    }

    public List doRating() throws Throwable {
        this.totalpages = ContentsAndVariationDAO.instance.countInnerPagesByHistoryId(this.projectId, this.historyId);
        HashMap result = this.doRatingCheck();
        HashMap gresult = this.doRatingGlobal();
        ArrayList<AbstractRatingItem> list = new ArrayList<AbstractRatingItem>();
        GlobalCategoryItem gbeanarray = new GlobalCategoryItem(gresult, RatingInfo.instance.globalcategory);
        list.add(gbeanarray);
        int categorysize = RatingInfo.instance.category == null ? 0 : RatingInfo.instance.category.length;
        int i = 0;
        while (i < categorysize) {
            CategoryItem gbean = new CategoryItem(result, RatingInfo.instance.category[i]);
            list.add(gbean);
            ++i;
        }
        return list;
    }

    private HashMap doRatingCheck() throws Throwable {
        if (RatingInfo.instance.category == null) {
            return null;
        }
        HashMap<String, RatingResult> result = new HashMap<String, RatingResult>();
        RatingCommonAPI api = new RatingCommonAPI(this.projectId, this.historyId);
        if (this.profileId == null) {
            return result;
        }
        RatingProfileItemBean[] beans = RatingProfileDAO.instance.findExecution(this.profileId).toArray(new RatingProfileItemBean[0]);
        this.checkcount = 0;
        int len = beans.length;
        int i = 0;
        while (i < len) {
            RatingProfileItemBean bean = beans[i];
            String classname = bean.getClazz();
            int weigth = bean.getWeight();
            try {
                result.put(classname, this.checking(classname, weigth, api));
                ++this.checkcount;
            }
            catch (ClassNotFoundException e) {
                ProjectLogDAO.instance.recordIssueHistory(this.projectId, "buildReport", "BuildReportRobo.buildReport.plugin.ClassNotFound", this.historyId, new Object[]{classname}, e);
                RidualServerLogDAO.getInstance().record("DB.Rating", "Rating.Error.Plugin.ClassNotFound", new Object[]{this.historyId, classname}, e);
            }
            catch (Throwable t) {
                ProjectLogDAO.instance.recordIssueHistory(this.projectId, "buildReport", "BuildReportRobo.buildReport", this.historyId, null, t);
                RidualServerLogDAO.getInstance().record("DB.Rating", "Rating.Error.Plugin", new Object[]{this.historyId, classname}, t);
            }
            ++i;
        }
        return result;
    }

    private RatingResult checking(String classname, int weigth, RatingCommonAPI api) throws Throwable {
        AbstractRatingPlugin rating = (AbstractRatingPlugin)Class.forName(classname).newInstance();
        int pages = rating.rating(api);
        RatingResult rr = new RatingResult(rating.getMethod(), weigth, pages, this.totalpages);
        if (weigth != 0) {
            this.allpages += rr.pages4calc * weigth;
            this.allweigth += weigth;
        }
        return rr;
    }

    private HashMap doRatingGlobal() throws Throwable {
        HashMap gresult = new HashMap();
        this.RatingScore(gresult);
        this.RatingResult(gresult);
        this.RatingAnalyzeCheckNum(gresult);
        this.RatingAnalyzeDay(gresult);
        this.RatingAnalyzeTime(gresult);
        this.RatingAnalyzeCondition(gresult);
        this.RatingAnalyzeProfileName(gresult);
        this.RatingAnalyzeErr(gresult);
        this.RatingSitePages(gresult);
        this.RatingSiteResources(gresult);
        this.RatingCharcode(gresult);
        this.ratingTables(gresult);
        this.RatingNewUpdate(gresult);
        this.ratingFrame(gresult);
        this.RatingLostPages(gresult);
        this.RatingLostResources(gresult);
        this.ratingCSS(gresult);
        this.ratingJavascript(gresult);
        this.RatingOutlinkCount(gresult);
        this.ratingObjectCount(gresult);
        this.ratingFormCount(gresult);
        this.RatingMailtoCount(gresult);
        this.RatingAnalyzeLinkCount(gresult);
        return gresult;
    }

    private void RatingAnalyzeDay(HashMap map) throws Throwable {
        map.put("result.analyzeday", new RatingResult(this.historyBean.getTimestampBegin()));
    }

    private void RatingAnalyzeTime(HashMap map) throws Throwable {
        long time = 0L;
        if (this.historyBean.getTimestampComplete() != null && this.historyBean.getTimestampBegin() != null) {
            time = this.historyBean.getTimestampComplete().getTime() - this.historyBean.getTimestampBegin().getTime();
        }
        map.put("result.analyzetime", new RatingResult(time));
    }

    private void RatingAnalyzeCondition(HashMap map) throws Throwable {
        String condition = SITE_CONDITION_DEPTH + Integer.toString(this.siteBean.getDepthLimit()) + " " + SITE_CONDITION_FILE + Integer.toString(this.siteBean.getFileCountLimit());
        map.put("result.condition", new RatingResult(condition));
    }

    private void RatingAnalyzeProfileName(HashMap map) throws Throwable {
        String profilename = "";
        if (this.profileId != null) {
            RatingProfileBean bean = RatingProfileDAO.instance.findAliveById(this.profileId);
            profilename = bean != null ? bean.getName() : profilename;
        }
        map.put("result.profilename", new RatingResult(profilename));
    }

    private void RatingAnalyzeCheckNum(HashMap map) throws Throwable {
        map.put("result.ratingnum", new RatingResult("analyzeinfo", this.checkcount, RatingInfo.instance.getAllRatingCount()));
    }

    private void RatingAnalyzeErr(HashMap map) throws Throwable {
        int errors = ProjectLogDAO.instance.countByHistoryId(this.projectId, this.historyId);
        String key = errors > 0 ? "rating.analyzeerr.on" : "rating.analyzeerr.off";
        String text = RidualResource.RATING_GLOBAL_PROPERTIES.getString(key);
        map.put("result.ratingerr", new RatingResult(text));
    }

    private void RatingScore(HashMap map) throws Throwable {
        double count = this.checkcount == 0 || this.allweigth == 0 || this.totalpages == 0 ? 0.0 : (double)this.allpages / (double)(this.totalpages * this.allweigth) * 100.0;
        count = this.customizer.customize(count);
        count = new BigDecimal(count).setScale(1, 4).doubleValue();
        map.put("result.score", new RatingResult("score", count, 100));
    }

    private void RatingResult(HashMap map) throws Throwable {
        map.put("result.result", new RatingResult(RidualResource.RATING_GLOBAL_PROPERTIES.getString("rating.resultword")));
    }

    private void RatingSitePages(HashMap map) throws Throwable {
        map.put("site.pages", new RatingResult("int", "siteinfo1", this.totalpages));
    }

    private void RatingSiteResources(HashMap map) throws Throwable {
        int resources = ContentsAndVariationDAO.instance.countInnerResources(this.projectId, this.historyId);
        map.put("site.resources", new RatingResult("int", "siteinfo1", resources));
    }

    private void RatingCharcode(HashMap map) throws Throwable {
        String charcode = ContentsAndVariationDAO.instance.findMAXCharcodeByIsInner(this.projectId, this.historyId, true);
        map.put("site.charcode", new RatingResult("code", "siteinfo1", charcode));
    }

    private void ratingFrame(HashMap map) throws Throwable {
        int count = ContentsAndVariationDAO.instance.countNode(this.projectId, this.historyId, HtmlNodeBean.TYPE_ELEMENT_INTEGER, "frameset");
        String key = count > 0 ? "rating.frame.on" : "rating.frame.off";
        String text = RidualResource.RATING_GLOBAL_PROPERTIES.getString(key);
        map.put("site.isframe", new RatingResult("text", "siteinfo2", text));
    }

    private void ratingCSS(HashMap map) throws Throwable {
        int count = ContentsAndVariationDAO.instance.countInnerByType(this.projectId, this.historyId, 1057);
        map.put("site.outcss", new RatingResult("int", "siteinfo2", count));
    }

    private void ratingJavascript(HashMap map) throws Throwable {
        int count = ContentsAndVariationDAO.instance.countInnerByType(this.projectId, this.historyId, 1041);
        map.put("site.outjavascript", new RatingResult("int", "siteinfo2", count));
    }

    private void RatingLostPages(HashMap map) throws Throwable {
        int pages = ContentsAndVariationDAO.instance.countLostPages(this.projectId, this.historyId);
        map.put("site.lostpages", new RatingResult("int", "siteinfo2", pages));
    }

    private void RatingLostResources(HashMap map) throws Throwable {
        int resources = ContentsAndVariationDAO.instance.countLostResource(this.projectId, this.historyId);
        map.put("site.lostresources", new RatingResult("int", "siteinfo2", resources));
    }

    private void ratingTables(HashMap map) throws Throwable {
        int count = ContentsAndVariationDAO.instance.maxTableDepth(this.projectId, this.historyId);
        map.put("site.tablesmax", new RatingResult("int", "siteinfo1", count));
    }

    private void RatingNewUpdate(HashMap map) throws Throwable {
        Date date = ContentsAndVariationDAO.instance.findInnerLastModified(this.projectId, this.historyId);
        map.put("site.newupdate", new RatingResult("date", "siteinfo1", date));
    }

    private void RatingOutlinkCount(HashMap map) throws Throwable {
        int val = ContentsAndVariationDAO.instance.countOutLink(this.projectId, this.historyId);
        map.put("site.outlink", new RatingResult("int", "siteinfo3", val));
    }

    private void ratingObjectCount(HashMap map) throws Throwable {
        int count = ContentsAndVariationDAO.instance.countNode(this.projectId, this.historyId, HtmlNodeBean.TYPE_ELEMENT_INTEGER, "object");
        map.put("site.object", new RatingResult("int", "siteinfo3", count));
    }

    private void ratingFormCount(HashMap map) throws Throwable {
        int count = ContentsAndVariationDAO.instance.countNode(this.projectId, this.historyId, HtmlNodeBean.TYPE_ELEMENT_INTEGER, "form");
        map.put("site.form", new RatingResult("int", "siteinfo3", count));
    }

    private void RatingMailtoCount(HashMap map) throws Throwable {
        int val = ContentsAndVariationDAO.instance.countContactByValue(this.projectId, this.historyId, "mailto:%");
        map.put("site.mailto", new RatingResult("int", "siteinfo3", val));
    }

    private void RatingAnalyzeLinkCount(HashMap map) throws Throwable {
        int countRelations = ContentsAndVariationDAO.instance.countRelationByHistoryId(this.projectId, this.historyId);
        map.put("site.analyzelink", new RatingResult("int", "siteinfo3", countRelations));
    }
}

