/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.map;

import java.net.URL;
import java.util.Vector;
import jp.co.nri.ridual.r2.db.bean.AbstractNodable;
import jp.co.nri.ridual.r2.db.bean.project.AbstractProjectNodable;
import jp.co.nri.ridual.r2.db.bean.project.ContentsAndVariationContainer;
import jp.co.nri.ridual.r2.db.bean.project.ContentsSupplementBean;
import jp.co.nri.ridual.r2.db.dao.ContentsSupplementDAO;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class MapContents
extends AbstractProjectNodable {
    private static final String ELEMENT_NAME_ROOT = "unit";
    private static final String ATTRIBUTE_NAME_ID = "id";
    private static final String ATTRIBUTE_NAME_NAME = "name";
    private static final String ATTRIBUTE_NAME_PATH = "path";
    private static final String ATTRIBUTE_NAME_STATUS = "status";
    private static final String ATTRIBUTE_NAME_TITLE = "title";
    private static final String ATTRIBUTE_NAME_SIZE = "size";
    private static final String ATTRIBUTE_NAME_DATE = "date";
    private static final String ATTRIBUTE_NAME_CHARSET = "charset";
    private static final String ATTRIBUTE_NAME_THUMBNAIL_ID = "thumbnail";
    private static final String ATTRIBUTE_NAME_TYPE = "utype";
    private final ContentsAndVariationContainer page;
    private final Vector child = new Vector();
    private MapContents parent;
    private int depth;

    public MapContents(ContentsAndVariationContainer page, MapContents parent) {
        this.page = page;
        this.setParent(parent);
    }

    public void addChild(MapContents element) {
        this.child.add(element);
    }

    public MapContents[] childrenToArray() {
        return this.child.toArray(new MapContents[0]);
    }

    public void setParent(MapContents parent) {
        this.parent = parent;
        this.depth = parent == null ? 0 : parent.getDepth() + 1;
    }

    public MapContents getParent() {
        return this.parent;
    }

    public int getDepth() {
        return this.depth;
    }

    public ContentsAndVariationContainer getPage() {
        return this.page;
    }

    public Node buildNode(Integer projectId, int mode, Document doc) {
        Integer variationId = this.page.variation.getId();
        Element elm = doc.createElement(ELEMENT_NAME_ROOT);
        try {
            super.buildAttribute(elm, ATTRIBUTE_NAME_ID, variationId);
            super.buildAttribute(elm, ATTRIBUTE_NAME_SIZE, this.page.variation.getSize());
            super.buildDateAttribute(elm, ATTRIBUTE_NAME_DATE, this.page.variation.getLastModified());
            super.buildTextAttribute(elm, ATTRIBUTE_NAME_CHARSET, this.page.variation.getRidualEncoding());
            super.buildAttribute(elm, ATTRIBUTE_NAME_THUMBNAIL_ID, this.page.variation.getThumbnailId());
            super.buildIntAttribute(elm, ATTRIBUTE_NAME_STATUS, this.page.variation.getHttpStatus());
            int type = this.page.variation.getType();
            if (type >= 0) {
                super.buildHexAttribute(elm, ATTRIBUTE_NAME_TYPE, type);
            }
            URL url = this.page.contents.buildURL(this.page.variation);
            super.buildTextAttribute(elm, ATTRIBUTE_NAME_PATH, url.toString());
            super.buildTextAttribute(elm, ATTRIBUTE_NAME_NAME, url == null ? this.page.contents.getPath() : url.getFile());
            ContentsSupplementBean supplement = ContentsSupplementDAO.instance.findUniqueByName(projectId, variationId, "HTML.title");
            if (supplement != null) {
                super.buildTextAttribute(elm, ATTRIBUTE_NAME_TITLE, supplement.getValue());
            }
        }
        catch (Throwable e) {
            ProjectLogDAO.instance.recordIssueHistory(projectId, "buildMap", "BuildMap.buildNode", this.page.contents.getHistoryId(), new Object[]{variationId}, e);
        }
        return elm;
    }

    public AbstractNodable[] loadChild(Integer projectId, int mode) throws Throwable {
        return this.childrenToArray();
    }
}

