/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.dao;

import java.io.IOException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.co.nri.ridual.r2.common.pattern.Patterns;
import jp.co.nri.ridual.r2.db.dao.AbstractIdTableNameCraft;
import jp.co.nri.ridual.r2.db.dao.DBConfigException;
import jp.co.nri.ridual.r2.db.dao.ExportSchema;
import jp.co.nri.ridual.r2.db.dao.HibernateEntityResolver;
import jp.co.nri.ridual.r2.db.dao.HistoryIdTableNameCraft;
import jp.co.nri.ridual.r2.db.dao.ProjectIdTableNameCraft;
import jp.co.nri.ridual.r2.properties.RidualServerConfigProperties;
import jp.co.nri.ridual.r2.resource.RidualResource;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.xml.sax.EntityResolver;

public class SessionFactoryController {
    public static final int ISOLATION_READ_UNCOMMITTED = 0;
    public static final int ISOLATION_SERIALIZABLE = 1;
    public static final int ISOLATION_LEN = 2;
    private static final String HIBERNATE_CFG_KEY_JDBC_DRIVER = "hibernate.connection.driver_class";
    private static final String HIBERNATE_CFG_KEY_DIALECT = "hibernate.dialect";
    private static final String HIBERNATE_CFG_KEY_URL = "hibernate.connection.url";
    private final String[] HIBERNATE_CFG_XML_COMMON = new String[]{"/jp/co/nri/ridual/r2/db/hibernate/cfg/hibernate.common.readuncommitted.cfg.xml", "/jp/co/nri/ridual/r2/db/hibernate/cfg/hibernate.common.serializable.cfg.xml"};
    private final String[] HIBERNATE_CFG_XML_PROJECT = new String[]{"/jp/co/nri/ridual/r2/db/hibernate/cfg/hibernate.project.readuncommitted.cfg.xml", "/jp/co/nri/ridual/r2/db/hibernate/cfg/hibernate.project.serializable.cfg.xml"};
    private final String[] HIBERNATE_CFG_XML_HISTORY;
    private static SessionFactoryController instance = new SessionFactoryController();
    private SessionFactory[] commonFactorys;
    private final Map projectMap;
    private final Map historyMap;
    private final EntityResolver cfgEntityResolver;

    private SessionFactoryController() {
        String[] stringArray = new String[2];
        stringArray[1] = "/jp/co/nri/ridual/r2/db/hibernate/cfg/hibernate.history.serializable.cfg.xml";
        this.HIBERNATE_CFG_XML_HISTORY = stringArray;
        this.commonFactorys = null;
        this.projectMap = new HashMap();
        this.historyMap = new HashMap();
        this.cfgEntityResolver = new HibernateEntityResolver();
    }

    public static SessionFactoryController getInstance() {
        return instance;
    }

    public static synchronized void rebuildInstance() {
        instance = new SessionFactoryController();
    }

    public synchronized SessionFactory getCommonFactory(int isolation) throws SQLException, HibernateException, IOException, DBConfigException {
        if (this.commonFactorys == null) {
            int len = this.HIBERNATE_CFG_XML_COMMON.length;
            this.commonFactorys = new SessionFactory[len];
            int i = 0;
            while (i < len) {
                String cfgXmlName = this.HIBERNATE_CFG_XML_COMMON[i];
                if (cfgXmlName == null) {
                    this.commonFactorys[i] = null;
                } else {
                    Configuration cfg = this.buildConfigureConfiguration(cfgXmlName);
                    new ExportSchema(cfg).exportIfNotExists();
                    this.commonFactorys[i] = cfg.buildSessionFactory();
                }
                ++i;
            }
        }
        return this.commonFactorys[isolation];
    }

    public SessionFactory getProjectFactory(Integer projectId, int isolation) throws HibernateException, SQLException, IOException, DBConfigException {
        Map map = this.projectMap;
        synchronized (map) {
            SessionFactory[] factorys = (SessionFactory[])this.projectMap.get(projectId);
            if (factorys == null) {
                factorys = this.buildIdSessionFactorys(projectId, this.HIBERNATE_CFG_XML_PROJECT, new ProjectIdTableNameCraft());
                this.projectMap.put(projectId, factorys);
            }
            return factorys[isolation];
        }
    }

    public void dropProjectSchema(Integer projectId) throws HibernateException, SQLException, IOException, DBConfigException {
        this.dropSchema(projectId, this.projectMap, this.HIBERNATE_CFG_XML_PROJECT, new ProjectIdTableNameCraft());
    }

    public SessionFactory getHistoryFactory(Integer historyId, int isolation) throws HibernateException, SQLException, IOException, DBConfigException {
        Map map = this.historyMap;
        synchronized (map) {
            SessionFactory[] factorys = (SessionFactory[])this.historyMap.get(historyId);
            if (factorys == null) {
                factorys = this.buildIdSessionFactorys(historyId, this.HIBERNATE_CFG_XML_HISTORY, new HistoryIdTableNameCraft());
                this.historyMap.put(historyId, factorys);
            }
            return factorys[isolation];
        }
    }

    public void dropHistorySchema(Integer historyId) throws HibernateException, SQLException, IOException, DBConfigException {
        this.dropSchema(historyId, this.historyMap, this.HIBERNATE_CFG_XML_HISTORY, new HistoryIdTableNameCraft());
    }

    private void dropSchema(Integer id, Map map, String[] cfgnames, AbstractIdTableNameCraft namecraft) throws HibernateException, SQLException, IOException, DBConfigException {
        Map map2 = map;
        synchronized (map2) {
            map.remove(id);
        }
        int i = cfgnames.length - 1;
        while (i >= 0) {
            String cfgname = cfgnames[i];
            if (cfgname != null) {
                Configuration cfg = this.buildIdConfiguration(id, cfgname, namecraft);
                SchemaExport schemaExport = new SchemaExport(cfg);
                schemaExport.drop(false, true);
            }
            --i;
        }
    }

    private SessionFactory[] buildIdSessionFactorys(Integer id, String[] hibernateCfgXmlNames, AbstractIdTableNameCraft tableNameCraft) throws HibernateException, SQLException, IOException, DBConfigException {
        int len = hibernateCfgXmlNames.length;
        SessionFactory[] factorys = new SessionFactory[len];
        int i = 0;
        while (i < len) {
            factorys[i] = this.buildIdSessionFactory(id, hibernateCfgXmlNames[i], tableNameCraft);
            ++i;
        }
        return factorys;
    }

    private SessionFactory buildIdSessionFactory(Integer id, String cfgname, AbstractIdTableNameCraft tableNameCraft) throws HibernateException, SQLException, IOException, DBConfigException {
        Configuration cfg = this.buildIdConfiguration(id, cfgname, tableNameCraft);
        return cfg == null ? null : cfg.buildSessionFactory();
    }

    private Configuration buildIdConfiguration(Integer id, String cfgname, AbstractIdTableNameCraft tableNameCraft) throws SQLException, HibernateException, IOException, DBConfigException {
        if (cfgname == null) {
            return null;
        }
        Configuration cfg = this.buildConfigureConfiguration(cfgname);
        Iterator classMappings = cfg.getClassMappings();
        while (classMappings.hasNext()) {
            Object obj = classMappings.next();
            Table table = ((PersistentClass)obj).getTable();
            String name = table.getName();
            table.setName(tableNameCraft.craft(name, id));
        }
        new ExportSchema(cfg).exportIfNotExists();
        return cfg;
    }

    private Configuration buildConfigureConfiguration(String xmlpath) throws HibernateException, IOException, DBConfigException {
        Configuration cfg = new Configuration();
        cfg.setEntityResolver(this.cfgEntityResolver);
        cfg.configure(xmlpath);
        RidualServerConfigProperties rscp = RidualServerConfigProperties.getInstance();
        String dbms = rscp.getString("db.dbms");
        String dbhost = rscp.getString("db.host");
        String dbport = rscp.getString("db.port");
        String dbname = rscp.getString("db.dbname");
        if (dbms == null || dbhost == null || dbport == null || dbname == null) {
            throw new DBConfigException();
        }
        String[] para = Patterns.SP_PATTERN.split(RidualResource.DB_PROPERTIES.getString(dbms));
        cfg.setProperty(HIBERNATE_CFG_KEY_JDBC_DRIVER, para[0]);
        cfg.setProperty(HIBERNATE_CFG_KEY_DIALECT, para[1]);
        cfg.setProperty(HIBERNATE_CFG_KEY_URL, new MessageFormat(para[2]).format(new Object[]{dbhost, dbport, dbname}));
        cfg.setProperty("db.host", rscp.getString("db.host"));
        cfg.setProperty("db.port", rscp.getString("db.port"));
        cfg.setProperty("db.dbname", rscp.getString("db.dbname"));
        cfg.setProperty("hibernate.connection.username", rscp.getString("hibernate.connection.username"));
        cfg.setProperty("hibernate.connection.password", rscp.getStringS("hibernate.connection.password"));
        Iterator classMappings = cfg.getClassMappings();
        while (classMappings.hasNext()) {
            Object obj = classMappings.next();
            this.configIndex(((PersistentClass)obj).getTable());
        }
        return cfg;
    }

    private void configIndex(Table table) {
        Iterator itrColumn = table.getColumnIterator();
        while (itrColumn.hasNext()) {
            Column col = (Column)itrColumn.next();
            String name = col.getName();
            if (!name.toLowerCase().startsWith("ix_")) continue;
            table.getOrCreateIndex("IDX_" + name).addColumn(col);
        }
    }
}

