/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.dao;

import java.net.URL;
import java.util.Date;
import java.util.List;
import jp.co.nri.ridual.r2.common.tabulationmap.TabulationMap;
import jp.co.nri.ridual.r2.db.bean.project.ContentsAndVariationContainer;
import jp.co.nri.ridual.r2.db.bean.project.ContentsBean;
import jp.co.nri.ridual.r2.db.bean.project.HtmlNodeBean;
import jp.co.nri.ridual.r2.db.dao.DefaultProjectDAO;
import jp.co.nri.ridual.r2.db.dao.RetryOverException;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;

public class ContentsAndVariationDAO
extends DefaultProjectDAO {
    public static final ContentsAndVariationDAO instance = new ContentsAndVariationDAO();
    private static final String[] EXTENSION_TABULATION_HQL_NAMES = new String[]{"contentsVariation.countAndSumAllByExtension", "contentsVariation.countCompleteByExtension", "contentsVariation.countIncompleteByExtension", "contentsVariation.countLostByExtension", "contentsVariation.countUnidentifiedByExtension"};
    private static final String[] CONTENT_TYPE_TABULATION_HQL_NAMES = new String[]{"contentsVariation.countAndSumAllByContentType", "contentsVariation.countCompleteByContentType", "contentsVariation.countIncompleteByContentType", "contentsVariation.countLostByContentType", "contentsVariation.countUnidentifiedByContentType"};

    private ContentsAndVariationDAO() {
        super(1);
    }

    public ContentsAndVariationContainer load(Integer projectId, Integer variationId) throws Throwable {
        try {
            return (ContentsAndVariationContainer)super.loadByName(projectId, "contentsVariation.load", variationId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public List findByHistoryId(Integer projectId, Integer historyId) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsAndVariation.findByHistoryId", historyId);
    }

    public List findByIsInner(Integer projectId, Integer historyId, boolean isInner) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsAndVariation.findByIsInner", new Object[]{historyId, isInner});
    }

    public List findPagesByIsInner(Integer projectId, Integer historyId, boolean isInner) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsAndVariation.findPagesByIsInner", new Object[]{historyId, isInner});
    }

    public List findResources(Integer projectId, Integer historyId) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsAndVariation.findResources", historyId);
    }

    public List findAccessibilityMessages(Integer projectId, Integer historyId) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsVariation.findAccessibilityMessages", historyId);
    }

    public List findLost(Integer projectId, Integer historyId) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsAndVariation.findLost", historyId);
    }

    public List findForObjects(Integer projectId, Integer historyId) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsVariation.findForObjects", historyId);
    }

    public List findForObjectsTagDetail(Integer projectId, Integer historyId) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsVariation.findForObjectsTagDetail", historyId);
    }

    public List findScript(Integer projectId, Integer historyId) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsAndVariation.findScript", historyId);
    }

    public List findForm(Integer projectId, Integer historyId) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsAndVariation.findForm", historyId);
    }

    public List findByRelationType(Integer projectId, Integer historyId, String relationType) throws Throwable {
        return this.findByNameWithLog(projectId, "contents.findByRelationType", new Object[]{relationType, historyId});
    }

    public List findByNodeFlag(Integer projectId, Integer historyId, String flag) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsVariation.findByNodeFlag", new Object[]{historyId, flag});
    }

    public List findParentsByVariationId(Integer projectId, Integer variationId) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsVariation.findParentsByVariationId", variationId);
    }

    public List findParentsByParameterPatternId(Integer projectId, Integer parameterPatternId) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsVariation.findParentsByParameterPatternId", parameterPatternId);
    }

    public List findChildrenByVariationId(Integer projectId, Integer variationId) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsVariation.findChildrenByVariationId", variationId);
    }

    public List findResourcesWithTag(Integer projectId, Integer variationId) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsVariation.findResourcesWithTag", variationId);
    }

    public List findChildWithCSSNode(Integer projectId, Integer variationId) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsVariation.findChildWithCSSNode", variationId);
    }

    public List findByTableDepth(Integer projectId, Integer historyId, Integer depth) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsVariation.findByTableDepth", new Object[]{historyId, depth});
    }

    public List findIncludedHalfKana(Integer projectId, Integer historyId) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsVariation.findIncludedHalfKana", historyId);
    }

    public List findIncludedWrongChar(Integer projectId, Integer historyId) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsVariation.findIncludedWrongChar", historyId);
    }

    public List findHasLog(Integer projectId, Integer historyId) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsVariation.findHasLog", historyId);
    }

    public String[] findContact(Integer projectId, Integer historyId) throws Throwable {
        return this.findByNameWithLog(projectId, "contents.findContact", historyId).toArray(new String[0]);
    }

    public TabulationMap tabulationByExtension(Integer projectId, Integer historyId) throws Throwable {
        return super.tabulation(projectId, historyId, EXTENSION_TABULATION_HQL_NAMES);
    }

    public int countInnerPagesByHistoryId(Integer projectId, Integer historyId) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countByType", new Object[]{historyId, new Integer(273)});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countInnerByType(Integer projectId, Integer historyId, int type) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countByType", new Object[]{historyId, new Integer(type)});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countInnerResources(Integer projectId, Integer historyId) throws Throwable {
        try {
            return super.countByName(projectId, "contentsAndVariation.countInnerResources", historyId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countLostPages(Integer projectId, Integer historyId) throws Throwable {
        try {
            return super.countByName(projectId, "contentsAndVariation.countLostPages", historyId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countLostResource(Integer projectId, Integer historyId) throws Throwable {
        try {
            return super.countByName(projectId, "contentsAndVariation.countLostResources", historyId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countOutLink(Integer projectId, Integer historyId) throws Throwable {
        try {
            return super.countByName(projectId, "contentsAndVariation.countOuter", historyId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countByTag(Integer projectId, Integer historyId, String tag) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countByNodeName", new Object[]{historyId, HtmlNodeBean.TYPE_ELEMENT_INTEGER, tag});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countPagesHasTagAndWithoutTag(Integer projectId, Integer historyId, Integer hasNodeType, String hasNodeName, Integer withoutNodeType, String withoutNodeName) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countPagesHasNodeAndWithoutNode", new Object[]{historyId, hasNodeType, hasNodeName, withoutNodeType, withoutNodeName});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countNode(Integer projectId, Integer historyId, Integer nodetype, String nodename) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countNode", new Object[]{historyId, nodetype, nodename});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countByAttribute(Integer projectId, Integer historyId, String attr) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countByNodeName", new Object[]{historyId, HtmlNodeBean.TYPE_ATTRIBUTE_INTEGER, attr});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countByValidAttribute(Integer projectId, Integer historyId, String attr) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countByValidNode", new Object[]{historyId, HtmlNodeBean.TYPE_ATTRIBUTE_INTEGER, attr});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countHasHn(Integer projectId, Integer historyId) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countHasHn", historyId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countByAttributes(Integer projectId, Integer historyId, String attr1, String attr2) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countByNodes", new Object[]{historyId, HtmlNodeBean.TYPE_ATTRIBUTE_INTEGER, attr1, attr2});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countByTagAndChildNode(Integer projectId, Integer historyId, String tag, Integer childtype, String childname) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countByTagAndChildNode", new Object[]{historyId, tag, childtype, childname});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countByTagHasValidAttribute(Integer projectId, Integer historyId, String tag, String attr) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countByTagHasValidAttribute", new Object[]{historyId, tag, attr});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countByAttributeValue_Insensitive(Integer projectId, Integer historyId, String attr, String value) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countByAttributeInsensitiveValue", new Object[]{historyId, attr, value});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countByTagAndAttributeValue_Insensitive(Integer projectId, Integer historyId, String tag, String attr, String value) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countByTagAndAttributeInsensitiveValue", new Object[]{historyId, tag, attr, value});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countByTagWithoutValidAttribute(Integer projectId, Integer historyId, String tag, String attr) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countByTagWithoutValidAttribute", new Object[]{historyId, tag, attr});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countByNodeWithoutParentTag(Integer projectId, Integer historyId, Integer nodetype, String nodename, String parenttagname) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countByNodeWithoutParentTag", new Object[]{historyId, nodetype, nodename, parenttagname});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countByTagWithoutChildNode(Integer projectId, Integer historyId, String tag, Integer childtype, String childname) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countByTagWithoutChildNode", new Object[]{historyId, tag, childtype, childname});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int maxTableDepth(Integer projectId, Integer historyId) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.maxTableDepth", historyId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public Date findInnerLastModified(Integer projectId, Integer historyId) throws Throwable {
        try {
            return (Date)super.findUniqueByName(projectId, "contentsVariation.findInnerLastModified", historyId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countContactByValue(Integer projectId, Integer historyId, String value) throws Throwable {
        try {
            return super.countByName(projectId, "contents.countContactValue", new Object[]{historyId, value});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countRelationByHistoryId(Integer projectId, Integer historyId) throws Throwable {
        try {
            return super.countByName(projectId, "contents.countRelationByHistoryId", historyId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countIncludedHalfKana(Integer projectId, Integer historyId) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countIncludedHalfKana", historyId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countIncludedWrongChar(Integer projectId, Integer historyId) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countIncludedWrongChar", historyId);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countByTableDepth(Integer projectId, Integer historyId, Integer depth) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countByTableDepth", new Object[]{historyId, depth});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countPagesHasNoEmptyTag(Integer projectId, Integer historyId, String name) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countPageHasNoEmptyTag", new Object[]{historyId, name});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countPagesByNodeFlag(Integer projectId, Integer historyId, String flag) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countByNodeFlag", new Object[]{historyId, flag});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public int countPagesByNodeType(Integer projectId, Integer historyId, Integer type) throws Throwable {
        try {
            return super.countByName(projectId, "contentsVariation.countByNodeType", new Object[]{historyId, type});
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public TabulationMap tabulationByContentType(Integer projectId, Integer historyId) throws Throwable {
        return super.tabulation(projectId, historyId, CONTENT_TYPE_TABULATION_HQL_NAMES);
    }

    public String[] sumByIsInner(Integer projectId, Integer historyId) throws Throwable {
        SessionFactory factory = super.getSessionFactory(projectId);
        RetryOverException roe = new RetryOverException(factory);
        Session session = factory.openSession();
        while (true) {
            try {
                String[] stringArray;
                try {
                    List list = super.simpleQueryByInteger((org.hibernate.Session)session, "contentsVariation.countByIsInner", historyId);
                    Object[][] objs = (Object[][])list.toArray((T[])new Object[0][3]);
                    String[] ret = new String[4];
                    int len = objs.length;
                    int i = 0;
                    while (i < len) {
                        this.movRet(ret, objs[i]);
                        ++i;
                    }
                    stringArray = ret;
                    Object var11_13 = null;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    session.close();
                    throw throwable;
                }
                session.close();
                return stringArray;
            }
            catch (Throwable t) {
                session = roe.retry(t);
                continue;
            }
            break;
        }
    }

    private void movRet(String[] ret, Object[] objs) {
        Boolean b = (Boolean)objs[0];
        int baseIx = b != false ? 0 : 2;
        int i = 0;
        while (i < 2) {
            String obj = objs[i + 1].toString();
            ret[baseIx + i] = obj == null ? null : obj.toString();
            ++i;
        }
    }

    private List findByNameWithLog(Integer projectId, String hqlname, Object[] param) throws Throwable {
        try {
            return super.findByName(projectId, hqlname, param);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    private List findByNameWithLog(Integer projectId, String hqlname, Integer param) throws Throwable {
        try {
            return super.findByName(projectId, hqlname, param);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public ContentsAndVariationContainer findByURL(Integer projectId, Integer historyId, String urlstr) throws Throwable {
        Object[] param = new Object[7];
        param[0] = historyId;
        ContentsBean contents = new ContentsBean();
        URL url = contents.setURL(urlstr);
        String query = url == null ? null : url.getQuery();
        param[1] = contents.getScheme();
        param[2] = contents.getHost();
        param[3] = new Integer(contents.getPort());
        param[4] = contents.getPath();
        param[5] = "GET";
        param[6] = query == null ? "" : query;
        try {
            return (ContentsAndVariationContainer)super.findUniqueByName(projectId, "contentsVariation.findByURL", param);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("DB.Contents&Variation", e);
            throw e;
        }
    }

    public String findMAXCharcodeByIsInner(Integer projectId, Integer historyId, boolean isInner) throws Throwable {
        List list = this.findByNameWithLog(projectId, "contentsAndVariation.findMAXCharcodeByIsInner", new Object[]{historyId, isInner});
        Object[][] objs = (Object[][])list.toArray((T[])new Object[0][2]);
        int objsize = objs.length;
        if (objsize == 0) {
            return null;
        }
        Integer base = (Integer)objs[0][1];
        String charcode = (String)objs[0][0] == null ? "" : (String)objs[0][0];
        int i = 1;
        while (i < objsize) {
            Integer val = (Integer)objs[i][1];
            String valchar = (String)objs[i][0];
            if (base < val) {
                charcode = valchar;
            } else if (base.intValue() == val.intValue()) {
                charcode = String.valueOf(charcode) + "," + valchar;
            }
            ++i;
        }
        return charcode;
    }

    public List findCSS(Integer projectId, Integer historyId) throws Throwable {
        return this.findByNameWithLog(projectId, "contentsAndVariation.findCSS", new Object[]{historyId});
    }
}

