/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.dao;

import java.io.Serializable;
import java.util.Date;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeComplete;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeQueue;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeTarget;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean;
import jp.co.nri.ridual.r2.db.bean.common.queue.AnalyzeTargetBean;
import jp.co.nri.ridual.r2.db.dao.AnalyzeHistoryDAO;
import jp.co.nri.ridual.r2.db.dao.DefaultHistoryDAO;
import jp.co.nri.ridual.r2.db.dao.DropHistorySchemaRobo;
import jp.co.nri.ridual.r2.db.dao.HistoryCache;
import jp.co.nri.ridual.r2.db.dao.QueueMap;
import jp.co.nri.ridual.r2.db.dao.RetryOverException;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import jp.co.nri.ridual.r2.properties.RidualServerConfigProperties;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class AnalyzeQueueDAO
extends DefaultHistoryDAO
implements AnalyzeQueue {
    private final QueueMap queueMap = new QueueMap();
    static /* synthetic */ Class class$0;

    public AnalyzeQueueDAO() throws Throwable {
        super(1);
        AnalyzeHistoryBean[] histories = AnalyzeHistoryDAO.instance.findIncomplete();
        int i = histories.length - 1;
        while (i >= 0) {
            Integer historyId = histories[i].getId();
            this.queueMap.entryHistoryId(historyId);
            --i;
        }
    }

    public Integer[] getHistoryIdArray() {
        return this.queueMap.toHistoryIdArray();
    }

    public AnalyzeTarget[] findAnalyzing(Integer historyId, String servername) throws Throwable {
        try {
            return (servername == null ? super.findByName(historyId, "queue.findAnalyzingServerIsNull") : super.findByName(historyId, "queue.findAnalyzing", servername)).toArray(new AnalyzeTargetBean[0]);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("QUEUE", e);
            throw e;
        }
    }

    public void entry(Integer historyId, Integer contentsId, Integer variationId, int depth) throws Throwable {
        this.enqueue(historyId, contentsId, variationId, depth, 0);
        this.queueMap.entryHistoryId(historyId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean enqueue(Integer historyId, Integer contentsId, Integer variationId, int depth, int filesLimit) throws Throwable {
        try {
            SessionFactory factory = super.getSessionFactory(historyId);
            RetryOverException roe = new RetryOverException(factory);
            Session session = factory.openSession();
            while (true) {
                try {
                    block11: {
                        block10: {
                            try {
                                Transaction transaction = session.beginTransaction();
                                try {
                                    int count;
                                    if (filesLimit > 0 && filesLimit <= (count = super.countByName("queue.countAll", (org.hibernate.Session)session))) {
                                        transaction.rollback();
                                        Object var11_15 = null;
                                        break block10;
                                    }
                                    AnalyzeTargetBean target = new AnalyzeTargetBean(contentsId, variationId, depth);
                                    session.save((Object)target);
                                    transaction.commit();
                                    break block11;
                                }
                                catch (Throwable t) {
                                    transaction.rollback();
                                    throw t;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var11_17 = null;
                                session.close();
                                throw throwable;
                            }
                        }
                        session.close();
                        return false;
                    }
                    Object var11_16 = null;
                    session.close();
                    return true;
                }
                catch (Throwable t) {
                    session = roe.retry(t);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("QUEUE", e);
            throw e;
        }
    }

    public void removeQueue(Integer historyId) throws Throwable {
        try {
            this.queueMap.removeEntry(historyId);
            AnalyzeHistoryDAO.instance.removeCache(historyId);
            new DropHistorySchemaRobo(historyId).start();
        }
        catch (Throwable t) {
            RidualServerLogDAO.getInstance().record("QUEUE", t);
            throw t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AnalyzeTarget transactionAnalyzeHistory(Integer historyId) throws Throwable {
        AnalyzeTarget analyzeTarget;
        Session session;
        block15: {
            AnalyzeTarget analyzeTarget2;
            block13: {
                AnalyzeTarget analyzeTarget3;
                block12: {
                    SessionFactory historyFactory = AnalyzeHistoryDAO.instance.getSessionFactory();
                    session = historyFactory.openSession();
                    try {
                        Date completeDate = null;
                        Transaction transaction = session.beginTransaction();
                        try {
                            AnalyzeHistoryBean historyBean;
                            Date timestampComplete;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                Class<?> clazz2;
                                try {
                                    clazz2 = Class.forName("jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                clazz = class$0 = clazz2;
                            }
                            if ((timestampComplete = (historyBean = (AnalyzeHistoryBean)session.load((Class)clazz, (Serializable)historyId)).getTimestampComplete()) != null || historyBean.getDeleted()) {
                                this.queueMap.removeEntry(historyId);
                                AnalyzeHistoryDAO.instance.removeCache(historyId);
                                transaction.rollback();
                                analyzeTarget3 = null;
                                Object var9_12 = null;
                                break block12;
                            }
                            AnalyzeTarget target = this.dequeue(historyId);
                            if (target != null) {
                                transaction.rollback();
                                analyzeTarget2 = target;
                                break block13;
                            }
                            completeDate = this.checkFinalize(historyBean, (org.hibernate.Session)session);
                            if (completeDate == null) {
                                transaction.rollback();
                            } else {
                                DefaultHistoryDAO.dropHistorySchema(historyId);
                                transaction.commit();
                            }
                        }
                        catch (Throwable t) {
                            transaction.rollback();
                            throw t;
                        }
                        if (completeDate != null) {
                            this.queueMap.removeEntry(historyId);
                            HistoryCache historyCache = AnalyzeHistoryDAO.instance.removeCache(historyId);
                            historyCache.history.setTimestampComplete(completeDate);
                            throw new AnalyzeComplete(historyCache);
                        }
                        analyzeTarget = null;
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var9_15 = null;
                        session.close();
                        throw throwable;
                    }
                }
                session.close();
                return analyzeTarget3;
            }
            Object var9_13 = null;
            session.close();
            return analyzeTarget2;
        }
        Object var9_14 = null;
        session.close();
        return analyzeTarget;
    }

    private Date checkFinalize(AnalyzeHistoryBean bean, org.hibernate.Session session) throws Throwable {
        if (this.countIncomplete(bean.getId()) <= 0) {
            AnalyzeHistoryDAO.instance.updateComplete(bean, session);
            return bean.getTimestampComplete();
        }
        return null;
    }

    public AnalyzeTarget dequeue() throws AnalyzeComplete, Throwable {
        try {
            Integer historyId = this.queueMap.nextHistoryId();
            if (historyId == null) {
                return null;
            }
            return this.transactionAnalyzeHistory(historyId);
        }
        catch (AnalyzeComplete ac) {
            throw ac;
        }
        catch (Throwable t) {
            RidualServerLogDAO.getInstance().record("QUEUE", t);
            throw t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AnalyzeTarget dequeue(Integer historyId) throws Throwable {
        SessionFactory factory = super.getSessionFactory(historyId);
        RetryOverException roe = new RetryOverException(factory);
        Session session = factory.openSession();
        while (true) {
            try {
                AnalyzeTargetBean analyzeTargetBean;
                try {
                    Transaction transaction = session.beginTransaction();
                    try {
                        Query query = session.getNamedQuery("queue.dequeue");
                        query.setMaxResults(1);
                        AnalyzeTargetBean target = (AnalyzeTargetBean)query.uniqueResult();
                        if (target != null) {
                            RidualServerConfigProperties rscp = RidualServerConfigProperties.getInstance();
                            target.setStatus(1);
                            target.setAnalyzeServer(rscp.getString("ridual.server.name"));
                            session.update((Object)target);
                            target.setHistoryId(historyId);
                        }
                        transaction.commit();
                        analyzeTargetBean = target;
                        Object var9_12 = null;
                    }
                    catch (Throwable t) {
                        transaction.rollback();
                        throw t;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    session.close();
                    throw throwable;
                }
                session.close();
                return analyzeTargetBean;
            }
            catch (Throwable t) {
                session = roe.retry(t);
                continue;
            }
            break;
        }
    }

    private int countIncomplete(Integer historyId) throws Throwable {
        try {
            return super.countByName(historyId, "queue.countIncomplete");
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("QUEUE", e);
            throw e;
        }
    }

    public int countComplete(Integer historyId) throws Throwable {
        try {
            return super.countByName(historyId, "queue.countComplete");
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("QUEUE", e);
            throw e;
        }
    }

    public int countAnalyzing(Integer historyId) throws Throwable {
        try {
            return super.countByName(historyId, "queue.countAnalyzing");
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("QUEUE", e);
            throw e;
        }
    }

    public int countAll(Integer historyId) throws Throwable {
        try {
            return super.countByName(historyId, "queue.countAll");
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("QUEUE", e);
            throw e;
        }
    }

    public void markingAnalyzed(AnalyzeTarget target) throws Throwable {
        target.setStatus(2);
        this.update(target);
    }

    public void markingReserve(AnalyzeTarget target) throws Throwable {
        target.setStatus(0);
        this.update(target);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void update(AnalyzeTarget target) throws Throwable {
        Integer historyId = target.getHistoryId();
        try {
            SessionFactory factory = super.getSessionFactory(historyId);
            RetryOverException roe = new RetryOverException(factory);
            Session session = factory.openSession();
            while (true) {
                try {
                    try {
                        Transaction transaction = session.beginTransaction();
                        try {
                            session.update((Object)target);
                            transaction.commit();
                            Object var8_9 = null;
                        }
                        catch (Throwable t) {
                            transaction.rollback();
                            throw t;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        session.close();
                        throw throwable;
                    }
                    session.close();
                    return;
                }
                catch (Throwable t) {
                    session = roe.retry(t);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("QUEUE", e);
            throw e;
        }
    }
}

