/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.bean.project;

import java.io.File;
import java.util.Date;
import jp.co.nri.ridual.r2.common.uri.URIOperator;
import jp.co.nri.ridual.r2.db.bean.AbstractNodable;
import jp.co.nri.ridual.r2.db.bean.project.AbstractProjectNodable;
import jp.co.nri.ridual.r2.resource.RidualResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LocalFileBean
extends AbstractProjectNodable {
    public static final String HQL_QUERY_NAME_FIND_PAGES_BY_DIRECTORY_MAP_ID = "localFile.findPagesByDirectoryMapId";
    public static final String HQL_QUERY_NAME_FIND_RESOURCES_BY_DIRECTORY_MAP_ID = "localFile.findResourcesByDirectoryMapId";
    public static final String HQL_QUERY_NAME_FIND_FOR_DIFFERENCE = "localFile.findForDifference";
    public static final String HQL_QUERY_NAME_COUNT_AND_SUM_ALL_BY_EXTENSION = "localFile.countAndSumAllByExtension";
    private static final String ELEMENT_NAME_ROOT = "LOCAL_FILE";
    private static final String ELEMENT_NAME_PATH = "PATH";
    private static final String ELEMENT_NAME_EXTENSION = "EXTENSION";
    private static final String ELEMENT_NAME_TIMESTAMP = "TIMESTAMP";
    private static final String ELEMENT_NAME_SIZE = "SIZE";
    private Integer id;
    private Integer localHistoryId;
    private Integer directoryMapId;
    private String extension;
    private String ridualContentType;
    private String path;
    private Date timestamp;
    private long size;

    public LocalFileBean() {
    }

    public LocalFileBean(Integer localHistoryId, Integer directoryMapId, String relativePath, File file) {
        this.localHistoryId = localHistoryId;
        this.directoryMapId = directoryMapId;
        this.setPathPlus(relativePath, file);
        this.timestamp = new Date(file.lastModified());
        this.size = file.length();
    }

    public Node buildNode(Integer projectId, int mode, Document doc) {
        Element elm = doc.createElement(ELEMENT_NAME_ROOT);
        super.buildTextElement(elm, ELEMENT_NAME_PATH, this.path);
        super.buildTextElement(elm, ELEMENT_NAME_EXTENSION, this.extension);
        super.buildDateElement(elm, ELEMENT_NAME_TIMESTAMP, this.timestamp);
        super.buildLongElement(elm, ELEMENT_NAME_SIZE, this.size);
        return elm;
    }

    public AbstractNodable[] loadChild(Integer projectId, int mode) throws Throwable {
        return null;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getLocalHistoryId() {
        return this.localHistoryId;
    }

    public void setLocalHistoryId(Integer localHistoryId) {
        this.localHistoryId = localHistoryId;
    }

    public Integer getDirectoryMapId() {
        return this.directoryMapId;
    }

    public void setDirectoryMapId(Integer directoryMapId) {
        this.directoryMapId = directoryMapId;
    }

    public String getRidualContentType() {
        return this.ridualContentType;
    }

    public void setRidualContentType(String ridualContentType) {
        this.ridualContentType = ridualContentType;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void settimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    private void setPathPlus(String relativePath, File file) {
        String filename = file.getName();
        this.path = String.valueOf(relativePath) + filename;
        this.extension = URIOperator.instance.extractExtensionFromFilename(filename);
        this.ridualContentType = RidualResource.EXTENSION_CONTENT_TYPE_MAP.get(this.extension);
    }
}

