/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.analyzerobo.content.html;

import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import jp.co.nri.ridual.r2.analyzerobo.content.css.CSSHandler;
import jp.co.nri.ridual.r2.analyzerobo.content.html.AbstractHtmlElementUnit;
import jp.co.nri.ridual.r2.analyzerobo.content.html.HtmlAnaConfig;
import jp.co.nri.ridual.r2.analyzerobo.content.html.HtmlAnaData;
import jp.co.nri.ridual.r2.analyzerobo.content.html.HtmlContentProcessingUnit;
import jp.co.nri.ridual.r2.analyzerobo.content.html.HtmlNodeAnaData;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.helpers.ParserFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StyleHtmlElementUnit
extends AbstractHtmlElementUnit {
    public String[] getKeys() {
        return new String[]{"style"};
    }

    public void play(Element elm, HtmlContentProcessingUnit hcpu, HtmlAnaConfig config, HtmlAnaData htmlAnaData, HtmlNodeAnaData nodeAnaData) {
        String text = null;
        try {
            StringBuffer sb = new StringBuffer();
            NodeList list = elm.getChildNodes();
            if (list != null) {
                int len = list.getLength();
                int i = 0;
                while (i < len) {
                    Node child = list.item(i);
                    short nType = child.getNodeType();
                    if (nType == 3 || nType == 8) {
                        String val = child.getNodeValue();
                        sb.append(val);
                    }
                    ++i;
                }
            }
            text = hcpu.decodeSimple(sb.toString());
            StringReader sr = new StringReader(text);
            InputSource source = new InputSource((Reader)sr);
            Parser parser = new ParserFactory().makeParser();
            parser.setDocumentHandler((DocumentHandler)new CSSHandler(config.projectId, config.content, config.variation, config.depth, config.filesLimit, config.analyzeOptionFlags, true, null));
            parser.parseStyleSheet(source);
        }
        catch (UnsupportedEncodingException usee) {
            ProjectLogDAO.instance.recordIssueVariation(config.projectId, "analyze.html", "AnalyzeRobo.HTML.unsupportedEncoding", config.historyId, config.contentsId, config.variationId, new Object[]{hcpu.getRealEncoding(), text}, usee);
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueVariation(config.projectId, "analyze.html", "AnalyzeRobo.CSS.parse", config.historyId, config.contentsId, config.variationId, new Object[]{t.getMessage()}, t);
        }
    }
}

