/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.analyzerobo.content.html;

import jp.co.nri.ridual.r2.analyzerobo.content.html.AbstractHtmlElementUnit;
import jp.co.nri.ridual.r2.analyzerobo.content.html.HtmlAnaConfig;
import jp.co.nri.ridual.r2.analyzerobo.content.html.HtmlAnaData;
import jp.co.nri.ridual.r2.analyzerobo.content.html.HtmlContentProcessingUnit;
import jp.co.nri.ridual.r2.analyzerobo.content.html.HtmlNodeAnaData;
import jp.co.nri.ridual.r2.common.contenttype.ContentType;
import jp.co.nri.ridual.r2.common.refresh.Refresh;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import org.w3c.dom.Element;

public class MetaHtmlElementUnit
extends AbstractHtmlElementUnit {
    public String[] getKeys() {
        return new String[]{"meta"};
    }

    public void play(Element elm, HtmlContentProcessingUnit hcpu, HtmlAnaConfig config, HtmlAnaData htmlAnaData, HtmlNodeAnaData nodeAnaData) {
        String httpequiv = elm.getAttribute("http-equiv");
        if (httpequiv == null) {
            return;
        }
        if (httpequiv.equalsIgnoreCase("content-type")) {
            String content = elm.getAttribute("content");
            ContentType contenttype = new ContentType(content);
            try {
                if (!hcpu.setContentsEncoding(contenttype.encoding)) {
                    ProjectLogDAO.instance.recordIssueVariation(config.projectId, "analyze.html", "AnalyzeRobo.HTML.save.meta.encoding", config.historyId, config.contentsId, config.variationId, new Object[]{content}, null);
                }
            }
            catch (Throwable t) {
                ProjectLogDAO.instance.recordIssueVariation(config.projectId, "analyze.html", "AnalyzeRobo.HTML.save.meta.encoding", config.historyId, config.contentsId, config.variationId, new Object[]{content}, t);
            }
            return;
        }
        if (config.isInnerAndDepthAndTraceLink && (httpequiv.equalsIgnoreCase("refresh") || httpequiv.equalsIgnoreCase("location"))) {
            String content = elm.getAttribute("content");
            Refresh refresh = new Refresh(content);
            nodeAnaData.relationURL = refresh.url;
            nodeAnaData.relationType = "html.meta";
            nodeAnaData.relationAttribute = "content";
        }
    }
}

