/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.analyzerobo.content.css;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeQueue;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeQueueFactory;
import jp.co.nri.ridual.r2.analyzerobo.content.css.ParentIdStack;
import jp.co.nri.ridual.r2.db.bean.project.CSSNodeBean;
import jp.co.nri.ridual.r2.db.bean.project.ContentsBean;
import jp.co.nri.ridual.r2.db.bean.project.ContentsVariationBean;
import jp.co.nri.ridual.r2.db.dao.CSSNodesDAO;
import jp.co.nri.ridual.r2.db.dao.ContentsRelationDAO;
import jp.co.nri.ridual.r2.db.dao.ContentsSet;
import jp.co.nri.ridual.r2.db.dao.ContentsSupplementDAO;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;

public class CSSHandler
implements DocumentHandler {
    private static final AnalyzeQueue queue = AnalyzeQueueFactory.getAnalyzeQueue();
    private static final String EMPTY = "";
    private static final String IMPORTANT = "! important";
    private final Integer projectId;
    private final Integer historyId;
    private final Integer contentsId;
    private final Integer variationId;
    private final URL contentsURL;
    private final int depthNext;
    private final int filesLimit;
    private final boolean isTraceLink;
    private final boolean isSaveNode;
    private final String cookie;
    private final ParentIdStack parentIdStack = new ParentIdStack();

    public CSSHandler(Integer projectId, ContentsBean contents, ContentsVariationBean variation, int depth, int filesLimit, int analyzeOptionFlags, boolean checkInner, String cookie) throws MalformedURLException, URISyntaxException {
        boolean b;
        this.projectId = projectId;
        this.historyId = contents.getHistoryId();
        this.contentsId = contents.getId();
        this.variationId = variation.getId();
        this.contentsURL = contents.buildURL(variation);
        this.depthNext = depth - 1;
        this.filesLimit = filesLimit;
        this.isSaveNode = (analyzeOptionFlags & 0x10) != 0;
        boolean bl = b = (analyzeOptionFlags & 2) != 0;
        this.isTraceLink = checkInner ? contents.getIsInner().booleanValue() && b : b;
        this.cookie = cookie;
    }

    public void startDocument(InputSource src) throws CSSException {
        this.saveContentsSupplement(null, "CSS.encoding", src.getEncoding());
        this.saveContentsSupplement(null, "CSS.media", src.getMedia());
        this.saveContentsSupplement(null, "CSS.title", src.getTitle());
        this.saveContentsSupplement(null, "CSS.uri", src.getURI());
    }

    public void endDocument(InputSource src) throws CSSException {
    }

    public void startMedia(SACMediaList media) throws CSSException {
        if (this.isSaveNode) {
            String mediastr = EMPTY;
            try {
                mediastr = this.buildMediaString(media);
                CSSNodeBean bean = CSSNodesDAO.instance.saveNode(this.projectId, this.contentsId, this.variationId, this.parentIdStack.getCurrentId(), "media", mediastr);
                Integer id = bean.getId();
                this.parentIdStack.push(id);
            }
            catch (Throwable t) {
                ProjectLogDAO.instance.recordIssueVariation(this.projectId, "analyze.css", "AnalyzeRobo.CSS.parse.media", this.historyId, this.contentsId, this.variationId, new Object[]{mediastr}, t);
            }
        }
    }

    public void endMedia(SACMediaList media) throws CSSException {
        this.parentIdStack.pop();
    }

    public void startSelector(SelectorList selectors) throws CSSException {
        block5: {
            try {
                if (!this.isSaveNode) break block5;
                CSSNodeBean bean = CSSNodesDAO.instance.saveNode(this.projectId, this.contentsId, this.variationId, this.parentIdStack.getCurrentId(), "selector", null);
                Integer id = bean.getId();
                this.parentIdStack.push(id);
                int len = selectors.getLength();
                int i = 0;
                while (i < len) {
                    Selector s = null;
                    try {
                        s = selectors.item(i);
                        CSSNodesDAO.instance.saveSelector(this.projectId, this.variationId, id, s);
                    }
                    catch (Throwable t) {
                        ProjectLogDAO.instance.recordIssueVariation(this.projectId, "analyze.css", "AnalyzeRobo.CSS.parse.selector", this.historyId, this.contentsId, this.variationId, new Object[]{s == null ? EMPTY : s.toString()}, t);
                    }
                    ++i;
                }
            }
            catch (Throwable t) {
                ProjectLogDAO.instance.recordIssueVariation(this.projectId, "analyze.css", "AnalyzeRobo.CSS.parse.selector", this.historyId, this.contentsId, this.variationId, new Object[]{selectors.toString()}, t);
            }
        }
    }

    public void endSelector(SelectorList selectors) throws CSSException {
        this.parentIdStack.pop();
    }

    public void startPage(String name, String pseudo_page) throws CSSException {
        try {
            if (this.isSaveNode) {
                CSSNodeBean bean = CSSNodesDAO.instance.saveNode(this.projectId, this.contentsId, this.variationId, this.parentIdStack.getCurrentId(), "page", name);
                Integer id = bean.getId();
                this.parentIdStack.push(id);
                this.saveNodeSupplement(id, "page.pseudo", pseudo_page);
            }
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueVariation(this.projectId, "analyze.css", "AnalyzeRobo.CSS.parse.page", this.historyId, this.contentsId, this.variationId, new Object[]{name, pseudo_page}, t);
        }
    }

    public void endPage(String name, String pseudo_page) throws CSSException {
        this.parentIdStack.pop();
    }

    public void property(String name, LexicalUnit value, boolean important) throws CSSException {
        try {
            Integer nodeId = null;
            if (this.isSaveNode) {
                CSSNodeBean bean = CSSNodesDAO.instance.savePropertyNode(this.projectId, this.contentsId, this.variationId, this.parentIdStack.getCurrentId(), name, important);
                nodeId = bean.getId();
            }
            this.buildLexical(value, nodeId);
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueVariation(this.projectId, "analyze.css", "AnalyzeRobo.CSS.parse.property", this.historyId, this.contentsId, this.variationId, new Object[]{name, value.toString(), important ? IMPORTANT : EMPTY}, t);
        }
    }

    public void comment(String text) throws CSSException {
        try {
            if (this.isSaveNode) {
                CSSNodesDAO.instance.saveNode(this.projectId, this.contentsId, this.variationId, this.parentIdStack.getCurrentId(), "comment", text);
            }
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueVariation(this.projectId, "analyze.css", "AnalyzeRobo.CSS.parse.comment", this.historyId, this.contentsId, this.variationId, new Object[]{text}, t);
        }
    }

    public void ignorableAtRule(String atRule) throws CSSException {
        try {
            if (this.isSaveNode) {
                CSSNodesDAO.instance.saveNode(this.projectId, this.contentsId, this.variationId, this.parentIdStack.getCurrentId(), "ignorebleAtRule", atRule);
            }
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueVariation(this.projectId, "analyze.css", "AnalyzeRobo.CSS.parse.ignorableAtRule", this.historyId, this.contentsId, this.variationId, new Object[]{atRule}, t);
        }
    }

    public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
        Integer nodeId = null;
        try {
            if (this.isSaveNode) {
                CSSNodeBean bean = CSSNodesDAO.instance.saveNode(this.projectId, this.contentsId, this.variationId, this.parentIdStack.getCurrentId(), "importStyle", uri);
                nodeId = bean.getId();
                this.saveNodeSupplement(bean.getId(), "importStyle.media", this.buildMediaString(media));
                this.saveNodeSupplement(bean.getId(), "importStyle.defaultNamespaceURI", defaultNamespaceURI);
            }
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueVariation(this.projectId, "analyze.css", "AnalyzeRobo.CSS.parse.import", this.historyId, this.contentsId, this.variationId, new Object[]{uri, media.toString(), defaultNamespaceURI}, t);
        }
        try {
            this.enqueue(uri, nodeId);
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueVariation(this.projectId, "analyze.css", "AnalyzeRobo.CSS.parse.import.enqueue", this.historyId, this.contentsId, this.variationId, new Object[]{uri, media.toString(), defaultNamespaceURI}, t);
        }
    }

    public void namespaceDeclaration(String prefix, String uri) throws CSSException {
        try {
            if (this.isSaveNode) {
                CSSNodeBean bean = CSSNodesDAO.instance.saveNode(this.projectId, this.contentsId, this.variationId, this.parentIdStack.getCurrentId(), "namespaceDeclaration", prefix);
                this.saveNodeSupplement(bean.getId(), "namespaceDeclaration.uri", uri);
            }
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueVariation(this.projectId, "analyze.css", "AnalyzeRobo.CSS.parse.namespaceDeclaration", this.historyId, this.contentsId, this.variationId, new Object[]{prefix, uri}, t);
        }
    }

    public void startFontFace() throws CSSException {
    }

    public void endFontFace() throws CSSException {
    }

    private void enqueue(String uri, Integer nodeId) throws Throwable {
        if (this.isTraceLink) {
            ContentsSet childContentsSet = ContentsRelationDAO.instance.saveWithloadOrSaveWithContentsAndVatiation(this.projectId, this.historyId, this.contentsId, this.variationId, this.contentsURL, uri, nodeId, "css", this.cookie);
            if (!childContentsSet.variationIsLoad) {
                queue.enqueue(this.historyId, childContentsSet.contents.getId(), childContentsSet.variation.getId(), this.depthNext, this.filesLimit);
            }
        }
    }

    private void saveContentsSupplement(String category, String name, String value) {
        try {
            ContentsSupplementDAO.instance.save(this.projectId, this.contentsId, this.variationId, category, name, value);
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueVariation(this.projectId, "analyze.css", "AnalyzeRobo.CSS.saveContentsSupplement", this.historyId, this.contentsId, this.variationId, new Object[]{category, name, value}, t);
        }
    }

    private void saveNodeSupplement(Integer id, String name, String value) {
        try {
            CSSNodesDAO.instance.addSupplement(this.projectId, this.variationId, id, name, value);
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueVariation(this.projectId, "analyze.css", "AnalyzeRobo.CSS.saveNodeSupplement", this.historyId, this.contentsId, this.variationId, new Object[]{name, value}, t);
        }
    }

    private String buildMediaString(SACMediaList media) {
        StringBuffer sb = new StringBuffer();
        int len = media.getLength();
        int i = 0;
        while (i < len) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(media.item(i));
            ++i;
        }
        return sb.toString();
    }

    private void buildLexical(LexicalUnit value, Integer nodeId) throws Throwable {
        switch (value.getLexicalUnitType()) {
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                break;
            }
            case 42: {
                break;
            }
            case 24: {
                this.enqueue(value.getStringValue(), nodeId);
                break;
            }
            case 35: {
                break;
            }
            case 36: {
                break;
            }
            case 37: {
                break;
            }
            case 25: {
                break;
            }
            case 26: {
                break;
            }
            case 38: {
                break;
            }
            case 41: {
                break;
            }
            case 27: {
                break;
            }
            case 39: {
                break;
            }
        }
        LexicalUnit next = value.getNextLexicalUnit();
        if (next == null) {
            return;
        }
        this.buildLexical(next, nodeId);
    }
}

