/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.analyzerobo;

import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import jp.co.nri.ridual.r2.common.authmap.PasswordAuthenticationMap;
import jp.co.nri.ridual.r2.common.uri.URIOperator;

public class RidualAuthenticator
extends Authenticator {
    public static final RidualAuthenticator instance = new RidualAuthenticator();
    private final PasswordAuthenticationMap proxyMap = new PasswordAuthenticationMap();
    private final PasswordAuthenticationMap anaSiteMap = new PasswordAuthenticationMap();

    private RidualAuthenticator() {
        Authenticator.setDefault(this);
    }

    public void entryProxy(String protocol, String host, int port, String user, String password) throws MalformedURLException {
        PasswordAuthentication passwordAuthentication = PasswordAuthenticationMap.buildPasswordAuthentication(user, password);
        this.proxyMap.putReplacePasswordAuthentication(new URL(protocol, host, port, ""), passwordAuthentication);
    }

    public boolean entryAnaSite(URL url, PasswordAuthentication pa) {
        return this.anaSiteMap.putPasswordAuthentication(url, pa);
    }

    public void relAnaSite(URL url) {
        this.anaSiteMap.removePasswordAuthentication(url);
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        String protocol = this.getRequestingProtocol();
        String host = this.getRequestingHost();
        int port = this.getRequestingPort();
        try {
            URL url = URIOperator.instance.buildURL4Auth(protocol, host, port);
            PasswordAuthentication auth = this.proxyMap.getPasswordAuthentication(url);
            return auth == null ? this.anaSiteMap.getPasswordAuthentication(url) : auth;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

