/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.analyzerobo;

import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeQueue;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeQueueFactory;
import jp.co.nri.ridual.r2.analyzerobo.AnalyzeRobo;
import jp.co.nri.ridual.r2.analyzerobo.RecheckOutLinkRecoverRobo;
import jp.co.nri.ridual.r2.analyzerobo.RecheckOutLinkRobo;
import jp.co.nri.ridual.r2.analyzerobo.RefreshThumbnailRecoverRobo;
import jp.co.nri.ridual.r2.analyzerobo.RidualAuthenticator;
import jp.co.nri.ridual.r2.common.pattern.Patterns;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeSiteConfigBean;
import jp.co.nri.ridual.r2.db.dao.AnalyzeHistoryDAO;
import jp.co.nri.ridual.r2.db.dao.AnalyzeSiteConfigDAO;
import jp.co.nri.ridual.r2.db.dao.ContentsDAO;
import jp.co.nri.ridual.r2.db.dao.ContentsSet;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import jp.co.nri.ridual.r2.db.dao.SiteAndHistoryContainer;
import jp.co.nri.ridual.r2.db.dao.WebCaptureQueueDAO;
import jp.co.nri.ridual.r2.properties.RidualServerConfigProperties;
import jp.co.nri.ridual.r2.resource.RidualResource;
import jp.co.nri.ridual.r2.restrict.RestrictChecker;
import jp.co.nri.ridual.r2.restrict.RestrictItem;
import jp.co.nri.ridual.r2.robots.buildreportrobo.BuildReportRoboController;
import jp.co.nri.ridual.r2.robots.recoverrobo.analyzequeue.AnalyzeQueueRecoverRobo;
import jp.co.nri.ridual.r2.robots.recoverrobo.buildreport.BuildReportRecoverRobo;
import jp.co.nri.ridual.r2.robots.removehistorydirrobo.RemoveHistoryDirRobo;

public class AnalyzeRoboController {
    private static final int MAX_ROBOTS = 64;
    private static final String HTTP = "http";
    private static final String SYSTEM_PROPERTY_KEY_HTTP_PROXY_HOST = "http.proxyHost";
    private static final String SYSTEM_PROPERTY_KEY_HTTP_PROXY_PORT = "http.proxyPort";
    private static final String SYSTEM_PROPERTY_KEY_HTTP_NONPROXY_HOST = "http.nonProxyHosts";
    private static final String SYSTEM_PROPERTY_KEY_HTTP_AGENT = "http.agent";
    private static final String SYSTEM_PROPERTY_KEY_HTTP_KEEP_ALIVE = "http.keepAlive";
    private static final String SYSTEM_PROPERTY_KEY_HTTP_MAX_CONNECTIONS = "http.maxConnections";
    private static final String SYSTEM_PROPERTY_KEY_HTTP_AUTH_DIGEST = "http.auth.digest.validateServer";
    private static final String SYSTEM_PROPERTY_KEY_HTTP_PROXY_AUTH_DIGEST = "http.auth.digest.validateProxy";
    public static final AnalyzeRoboController instance = new AnalyzeRoboController();
    private final ArrayList robots = new ArrayList();
    private boolean isStartup = false;

    private AnalyzeRoboController() {
        HttpURLConnection.setFollowRedirects(false);
        URLConnection.setDefaultAllowUserInteraction(false);
        System.setProperty(SYSTEM_PROPERTY_KEY_HTTP_MAX_CONNECTIONS, Integer.toString(64));
        System.setProperty(SYSTEM_PROPERTY_KEY_HTTP_KEEP_ALIVE, Boolean.TRUE.toString());
        System.setProperty(SYSTEM_PROPERTY_KEY_HTTP_AUTH_DIGEST, Boolean.TRUE.toString());
        System.setProperty(SYSTEM_PROPERTY_KEY_HTTP_PROXY_AUTH_DIGEST, Boolean.TRUE.toString());
        try {
            String agent = RidualResource.ANALYZEROBO_PROPERTIES.getString("HTTP.Agent");
            System.setProperty(SYSTEM_PROPERTY_KEY_HTTP_AGENT, agent);
        }
        catch (Throwable t) {
            System.setProperty(SYSTEM_PROPERTY_KEY_HTTP_AGENT, "Ridual");
        }
        try {
            RidualServerConfigProperties rscp = RidualServerConfigProperties.getInstance();
            if (!rscp.isEmpty()) {
                String host = rscp.getString("proxy.host");
                Integer port = rscp.getInteger("proxy.port");
                String user = rscp.getString("proxy.user");
                String password = rscp.getStringS("proxy.password");
                String nonproxyhost = rscp.getString("proxy.host.nonproxy");
                this.setHttpProxy(host, port, user, password, nonproxyhost);
            }
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("AnalyzeRoboController", e);
        }
    }

    public synchronized void startup() {
        if (this.isStartup) {
            return;
        }
        try {
            AnalyzeQueue queue = AnalyzeQueueFactory.getAnalyzeQueue();
            if (queue != null) {
                new AnalyzeQueueRecoverRobo(queue).start();
                new RecheckOutLinkRecoverRobo().start();
                new RefreshThumbnailRecoverRobo().start();
                new BuildReportRecoverRobo().start();
                if (this.robots.size() == 0) {
                    String count = RidualResource.ANALYZEROBO_PROPERTIES.getString("robo.count.starting");
                    this.setRoboCount(Integer.parseInt(count));
                }
                this.isStartup = true;
            }
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("AnalyzeRoboController", e);
        }
    }

    public void setHttpProxy(String host, Integer port, String user, String password, String nonproxyhost) throws MalformedURLException {
        Properties properties;
        Properties properties2 = properties = System.getProperties();
        synchronized (properties2) {
            if (host == null || host.length() <= 0) {
                properties.remove(SYSTEM_PROPERTY_KEY_HTTP_PROXY_HOST);
                properties.remove(SYSTEM_PROPERTY_KEY_HTTP_PROXY_PORT);
                properties.remove(SYSTEM_PROPERTY_KEY_HTTP_NONPROXY_HOST);
            } else {
                int iport;
                properties.setProperty(SYSTEM_PROPERTY_KEY_HTTP_PROXY_HOST, host);
                if (port == null) {
                    properties.remove(SYSTEM_PROPERTY_KEY_HTTP_PROXY_PORT);
                    iport = -1;
                } else {
                    properties.setProperty(SYSTEM_PROPERTY_KEY_HTTP_PROXY_PORT, port.toString());
                    iport = port;
                }
                if (nonproxyhost != null && nonproxyhost.length() > 0) {
                    properties.setProperty(SYSTEM_PROPERTY_KEY_HTTP_NONPROXY_HOST, nonproxyhost);
                }
                if (user != null && user.length() > 0) {
                    this.entryProxyAuthenticator(HTTP, host, iport, user, password);
                }
            }
        }
    }

    private void entryProxyAuthenticator(String protocol, String host, int port, String user, String password) throws MalformedURLException {
        RidualAuthenticator.instance.entryProxy(protocol, host, port, user, password);
    }

    public int getRoboCount() {
        return this.robots.size();
    }

    public int getRemovingRoboCount() {
        return AnalyzeRobo.removingRobotsMap.size();
    }

    public synchronized void setRoboCount(int count) {
        int len;
        Integer cntObj = RestrictChecker.instanse.getRestrictItem().robos;
        if (cntObj != null) {
            int rlmcount = cntObj;
            int n = count = rlmcount < count ? rlmcount : count;
        }
        if (64 < count) {
            count = 64;
        }
        if (count < (len = this.robots.size())) {
            this.removeRobots(len - count);
        } else {
            this.addRobots(count - len);
        }
    }

    public void entryAnalyze(AnalyzeSiteConfigBean site) throws Throwable {
        Integer projectId = site.getProjectId();
        Integer historyId = null;
        Integer contentsId = null;
        Integer variationId = null;
        try {
            AnalyzeHistoryBean history = new AnalyzeHistoryBean();
            history.setSiteId(site.getId());
            history.setTimestampBegin(new Date());
            RestrictItem item = RestrictChecker.instanse.recheckRestrict();
            int depth = item.checkDepth(site.getDepthLimit());
            instance.setRoboCount(instance.getRoboCount());
            history.setLicense(new Integer(item.mode));
            AnalyzeHistoryDAO.instance.save(history);
            historyId = history.getId();
            AnalyzeQueue queue = AnalyzeQueueFactory.getAnalyzeQueue();
            String[] fls = Patterns.CAMMA_PATTERN.split(site.getStartURIs());
            int i = fls.length - 1;
            while (i >= 0) {
                ContentsSet contentsSet = ContentsDAO.instance.loadOrSaveWithVatiation(projectId, historyId, null, fls[i], false, null);
                contentsId = contentsSet.contents.getId();
                variationId = contentsSet.variation.getId();
                if (!contentsSet.variationIsLoad) {
                    queue.entry(historyId, contentsId, variationId, depth);
                }
                --i;
            }
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueProject(projectId, "analyzeroboController", "AnalyzeRoboController.entryAnalyze", null, t);
            throw t;
        }
    }

    public void entryRecheck(Integer historyId) throws Throwable {
        new RecheckOutLinkRobo(historyId).start();
    }

    public void removeSiteConfig(Integer siteId) throws Throwable {
        SiteAndHistoryContainer sh = AnalyzeSiteConfigDAO.instance.updateDeleteAndHistory(siteId);
        if (sh == null) {
            return;
        }
        int i = sh.historys.length - 1;
        while (i >= 0) {
            this.removeHistory(sh.historys[i], sh.site);
            --i;
        }
    }

    public void removeHistory(Integer historyId) throws Throwable {
        AnalyzeHistoryBean bean = AnalyzeHistoryDAO.instance.updateDeleteAndLocalHistory(historyId);
        if (bean == null) {
            return;
        }
        AnalyzeSiteConfigBean siteBean = AnalyzeSiteConfigDAO.instance.loadActive(bean.getSiteId());
        if (siteBean != null) {
            this.removeHistory(bean, siteBean);
        }
        WebCaptureQueueDAO.instance.deleteByHistoryId(historyId);
    }

    protected void finalize() throws Throwable {
        this.setRoboCount(0);
        super.finalize();
    }

    private void removeHistory(AnalyzeHistoryBean bean, AnalyzeSiteConfigBean site) throws Throwable {
        Integer historyId = bean.getId();
        if (bean.isDuringProcessing()) {
            if (bean.getTimestampComplete() == null) {
                AnalyzeQueueFactory.getAnalyzeQueue().removeQueue(historyId);
                return;
            }
            BuildReportRoboController.instance.cancelBuildReport(historyId);
        }
        new RemoveHistoryDirRobo(site.getProjectId(), historyId).start();
    }

    private void addRobots(int count) {
        int i = 0;
        while (i < count) {
            try {
                AnalyzeRobo robo = new AnalyzeRobo();
                robo.start();
                this.robots.add(robo);
            }
            catch (Throwable t) {
                RidualServerLogDAO.getInstance().record("AnalyzeRoboController", t);
            }
            ++i;
        }
    }

    private void removeRobots(int count) {
        int i = 0;
        while (i < count) {
            AnalyzeRobo robo = (AnalyzeRobo)this.robots.remove(0);
            robo.cancel();
            ++i;
        }
    }
}

