/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.swf;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import jp.co.iti.swf.SWFBitInputFilter;
import jp.co.iti.swf.SWFBodyException;
import jp.co.iti.swf.SWFCxform;
import jp.co.iti.swf.SWFException;
import jp.co.iti.swf.SWFHeader;
import jp.co.iti.swf.SWFHeaderException;
import jp.co.iti.swf.SWFMatrix;
import jp.co.iti.swf.SWFRect;
import jp.co.iti.swf.SWFTags;

class SWFInputStream
extends FilterInputStream {
    private static final int STRING_BUFFER_SIZE = 255;
    private int ver;

    public SWFInputStream(InputStream instream) {
        super(instream);
    }

    public SWFInputStream(String name) throws FileNotFoundException {
        super(new FileInputStream(name));
    }

    public int readUI8() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public int readUI16() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return ch1 | ch2 << 8;
    }

    public long readUI32() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read()) | (ch3 = this.in.read()) | (ch4 = this.in.read())) < 0) {
            throw new EOFException();
        }
        long result = (long)(ch1 | ch2 << 8 | ch3 << 16) | (long)ch4 << 24;
        return result;
    }

    public int readUB16() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return ch1 << 8 | ch2;
    }

    public String readString() throws IOException {
        byte[] buf = new byte[255];
        while (true) {
            StringBuffer strbuf = new StringBuffer();
            int i = 0;
            while (i < 255) {
                int ch = this.in.read();
                if (ch < 0) {
                    throw new EOFException();
                }
                if (ch == 0) {
                    if (i > 0) {
                        strbuf.append(new String(buf).substring(0, i));
                    }
                    return strbuf.toString();
                }
                buf[i] = (byte)ch;
                ++i;
            }
            strbuf.append(new String(buf));
        }
    }

    public SWFRect readRect() throws IOException {
        SWFRect rect = new SWFRect();
        SWFBitInputFilter bitfilter = new SWFBitInputFilter(this);
        int nBits = bitfilter.read(1, 5);
        rect.xMin = bitfilter.read(2, nBits);
        rect.xMax = bitfilter.read(2, nBits);
        rect.yMin = bitfilter.read(2, nBits);
        rect.yMax = bitfilter.read(2, nBits);
        return rect;
    }

    public SWFMatrix readMatrix() throws IOException {
        SWFMatrix matrix = new SWFMatrix();
        SWFBitInputFilter bitfilter = new SWFBitInputFilter(this);
        if (bitfilter.read(1, 1) != 0) {
            matrix.hasScale = true;
            int nScaleBits = bitfilter.read(1, 5);
            matrix.scaleX = bitfilter.read(1, nScaleBits);
            matrix.scaleY = bitfilter.read(1, nScaleBits);
        } else {
            matrix.hasScale = false;
        }
        if (bitfilter.read(1, 1) != 0) {
            matrix.hasRotate = true;
            int nRotateBits = bitfilter.read(1, 5);
            matrix.rotateSkew0 = bitfilter.read(1, nRotateBits);
            matrix.rotateSkew1 = bitfilter.read(1, nRotateBits);
        } else {
            matrix.hasRotate = false;
        }
        int nTranslateBits = bitfilter.read(1, 5);
        matrix.translateX = bitfilter.read(1, nTranslateBits);
        matrix.translateY = bitfilter.read(1, nTranslateBits);
        return matrix;
    }

    public SWFCxform readCxform(boolean withAlpha) throws IOException {
        SWFCxform cxform = new SWFCxform();
        SWFBitInputFilter bitfilter = new SWFBitInputFilter(this);
        cxform.hasAlpha = withAlpha;
        int hasAdd = bitfilter.read(1, 1);
        int hasMulti = bitfilter.read(1, 1);
        int nBits = bitfilter.read(1, 4);
        if (hasMulti != 0) {
            cxform.hasMulti = true;
            cxform.RedMulti = bitfilter.read(1, nBits);
            cxform.GreenMulti = bitfilter.read(1, nBits);
            cxform.BlueMulti = bitfilter.read(1, nBits);
            if (withAlpha) {
                cxform.AlphaMulti = bitfilter.read(1, nBits);
            }
        } else {
            cxform.hasMulti = false;
        }
        if (hasAdd != 0) {
            cxform.hasAdd = true;
            cxform.RedAdd = bitfilter.read(1, nBits);
            cxform.GreenAdd = bitfilter.read(1, nBits);
            cxform.BlueAdd = bitfilter.read(1, nBits);
            if (withAlpha) {
                cxform.AlphaAdd = bitfilter.read(1, nBits);
            }
        } else {
            cxform.hasAdd = false;
        }
        return cxform;
    }

    public SWFHeader readHeader() throws SWFHeaderException {
        SWFHeader header = new SWFHeader();
        try {
            int ch = this.readUI8();
            switch (ch) {
                case 70: {
                    header.isCompressed = false;
                    break;
                }
                case 67: {
                    header.isCompressed = true;
                    break;
                }
                default: {
                    throw new SWFHeaderException();
                }
            }
            ch = this.readUI8();
            if (87 != ch) {
                throw new SWFHeaderException();
            }
            ch = this.readUI8();
            if (83 != ch) {
                throw new SWFHeaderException();
            }
            header.Version = this.ver = this.readUI8();
            header.FileLength = this.readUI32();
            if (header.isCompressed) {
                this.in = new BufferedInputStream(new InflaterInputStream(this.in));
            }
            header.FrameSize = this.readRect();
            header.FrameRate = this.readUI16();
            header.FrameCount = this.readUI16();
        }
        catch (IOException e) {
            throw new SWFHeaderException();
        }
        return header;
    }

    public SWFTags readTags() throws SWFBodyException {
        SWFTags tags = new SWFTags(this.ver);
        block6: while (true) {
            try {
                while (true) {
                    int word;
                    int code;
                    if ((code = (word = this.readUI16()) >> 6) == 0) {
                        try {
                            this.readUI8();
                        }
                        catch (EOFException eOFException) {}
                        break block6;
                    }
                    long length = word & 0x3F;
                    if (63L == length) {
                        length = this.readUI32();
                    }
                    byte[] data = null;
                    if (0L < length) {
                        data = new byte[(int)length];
                        this.read(data);
                    }
                    try {
                        tags.add(code, data);
                        continue block6;
                    }
                    catch (SWFException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new SWFBodyException();
            }
        }
        return tags;
    }
}

