/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.swf;

import java.io.IOException;
import jp.co.iti.swf.SWFInputStream;

class SWFBitInputFilter {
    public static final int BYTE = 1;
    public static final int WORD = 2;
    private SWFInputStream stream;
    private int rest;
    private int data;

    public SWFBitInputFilter(SWFInputStream instream) {
        this.stream = instream;
        this.rest = 0;
    }

    public int read(int mode, int bits) throws IOException {
        int value = 0;
        int backlog = bits;
        while (backlog > 0) {
            if (this.rest <= 0) {
                switch (mode) {
                    case 1: {
                        this.data = this.stream.readUI8();
                        this.rest = 8;
                        break;
                    }
                    case 2: {
                        this.data = this.stream.readUB16();
                        this.rest = 16;
                        break;
                    }
                    default: {
                        throw new NullPointerException();
                    }
                }
            }
            if (backlog < this.rest) {
                this.rest -= backlog;
                value = value << backlog | this.data >> this.rest;
                this.data &= 65535 << this.rest ^ 0xFFFF;
                backlog = 0;
                continue;
            }
            value = value << this.rest | this.data;
            this.data = 0;
            backlog -= this.rest;
            this.rest = 0;
        }
        return value;
    }
}

