/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.sql;

import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.sql.DbSqlExprParser;
import net.morilib.db.sql.DbSqlLexer;
import net.morilib.db.sql.DbSqlReserved;
import net.morilib.db.sql.DbSqlSetParser;
import net.morilib.db.sqlcs.ddl.SqlAlterTableAdd;
import net.morilib.db.sqlcs.ddl.SqlAlterTableDrop;
import net.morilib.db.sqlcs.ddl.SqlAlterTableModify;
import net.morilib.db.sqlcs.ddl.SqlAlterTableRenameColumn;
import net.morilib.db.sqlcs.ddl.SqlColumnAttribute;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlColumnType;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;
import net.morilib.db.sqlcs.ddl.SqlDropTable;
import net.morilib.db.sqlcs.ddl.SqlTruncateTable;
import net.morilib.db.sqlcs.ddl.SqlTypeDate;
import net.morilib.db.sqlcs.ddl.SqlTypeNumeric;
import net.morilib.db.sqlcs.ddl.SqlTypeVarchar;
import net.morilib.db.sqlcs.dml.SqlBinaryOperator;
import net.morilib.db.sqlcs.dml.SqlDelete;
import net.morilib.db.sqlcs.dml.SqlExpression;
import net.morilib.db.sqlcs.dml.SqlInsertSelect;
import net.morilib.db.sqlcs.dml.SqlInsertValues;
import net.morilib.db.sqlcs.dml.SqlJoin;
import net.morilib.db.sqlcs.dml.SqlJoinType;
import net.morilib.db.sqlcs.dml.SqlOrderBy;
import net.morilib.db.sqlcs.dml.SqlRelation;
import net.morilib.db.sqlcs.dml.SqlSelect;
import net.morilib.db.sqlcs.dml.SqlSelectDistinct;
import net.morilib.db.sqlcs.dml.SqlSetExpression;
import net.morilib.db.sqlcs.dml.SqlSubqueryRelation;
import net.morilib.db.sqlcs.dml.SqlTable;
import net.morilib.db.sqlcs.dml.SqlTableColumn;
import net.morilib.db.sqlcs.dml.SqlUpdate;
import net.morilib.db.sqlcs.dml.SqlWith;

public class DbSqlParser {
    SqlExpression _join_on(DbSqlLexer lex, Map<String, SqlSetExpression> t) throws IOException, SQLException {
        if (lex.eq((Object)DbSqlReserved.ON)) {
            return new DbSqlExprParser().parse(lex, t);
        }
        return null;
    }

    SqlRelation _join(SqlRelation r, DbSqlLexer lex, Map<String, SqlSetExpression> t) throws IOException, SQLException {
        if (lex.eq((Object)DbSqlReserved.INNER)) {
            lex.eq((Object)DbSqlReserved.JOIN);
            SqlRelation s = this._relation(lex, t);
            return new SqlJoin(SqlJoinType.INNER, r, s, this._join_on(lex, t));
        }
        if (lex.eq((Object)DbSqlReserved.LEFT)) {
            lex.eq((Object)DbSqlReserved.OUTER);
            lex.eq((Object)DbSqlReserved.JOIN);
            SqlRelation s = this._relation(lex, t);
            return new SqlJoin(SqlJoinType.LEFT, r, s, this._join_on(lex, t));
        }
        if (lex.eq((Object)DbSqlReserved.RIGHT)) {
            lex.eq((Object)DbSqlReserved.OUTER);
            lex.eq((Object)DbSqlReserved.JOIN);
            SqlRelation s = this._relation(lex, t);
            throw ErrorBundle.getDefault(10022, lex.get().toString());
        }
        if (lex.eq((Object)DbSqlReserved.FULL)) {
            lex.eq((Object)DbSqlReserved.OUTER);
            lex.eq((Object)DbSqlReserved.JOIN);
            SqlRelation s = this._relation(lex, t);
            throw ErrorBundle.getDefault(10022, lex.get().toString());
        }
        if (lex.eq((Object)DbSqlReserved.OUTER)) {
            lex.eq((Object)DbSqlReserved.JOIN);
            SqlRelation s = this._relation(lex, t);
            return new SqlJoin(SqlJoinType.LEFT, r, s, this._join_on(lex, t));
        }
        if (lex.eq((Object)DbSqlReserved.NATURAL)) {
            lex.eq((Object)DbSqlReserved.JOIN);
            SqlRelation s = this._relation(lex, t);
            throw ErrorBundle.getDefault(10022, lex.get().toString());
        }
        if (lex.eq((Object)DbSqlReserved.CROSS)) {
            lex.eq((Object)DbSqlReserved.JOIN);
            SqlRelation s = this._relation(lex, t);
            throw ErrorBundle.getDefault(10022, lex.get().toString());
        }
        if (lex.eq((Object)DbSqlReserved.JOIN)) {
            SqlRelation s = this._relation(lex, t);
            return new SqlJoin(SqlJoinType.INNER, r, s, this._join_on(lex, t));
        }
        return r;
    }

    SqlRelation _relation(DbSqlLexer lex, Map<String, SqlSetExpression> t) throws IOException, SQLException {
        String s = lex.getsym();
        if (s != null) {
            lex.eqsym("AS");
            return new SqlTable(s, lex.getsym());
        }
        if (lex.eqchar('(')) {
            lex.eatsym("SELECT");
            SqlSelect q = this._select(lex, t);
            lex.eatchar(')');
            lex.eqsym("AS");
            return new SqlSubqueryRelation(q, lex.getsym());
        }
        throw ErrorBundle.getDefault(10023, new Object[0]);
    }

    SqlSelect _select(DbSqlLexer lex, Map<String, SqlSetExpression> t) throws IOException, SQLException {
        SqlSelectDistinct d;
        ArrayList<SqlTableColumn> s = new ArrayList<SqlTableColumn>();
        SqlExpression w = null;
        SqlExpression h = null;
        ArrayList<SqlRelation> f = null;
        ArrayList<SqlOrderBy> o = null;
        ArrayList<String> g = null;
        SqlSelectDistinct sqlSelectDistinct = d = lex.eqsym("DISTINCT") ? SqlSelectDistinct.DISTINCT : SqlSelectDistinct.DEFAULT;
        if (lex.eqchar('*')) {
            s.add(SqlTableColumn.WILDCARD);
        } else {
            do {
                SqlExpression e = new DbSqlExprParser().parse(lex, t);
                lex.eqsym("AS");
                s.add(new SqlTableColumn(e, lex.getsym()));
            } while (lex.eqchar(','));
        }
        if (lex.eq((Object)DbSqlReserved.FROM)) {
            f = new ArrayList<SqlRelation>();
            do {
                SqlRelation r = this._relation(lex, t);
                SqlRelation q = null;
                while ((q = this._join(r, lex, t)) != r) {
                    r = q;
                }
                f.add(r);
            } while (lex.eqchar(','));
        }
        if (lex.eq((Object)DbSqlReserved.WHERE)) {
            w = new DbSqlExprParser().parse(lex, t);
        }
        if (lex.eq((Object)DbSqlReserved.GROUP)) {
            lex.eqsym("BY");
            g = new ArrayList<String>();
            do {
                g.add(lex.getsym());
            } while (lex.eqchar(','));
        }
        if (lex.eq((Object)DbSqlReserved.HAVING)) {
            h = new DbSqlExprParser().parse(lex, t);
        }
        if (lex.eq((Object)DbSqlReserved.ORDER)) {
            lex.eqsym("BY");
            o = new ArrayList<SqlOrderBy>();
            do {
                String n = lex.getsym();
                if (lex.eqsym("ASC")) {
                    o.add(new SqlOrderBy(n, true));
                    continue;
                }
                if (lex.eqsym("DESC")) {
                    o.add(new SqlOrderBy(n, false));
                    continue;
                }
                o.add(new SqlOrderBy(n, true));
            } while (lex.eqchar(','));
        }
        return new SqlSelect(s, d, f, w, g, h, o, t);
    }

    EnumSet<SqlColumnAttribute> _ctoption(EnumSet<SqlColumnAttribute> r, DbSqlLexer lex) throws IOException, SQLException {
        if (lex.eqsym("NOT")) {
            lex.eatsym("NULL");
            r.add(SqlColumnAttribute.NOT_NULL);
            return this._ctoption(r, lex);
        }
        if (lex.eqsym("PRIMARY")) {
            lex.eatsym("KEY");
            r.add(SqlColumnAttribute.NOT_NULL);
            r.add(SqlColumnAttribute.PRIMARY_KEY);
            return this._ctoption(r, lex);
        }
        return r;
    }

    SqlColumnType _cttype(DbSqlLexer lex) throws IOException, SQLException {
        if (lex.eqsym("VARCHAR")) {
            if (lex.eqchar('(')) {
                int j = lex.eatsmallint();
                lex.eatchar(')');
                return new SqlTypeVarchar(j);
            }
            return new SqlTypeVarchar(0);
        }
        if (lex.eqsym("NUMERIC")) {
            int k;
            int j;
            if (lex.eqchar('(')) {
                j = lex.eqsym("UNLIMITED") ? 0 : lex.eatsmallint();
                k = lex.eqchar(',') ? lex.eatsmallint() : 0;
                lex.eatchar(')');
            } else {
                j = 0;
                k = 0;
            }
            return new SqlTypeNumeric(j, k);
        }
        if (lex.eqsym("DATE")) {
            return new SqlTypeDate();
        }
        throw ErrorBundle.getDefault(10024, lex.get().toString());
    }

    SqlColumnDefinition _ctcolumn(DbSqlLexer lex) throws IOException, SQLException {
        String s = lex.eatsym();
        SqlColumnType t = this._cttype(lex);
        EnumSet<SqlColumnAttribute> a = this._ctoption(EnumSet.noneOf(SqlColumnAttribute.class), lex);
        return new SqlColumnDefinition(s, t, a);
    }

    SqlCreateTable _create_table(DbSqlLexer lex) throws IOException, SQLException {
        ArrayList<SqlColumnDefinition> t = new ArrayList<SqlColumnDefinition>();
        String n = lex.getsym();
        lex.eatchar('(');
        do {
            t.add(this._ctcolumn(lex));
        } while (lex.eqchar(','));
        lex.eatchar(')');
        return new SqlCreateTable(n, t);
    }

    Object _create(DbSqlLexer lex) throws IOException, SQLException {
        if (lex.eqsym("TABLE")) {
            return this._create_table(lex);
        }
        throw ErrorBundle.getDefault(10025, lex.get().toString());
    }

    Object _insert(DbSqlLexer lex) throws IOException, SQLException {
        ArrayList<String> l = null;
        lex.eatsym("INTO");
        String t = lex.eatsym();
        if (lex.eqchar('(')) {
            l = new ArrayList<String>();
            do {
                l.add(lex.getsym());
            } while (lex.eqchar(','));
            lex.eatchar(')');
        }
        if (lex.eqsym("VALUES")) {
            lex.eatchar('(');
            ArrayList<SqlExpression> m = new ArrayList<SqlExpression>();
            do {
                m.add(new DbSqlExprParser().parse(lex, null));
            } while (lex.eqchar(','));
            lex.eatchar(')');
            return new SqlInsertValues(t, l, m);
        }
        if (lex.eqsym("SELECT")) {
            SqlSelect q = this._select(lex, null);
            return new SqlInsertSelect(t, l, q);
        }
        throw ErrorBundle.getDefault(10026, lex.get().toString());
    }

    Object _update(DbSqlLexer lex) throws IOException, SQLException {
        ArrayList<SqlExpression> l = new ArrayList<SqlExpression>();
        ArrayList<String> n = new ArrayList<String>();
        SqlExpression w = null;
        String t = lex.eatsym();
        lex.eatsym("SET");
        do {
            String s = lex.eatsym();
            lex.eat((Object)SqlBinaryOperator.EQ);
            n.add(s);
            l.add(new DbSqlExprParser().parse(lex, null));
        } while (lex.eqchar(','));
        if (lex.eq((Object)DbSqlReserved.WHERE)) {
            w = new DbSqlExprParser().parse(lex, null);
        }
        return new SqlUpdate(t, n, l, w);
    }

    Object _delete(DbSqlLexer lex) throws IOException, SQLException {
        SqlExpression w = null;
        lex.eat((Object)DbSqlReserved.FROM);
        String t = lex.eatsym();
        if (lex.eq((Object)DbSqlReserved.WHERE)) {
            w = new DbSqlExprParser().parse(lex, null);
        }
        return new SqlDelete(t, w);
    }

    Object _drop(DbSqlLexer lex) throws IOException, SQLException {
        if (lex.eqsym("TABLE")) {
            String t = lex.eatsym();
            return new SqlDropTable(t);
        }
        throw ErrorBundle.getDefault(10027, lex.get().toString());
    }

    Object _truncate(DbSqlLexer lex) throws IOException, SQLException {
        if (lex.eqsym("TABLE")) {
            String t = lex.eatsym();
            return new SqlTruncateTable(t);
        }
        throw ErrorBundle.getDefault(10028, lex.get().toString());
    }

    private void _chkattr(List<SqlColumnDefinition> t) throws SQLException {
        for (SqlColumnDefinition d : t) {
            if (d.getAttributes().contains((Object)SqlColumnAttribute.PRIMARY_KEY)) {
                throw ErrorBundle.getDefault(10029, new Object[0]);
            }
            if (!d.getAttributes().contains((Object)SqlColumnAttribute.NOT_NULL)) continue;
            throw ErrorBundle.getDefault(10030, new Object[0]);
        }
    }

    Object _alter_table(DbSqlLexer lex) throws IOException, SQLException {
        String n = lex.eatsym();
        if (lex.eqsym("ADD")) {
            ArrayList<SqlColumnDefinition> t = new ArrayList<SqlColumnDefinition>();
            lex.eatchar('(');
            do {
                t.add(this._ctcolumn(lex));
            } while (lex.eqchar(','));
            lex.eatchar(')');
            this._chkattr(t);
            return new SqlAlterTableAdd(n, t);
        }
        if (lex.eqsym("MODIFY")) {
            ArrayList<SqlColumnDefinition> t = new ArrayList<SqlColumnDefinition>();
            lex.eatchar('(');
            do {
                t.add(this._ctcolumn(lex));
            } while (lex.eqchar(','));
            lex.eatchar(')');
            this._chkattr(t);
            return new SqlAlterTableModify(n, t);
        }
        if (lex.eqsym("DROP")) {
            ArrayList<String> l = new ArrayList<String>();
            lex.eatchar('(');
            do {
                l.add(lex.eatsym());
            } while (lex.eqchar(','));
            lex.eatchar(')');
            return new SqlAlterTableDrop(n, l);
        }
        if (lex.eqsym("COLUMN")) {
            String s = lex.eatsym();
            lex.eatsym("TO");
            String v = lex.eatsym();
            return new SqlAlterTableRenameColumn(n, s, v);
        }
        throw ErrorBundle.getDefault(10031, lex.get().toString());
    }

    Object _alter(DbSqlLexer lex) throws IOException, SQLException {
        if (lex.eqsym("TABLE")) {
            return this._alter_table(lex);
        }
        throw ErrorBundle.getDefault(10032, lex.get().toString());
    }

    Object _with(DbSqlLexer lex) throws IOException, SQLException {
        LinkedHashMap<String, SqlSetExpression> m = new LinkedHashMap<String, SqlSetExpression>();
        do {
            String t = lex.eatsym();
            lex.eqsym("AS");
            m.put(t, new DbSqlSetParser().parse(lex, m));
        } while (lex.eqchar(','));
        if (lex.isEnd()) {
            return new SqlWith(m);
        }
        return new DbSqlSetParser().parse(lex, m);
    }

    Object _top(DbSqlLexer lex) throws IOException, SQLException {
        if (lex.eqsym("CREATE")) {
            return this._create(lex);
        }
        if (lex.eqsym("INSERT")) {
            return this._insert(lex);
        }
        if (lex.eqsym("UPDATE")) {
            return this._update(lex);
        }
        if (lex.eqsym("DELETE")) {
            return this._delete(lex);
        }
        if (lex.eqsym("DROP")) {
            return this._drop(lex);
        }
        if (lex.eqsym("TRUNCATE")) {
            return this._truncate(lex);
        }
        if (lex.eqsym("ALTER")) {
            return this._alter(lex);
        }
        if (lex.eqsym("WITH")) {
            return this._with(lex);
        }
        return new DbSqlSetParser().parse(lex, null);
    }

    public Object parse(DbSqlLexer lex) throws IOException, SQLException {
        Object o = this._top(lex);
        if (!lex.isEnd()) {
            throw ErrorBundle.getDefault(10033, new Object[0]);
        }
        return o;
    }

    public static Object parse(String sql) throws IOException, SQLException {
        DbSqlLexer lex = new DbSqlLexer(new StringReader(sql));
        return new DbSqlParser().parse(lex);
    }
}

