/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import net.morilib.db.jdbc.RelationsResultSet;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.NamedRelation;
import net.morilib.db.sqlcs.ddl.SqlColumnAttribute;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;

public class RelationsResultSetMetaData
implements ResultSetMetaData {
    RelationsResultSet set;

    RelationsResultSetMetaData(RelationsResultSet s) {
        this.set = s;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.set.rel.getColumnNames().size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        boolean b = this.set.rel.getColumnNames().get(column - 1).getAttributes().contains((Object)SqlColumnAttribute.NOT_NULL);
        b = b || this.set.rel.getColumnNames().get(column - 1).getAttributes().contains((Object)SqlColumnAttribute.PRIMARY_KEY);
        return b ? 0 : 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return true;
    }

    private SqlColumnDefinition getdef(int c) throws SQLException {
        if (c < 1 || c > this.set.rel.getColumnNames().size()) {
            throw ErrorBundle.getDefault(10045, c);
        }
        SqlColumnDefinition d = this.set.rel.getColumnNames().get(c - 1);
        return d;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.getdef(column).getType().getLength();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getdef(column).getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getdef(column).getName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getdef(column).getType().getLength();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getdef(column).getType().getScale();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        if (this.set.rel instanceof NamedRelation) {
            return ((NamedRelation)this.set.rel).getName();
        }
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getdef(column).getType().getSqlType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getdef(column).getType().toString();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.set.stmt.conn.engine.getSchema().isReadonly().isTrue();
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this.set.stmt.conn.engine.getSchema().isReadonly().not().isTrue();
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.set.stmt.conn.engine.getSchema().isReadonly().not().isTrue();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.getdef(column).getType().getTypeClass().toString();
    }
}

