/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.functions;

import java.sql.SQLException;
import java.util.List;
import net.morilib.db.delay.Delay;
import net.morilib.db.expr.RelationFunction;
import net.morilib.db.functions.FunctionType;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;
import net.morilib.db.relations.RelationAggregate;

public class FnCount
extends RelationFunction {
    @Override
    public Object init() throws SQLException {
        return new Delay(){
            Rational count = Rational.ZERO;

            @Override
            public Object force() throws SQLException {
                return this.count;
            }

            @Override
            public void add(Object ... args) throws SQLException {
                this.count = this.count.add(Rational.ONE);
            }
        };
    }

    public String getName() {
        return "COUNT";
    }

    @Override
    public final boolean isAggregate() {
        return true;
    }

    @Override
    public Object operate(RelationAggregate m, List<Object> group, Object ... args) throws SQLException {
        Delay d = m.get(group);
        if (args.length != 1) {
            throw ErrorBundle.getDefault(10007, this.getName());
        }
        if (!args[0].equals("")) {
            d.add(args[0]);
        }
        return d;
    }

    @Override
    public FunctionType getType() {
        return FunctionType.NUMERIC;
    }
}

