/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.db.engine.SqlEngine;
import net.morilib.db.engine.SqlEngineFactory;
import net.morilib.db.fichier.FabriqueDeFichier;
import net.morilib.db.jdbc.RelationsJDBCUtils;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;
import net.morilib.db.misc.SqlResponse;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.schema.FileSqlSchema;
import net.morilib.db.schema.HTMLSqlSchema;
import net.morilib.db.schema.MemorySqlSchema;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.schema.XlsxSqlSchema;
import net.morilib.db.sqlcs.ddl.SqlColumnAttribute;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;
import net.morilib.db.transact.RelationsTransaction;

public class RePlus {
    public static final String VERSION = "0.1.0";
    public static final int MAJOR_VERSION = 0;
    public static final int MINOR_VERSION = 0;
    private static final String PS1 = "rel>";
    private static final String PS2 = "%3d>";
    private static final String DESC_N = "NAME";
    private static final String DESC_T = "TYPE";
    private static final String DESC_A = "ATTRIBUTE";
    private static final SimpleDateFormat FM1 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final Pattern PT1 = Pattern.compile("show\\p{Space}+tables;*", 2);
    private static final Pattern PT2 = Pattern.compile("d(esc(ribe)?)?\\p{Space}+([^\\p{Space};]+|\".*\");*", 2);
    private static final Pattern PT3 = Pattern.compile("commit;*", 2);
    private static final Pattern PT4 = Pattern.compile("rollback;*", 2);

    private static void perror(int code, Object ... args) {
        System.err.println(ErrorBundle.getDefaultMessage(code, args));
    }

    private static void pout(int code, Object ... args) {
        System.out.println(ErrorBundle.getDefaultMessage(code, args));
    }

    private static boolean isquit(String s) {
        return s.equalsIgnoreCase("exit") || s.equalsIgnoreCase("quit");
    }

    private static void strrep(int x, char c) {
        int i = 0;
        while (i < x) {
            System.out.print(c);
            ++i;
        }
        System.out.print(' ');
    }

    private static int len(String s) {
        int r = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            Character.UnicodeBlock b = Character.UnicodeBlock.of(c);
            r = b == null ? ++r : (b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY) || b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS) || b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS) || b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT) || b.equals(Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT) || b.equals(Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION) || b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) || b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A) || b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B) || b.equals(Character.UnicodeBlock.KATAKANA) || b.equals(Character.UnicodeBlock.HIRAGANA) || b.equals(Character.UnicodeBlock.HANGUL_SYLLABLES) ? (r += 2) : ++r);
            ++i;
        }
        return r;
    }

    private static void lft(String s, int l) {
        int r = 0;
        int i = 0;
        while (i < s.length() && r < l) {
            char c = s.charAt(i);
            Character.UnicodeBlock b = Character.UnicodeBlock.of(c);
            r = b == null ? ++r : (b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY) || b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS) || b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS) || b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT) || b.equals(Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT) || b.equals(Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION) || b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) || b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A) || b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B) || b.equals(Character.UnicodeBlock.KATAKANA) || b.equals(Character.UnicodeBlock.HIRAGANA) || b.equals(Character.UnicodeBlock.HANGUL_SYLLABLES) ? (r += 2) : ++r);
            System.out.print(c);
            ++i;
        }
        RePlus.strrep(l - r, ' ');
    }

    private static void _print(Object o) throws IOException, SQLException {
        ArrayList<RelationTuple> l = new ArrayList<RelationTuple>();
        if (o instanceof Integer) {
            RePlus.pout(99903, ((Number)o).longValue());
        } else if (o instanceof SqlResponse) {
            System.out.println(((SqlResponse)o).toString());
        } else if (!(o instanceof Relation)) {
            System.out.println(o);
        } else {
            RelationCursor c = ((Relation)o).iterator();
            if (c.hasNext()) {
                int z;
                Object q;
                RelationTuple t;
                LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
                LinkedHashMap<String, Integer> r = new LinkedHashMap<String, Integer>();
                while (c.hasNext()) {
                    t = c.next();
                    for (String s : t.toMap().keySet()) {
                        q = t.get(s);
                        z = !(q instanceof Rational) ? 0 : (r.get(s) == null ? ((Rational)q).getScale() : Math.max((Integer)r.get(s), ((Rational)q).getScale()));
                        z = z < 4 ? z : 4;
                        r.put(s, z);
                    }
                }
                c = ((Relation)o).iterator();
                while (c.hasNext()) {
                    t = c.next();
                    l.add(t);
                    for (String s : t.toMap().keySet()) {
                        String v;
                        q = t.get(s);
                        if (q instanceof Rational) {
                            z = (Integer)r.get(s);
                            v = ((Rational)q).toBigDecimal(z).toString();
                        } else {
                            v = q instanceof Date ? FM1.format((Date)q) : q.toString();
                        }
                        z = RePlus.len(v);
                        Integer n = (Integer)m.get(s);
                        if (n != null && z <= n) continue;
                        m.put(s, RePlus.len(v));
                    }
                }
                for (String s : m.keySet()) {
                    if ((Integer)m.get(s) != 0) continue;
                    m.put(s, 5);
                }
                for (String s : m.keySet()) {
                    z = (Integer)m.get(s);
                    RePlus.lft(s, z);
                }
                System.out.println();
                for (String s : m.keySet()) {
                    z = (Integer)m.get(s);
                    RePlus.strrep(z, '-');
                }
                System.out.println();
                for (RelationTuple p : l) {
                    for (String s : m.keySet()) {
                        q = p.get(s);
                        if (q instanceof Rational) {
                            RePlus.lft(((Rational)q).toBigDecimal(4).toString(), (Integer)m.get(s));
                            continue;
                        }
                        if (q instanceof Date) {
                            RePlus.lft(FM1.format((Date)q), (Integer)m.get(s));
                            continue;
                        }
                        RePlus.lft(q.toString(), (Integer)m.get(s));
                    }
                    System.out.println();
                }
                System.out.println();
            } else {
                RePlus.pout(99907, new Object[0]);
            }
        }
    }

    private static void _showtables(Collection<String> c) {
        int m = -1;
        if (c.isEmpty()) {
            RePlus.pout(99908, new Object[0]);
        } else {
            for (String s : c) {
                int n = m = s.length() > m ? s.length() : m;
            }
            System.out.println(DESC_N);
            RePlus.strrep(m, '-');
            System.out.println();
            for (String s : c) {
                System.out.println(s.toUpperCase());
            }
            System.out.println();
        }
    }

    private static String attrtostr(EnumSet<SqlColumnAttribute> a) {
        StringBuffer b = new StringBuffer();
        String d = "";
        for (SqlColumnAttribute x : a) {
            b.append(d).append(x.toString());
            d = ",";
        }
        return b.toString();
    }

    static void _desc(SqlSchema f, String name) throws IOException, SQLException {
        SqlCreateTable c = f.getCreateTable(name);
        List<SqlColumnDefinition> l = c.getColumnDefinitions();
        int l1 = DESC_N.length();
        int l2 = DESC_T.length();
        int l3 = DESC_A.length();
        for (SqlColumnDefinition x : l) {
            int j = RePlus.len(x.getName().toUpperCase());
            l1 = j > l1 ? j : l1;
            j = RePlus.len(x.getType().toString());
            l2 = j > l2 ? j : l2;
            j = RePlus.len(RePlus.attrtostr(x.getAttributes()));
            int n = l3 = j > l3 ? j : l3;
        }
        RePlus.lft(DESC_N, l1);
        System.out.print(' ');
        RePlus.lft(DESC_T, l2);
        System.out.print(' ');
        RePlus.lft(DESC_A, l3);
        System.out.println();
        RePlus.strrep(l1, '-');
        System.out.print(' ');
        RePlus.strrep(l2, '-');
        System.out.print(' ');
        RePlus.strrep(l3, '-');
        System.out.println();
        for (SqlColumnDefinition x : l) {
            RePlus.lft(x.getName().toUpperCase(), l1);
            System.out.print(' ');
            RePlus.lft(x.getType().toString(), l2);
            System.out.print(' ');
            RePlus.lft(RePlus.attrtostr(x.getAttributes()), l3);
            System.out.println();
        }
        System.out.println();
    }

    public static SqlSchema findSchema(File f, int k, String ... args) throws IOException, SQLException {
        FabriqueDeFichier fb = FabriqueDeFichier.getDefault();
        SqlSchema fs = null;
        if (f.isFile() && f.getName().matches(".*\\.[Cc][Ss][Vv]")) {
            fs = MemorySqlSchema.readCSVs(k, args);
        } else if (f.isFile() && f.getName().matches(".*\\.[Hh][Tt][Mm][Ll]?")) {
            fs = new HTMLSqlSchema(fb.newInstance(f));
        } else if (f.isFile() && f.getName().matches(".*\\.[Xx][Ll][Ss][Xx]?")) {
            fs = new XlsxSqlSchema(fb.newInstance(f));
        } else if (f.isDirectory()) {
            fs = new FileSqlSchema(fb, fb.newInstance(f));
        }
        return fs;
    }

    private static void putex(boolean dg, SQLException e) {
        if (dg) {
            e.printStackTrace();
        }
        System.err.format("ERROR REL-%d: %s\n", e.getErrorCode(), e.getMessage());
    }

    public static void main(String[] args) {
        int k;
        StringBuffer b = new StringBuffer();
        final boolean[] dg = new boolean[1];
        boolean tf = true;
        dg[0] = false;
        for (k = 0; args.length > k; ++k) {
            if (args[k].equals("--transaction")) {
                tf = true;
                continue;
            }
            if (args[k].equals("--autocommit")) {
                tf = false;
                continue;
            }
            if (!args[k].equals("--debug")) break;
            dg[0] = true;
            RelationsJDBCUtils.logger = RelationsJDBCUtils.DEBUG;
        }
        if (args.length <= k) {
            RePlus.perror(99901, "(unspecified)");
            System.exit(86);
            return;
        }
        File f = new File(args[k]);
        try {
            String s;
            SqlSchema fs = RePlus.findSchema(f, k, args);
            if (fs == null) {
                RePlus.perror(99902, f.toString());
                System.exit(86);
                return;
            }
            final SqlEngine en = tf ? new RelationsTransaction(fs) : SqlEngineFactory.getInstance().getEngine(fs);
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        RePlus.pout(99906, new Object[0]);
                        en.rollback();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    catch (SQLException e) {
                        RePlus.putex(dg[0], e);
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(t);
            BufferedReader rd = new BufferedReader(new InputStreamReader(System.in));
            System.out.print(PS1);
            int l = 1;
            while ((s = rd.readLine()) != null) {
                try {
                    Matcher m;
                    if (b.length() == 0 && RePlus.isquit(s)) {
                        Runtime.getRuntime().removeShutdownHook(t);
                        en.commit();
                        System.exit(0);
                        continue;
                    }
                    if (b.length() == 0 && PT1.matcher(s).matches()) {
                        RePlus._showtables(fs.getTableNames());
                        b = new StringBuffer();
                        l = 1;
                        System.out.print(PS1);
                        continue;
                    }
                    if (b.length() == 0 && (m = PT2.matcher(s)).matches()) {
                        s = m.group(3);
                        s = s.replaceFirst("^\"", "");
                        s = s.replaceFirst("\"$", "");
                        RePlus._desc(fs, s);
                        b = new StringBuffer();
                        l = 1;
                        System.out.print(PS1);
                        continue;
                    }
                    if (b.length() == 0 && PT3.matcher(s).matches()) {
                        en.commit();
                        RePlus.pout(99904, new Object[0]);
                        System.out.print(PS1);
                        continue;
                    }
                    if (b.length() == 0 && PT4.matcher(s).matches()) {
                        en.rollback();
                        RePlus.pout(99905, new Object[0]);
                        System.out.print(PS1);
                        continue;
                    }
                    if (s.length() == 0) {
                        b = new StringBuffer();
                        l = 1;
                        System.out.print(PS1);
                        continue;
                    }
                    if (!s.endsWith(";")) {
                        b.append(s).append('\n');
                        System.out.format(PS2, ++l);
                        continue;
                    }
                    b.append(s).deleteCharAt(b.length() - 1);
                    Object o = en.execute(b.toString());
                    RePlus._print(o);
                    b = new StringBuffer();
                    l = 1;
                    System.out.print(PS1);
                }
                catch (SQLException e) {
                    RePlus.putex(dg[0], e);
                    b = new StringBuffer();
                    l = 1;
                    System.out.print(PS1);
                }
            }
            System.exit(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

