/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.nexaweb.parser;

import com.nexaweb.xml.Element;
import com.nexaweb.xml.xpath.XPathFactory;

/**
 * <p>[概 要] </p>
 * comboBoxエレメントの保持する値を取得します。
 * 
 * <p>[詳 細] </p>
 * comboBoxエレメントの値を取得する為の
 * {@link Parser#parse(Element)}を実装します。
 * 
 * <p>[備 考] </p>
 * このクラスはElementValueParserによってインスタンス化され、使用されます。<br>
 * 詳細は{@link ElementValueParser#parse(Element)}を参照して下さい。
 * 
 * <p>[環 境] JDK 6.0 Update 11</p>
 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
 * 
 * @author Project Reffi
 */
public class ComboBoxValueParser implements Parser {

	/**
	 * <p>[概 要] </p>
	 * Protectedコンストラクタです。
	 * 
	 * <p>[詳 細] </p>
	 * デフォルト処理は有りません。
	 * 
	 * <p>[備 考] </p>
	 * comboBoxエレメント値をパースするには
	 * {@link ElementValueParser#parse(Element)}
	 * を使用して下さい。
	 */
	protected ComboBoxValueParser() {
	}

	/**
	 * <p>[概 要] </p>
	 * comboBoxの値を取得します。
	 * 
	 * <p>[詳 細] </p>
	 * comboBoxエレメントの子要素listBox/listItemの内、selected属性値がtrueのものを調べ、<br>
	 * そのlistItemからvalue属性値を取得、name属性値=value属性値でElementValueオブジェクトを生成します。<br>
	 * 生成されたElementValueオブジェクトはElementValuesオブジェクトの
	 * インデックス0として返却されます。
	 * 
	 * <p>[備 考] </p>
	 * selected属性がついていない場合は空文字が返却されます。
	 * 
	 * @param comboBox 値をパースするcomboBoxエレメント
	 */
	public ElementValues parse(Element comboBox) {
		ElementValues ret = new ElementValues();

		String name = comboBox.getAttribute("name");

		Element selectedElement = XPathFactory.createXPath(
				"listBox/listItem[@selected='true']").evaluateAsElement(
				comboBox);

		ElementValue elementValue = null;
		if (selectedElement != null) {
			elementValue = new ElementValue(name, selectedElement
					.getAttribute("value"));
			ret.addElementValue(elementValue);
		}

		return ret;
	}
}
